class FortunePlugin < Plugin
  def help(plugin, topic="")
    "fortune [<module>] => get a (short) fortune, optionally specifying fortune db, fortune list => list available fortune dbs"
  end
  def privmsg(m)
    case m.params
    when (/\B-/)
      m.reply "incorrect usage: " + help(m.plugin)
      return
    when "list"
      list = Utils.safe_exec("/usr/games/fortune", "-f")
      ret = Array.new
      list.each_line{|line|
        next if line =~ /^100.00%/
        line.gsub!(/^[\d.%\s]*/, "")
        line.strip!
        ret << line if line.length > 1
      }
      m.reply ret.join(", ")
      return
    when (/^([\w-]+)$/)
      db = $1
    when nil
      db = "fortunes"
    else
      m.reply "incorrect usage: " + help(m.plugin)
      return
    end
    ret = Utils.safe_exec("/usr/games/fortune", "-s", db)
    m.reply ret.split("\n").join(" ")
    return
  end
end
plugin = FortunePlugin.new
plugin.register("fortune")
