// 
// $Id: qaregexpmatch.cpp,v 1.3 1999/07/19 02:36:55 amos Exp $
//
// Implementation of QaRegExpMatch class
//
// Jan Borsodi <amos@ez.no>
// Created on: <15-Jul-1999 13:53:16 amos>
//

#include "qaregexpmatch.hpp"
#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>

/*!
  \class QaRegExpMatch qaregexpmatch.hpp
  \brief Holds match offset and strings from a previous match.

  It keeps a list of QaRegExpRange's from a match done earlier.
  It will also calculate the match strings on demand.
*/

/*!
  An empty match.
*/

QaRegExpMatch::QaRegExpMatch()
{
}

/*!
  Just the string
*/

QaRegExpMatch::QaRegExpMatch( const QString &s )
{
    String = s;
}

/*!
  A match of the given string.
*/

QaRegExpMatch::QaRegExpMatch( const QString &s, const regmatch_t m[], int size )
{
    String = s;
    for ( int i = 0; i < size; i++ )
    {
        appendMatch( QaRegExpRange( m[i].rm_so, m[i].rm_eo ) );
    }
}

/*!
  Destroys the object
*/

QaRegExpMatch::~QaRegExpMatch()
{
}

/*!
  Appends a match range to the list.
*/

void QaRegExpMatch::appendMatch( const QaRegExpRange &r )
{
    Matches.append( r );
    List.append( "" );
    int s = Calc.size();
    Calc.resize( s + 1 );
    Calc[s] = false;
}

/*!
  Will calculate the substrings of the match if not already done.
  \return A list of strings.
*/

const QStringList &QaRegExpMatch::toString()
{
    int i = 0;
    for ( QValueList<QaRegExpRange>::Iterator it = Matches.begin(); it != Matches.end(); ++it, ++i )
    {
        if ( Calc[i] == false )
        {
            if ( (*it).start() != -1 )
            {
                List[i] = String.mid( (*it).start(), (*it).length() );
                Calc[i] = true;
            }
        }
    }
    return List;
}

/*!
  \return The given substring.
*/

const QString &QaRegExpMatch::toString( int o )
{
    if ( Calc[o] == false )
    {
        List[o] = String.mid( Matches[o].start(), Matches[o].length() );
    }
    return List[o];
}


/*!
  \return The range of a given subexpression.
*/

const QaRegExpRange &QaRegExpMatch::operator[]( int o ) const
{
    // Fix this one later
//      if ( o < 0 || o >= Matches.count() )
//          throw OutOfRangeException;
    return Matches[o];
}
