/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#ifndef _rfb_OXServiceApplet_h_
#define _rfb_OXServiceApplet_h_

#include <xclass/OXClient.h>
#include <xclass/OXMainFrame.h>
#include <xclass/OXMenu.h>
#include <xclass/OXIcon.h>
#include <xclass/OXCompositeFrame.h>
#include <xclass/OFileHandler.h>

#include "xclass++.h"

class OXServiceApplet: public OXMainFrame
{
  public:
    OXServiceApplet( OXClient *_client, int port );
    virtual ~OXServiceApplet();

    virtual int HandleButton(XButtonEvent * /*event*/);
    
    virtual int ProcessMessage( OMessage *msg );

    virtual void Layout();
    
    void SetIcon( int _connected );

  private:

    LAYOUT_HINTS;

    OXPopupMenu *popupMenu;

    OXIcon *iconViewer;
    OXCompositeFrame *frameDisplay;
    int connected;
};


#endif //_rfb_OXServiceApplet_h_
