gtkTargetEntry <-
  gtkTargetEntryNew <-
function(target, flags, info)
{
  .Call("S_newTargetEntry", as.character(target), as.integer(flags), as.integer(info))
}  


gtkDragDestSet <-
function(widget, flags, targets, actions)
{
   flags <- mapGtkDestDefaults(flags)
   .gtkDragSet(widget, flags, targets, actions, TRUE)
}

gtkDragSourceSet <-
function(widget, flags, targets, actions)
{
   flags <- mapGdkModifierType(flags)
   .gtkDragSet(widget, flags, targets, actions, FALSE)
}


.gtkDragSet <-
function(widget, flags, targets, actions, isDest = TRUE)
{
   gtkCheckInherits(widget, "GtkWidget")
   actions <- mapGdkDragAction(actions)
   cat("Ok")
   print(targets)
   if(inherits(targets, "GtkTargetEntry")) {
     targets <- list(targets)
   } else if(!all(sapply(targets, function(x) inherits(x, "GtkTargetEntry")))) {
      stop("all targets must be GtkTargetEntry objects!")
   }
   .Call("R_gtkDragDestSet", widget, flags, targets, actions, as.logical(isDest))
}

gtkSelectionDataSet <-
function(data, type, format, value)
{
  gtkCheckInherits(data, "GtkSelectionData")
  gtkCheckInherits(type, "GdkAtom", nullOk = TRUE)
  format <- as.integer(format)
  value <- as.character(value)

  .Call("R_gtkSelectDataSet", data, type, format, value)
}  

"[[.GtkSelectionData" <-
function(x, name)
{
  gtkCheckInherits(x, "GtkSelectionData")
  .Call("R_gtkSelectionDataField", x, as.character(name))
}  


