#include "RGtk.h"
#include "gtkUtils.h"

/**


 */

void R_setReturnValue(USER_OBJECT_ value, GtkArg *arg);

void
R_gtkFreeCBData(gpointer  data)
{

    R_gtk_CallbackData *cbdata;
    cbdata = (R_gtk_CallbackData*) data;

#ifdef RGTK_DEBUG
    fprintf(stderr,"Freeing callback data (id = %d) [%p]\n",
                       cbdata->type == RGTK_CALLBACK ? -1 : cbdata->id, cbdata);fflush(stderr);
#endif

    R_ReleaseObject(cbdata->function);
    if(cbdata->useData && cbdata->data != NULL)
	R_ReleaseObject(cbdata->data);

    g_free(cbdata);
}


void
RGtk_CallbackMarshal(GtkObject *o, gpointer data, guint nargs, GtkArg *args) 
{
    USER_OBJECT_ sarg;
    USER_OBJECT_ val;
    USER_OBJECT_ e, tmp, sobj;
    R_gtk_CallbackData *cbdata;
    int errorOccurred = 0;
    int i, numProtects = 0;
    USER_OBJECT_ envir = R_GlobalEnv;

    cbdata = (R_gtk_CallbackData*) data;

    if(TYPEOF(cbdata->function) == CLOSXP) {
	PROTECT(e = allocVector(LANGSXP, nargs + 2 + (cbdata->useData == TRUE)));
	SETCAR(e, cbdata->function);
	numProtects++;
	tmp = CDR(e);
    
	if(cbdata->useData && cbdata->userDataFirst) {
	    SETCAR(tmp, cbdata->data);
	    tmp = CDR(tmp);
	}

	SETCAR(tmp, sobj = toRPointer(o, "GtkObject"));
	SET_CLASS(sobj, R_internal_getTypeHierarchy(GTK_OBJECT_TYPE(o)));
	tmp = CDR(tmp);

	for(i = 0; i < nargs; i++) {
	    sarg = convertGtkArgToSValue(args[i]);
	    SETCAR(tmp, sarg);
	    tmp = CDR(tmp);
	}

	if(cbdata->useData && cbdata->userDataFirst == FALSE) {
	    SETCAR(tmp, cbdata->data);
	}
    } else {
	e = cbdata->function; 
	if(cbdata->data && cbdata->data != NULL_USER_OBJECT && TYPEOF(cbdata->data) == ENVSXP) {
  	    envir = cbdata->data;
	}
    }


 
    val = R_tryEval(e, envir, &errorOccurred);
    if(errorOccurred || args[nargs].type == GTK_TYPE_NONE) {
	UNPROTECT(numProtects);
        return;
    }

    PROTECT(val);
    numProtects++;

    /* Now put the return value back in the argument list. */
       
    R_setReturnValue(val, args+nargs);
    UNPROTECT(numProtects);    
}


USER_OBJECT_
R_gtk_setCallback(USER_OBJECT_ swidget, USER_OBJECT_ sfunc, USER_OBJECT_ signalName, 
                    USER_OBJECT_ data, USER_OBJECT_ useData, USER_OBJECT_ asObject,
                     USER_OBJECT_ after)
{
    R_gtk_CallbackData *cbdata;
    GtkObject *w;
    gint id;
    USER_OBJECT_ ans;

    w = (GtkObject*) getPtrValue(swidget);
    cbdata = (R_gtk_CallbackData*) g_malloc(sizeof(R_gtk_CallbackData));
    if(!cbdata) {
     PROBLEM "Cannot allocate space for a measly R_gtk_CallbackData!"
     ERROR;
    }
#if 0
    id = gtk_signal_connect_object(GTK_OBJECT(w), CHAR_DEREF(STRING_ELT(signalName, 0)),
                                     R_gtk_functionCallback, (gpointer) cbdata);
#else
    id = gtk_signal_connect_full(GTK_OBJECT(w), CHAR_DEREF(STRING_ELT(signalName, 0)),
				   NULL, 
                                   RGtk_CallbackMarshal,
  				   (gpointer) cbdata,
				   R_gtkFreeCBData /* XXX check this! */,
                                   LOGICAL_DATA(asObject)[0], 
                                   (gint) LOGICAL_DATA(after)[0]);
#endif
    if(id == 0) {
        free(cbdata);
	PROBLEM "Couldn't register callback %s. Check name",
                      CHAR_DEREF(STRING_ELT(signalName, 0)) 
        ERROR;
    }

    R_PreserveObject(sfunc);
    if(LOGICAL_DATA(useData)[0]) {
	R_PreserveObject(data);
        cbdata->data = data;
        cbdata->useData = TRUE;
    } else {
        cbdata->useData = FALSE;
	cbdata->data = NULL;
    }

    cbdata->type = RGTK_CALLBACK;
    cbdata->function = sfunc;
    cbdata->userDataFirst = LOGICAL_DATA(asObject)[0];

    PROTECT(ans = NEW_INTEGER(1));
     INTEGER_DATA(ans)[0] = id;
     SET_NAMES(ans, signalName);
     SET_CLASS(ans, asRCharacter("CallbackID"));
    UNPROTECT(1);

    return(ans);
}


USER_OBJECT_
R_gtk_disconnectSignalHandler(USER_OBJECT_ swidget, USER_OBJECT_ sid)
{
    gint id = INTEGER_DATA(sid)[0];
    GtkObject *obj = GTK_OBJECT(getPtrValue(swidget));
    USER_OBJECT_ ans = NEW_LOGICAL(1);
    gtk_signal_disconnect(obj, id);
    LOGICAL_DATA(ans)[0] = TRUE;
    return(ans);
}

USER_OBJECT_
R_gtk_blockSignalHandler(USER_OBJECT_ swidget, USER_OBJECT_ sid, USER_OBJECT_ on)
{
    gint id = INTEGER_DATA(sid)[0];
    GtkObject *obj = GTK_OBJECT(getPtrValue(swidget));
    USER_OBJECT_ ans = NEW_LOGICAL(1);
    if(LOGICAL_DATA(on)[0])
	gtk_signal_handler_block(obj, id);
    else
	gtk_signal_handler_unblock(obj, id);

    LOGICAL_DATA(ans)[0] = TRUE;

    return(ans);
}


USER_OBJECT_
S_gtkSignalEmit(USER_OBJECT_ sobj, USER_OBJECT_ signal, USER_OBJECT_ sargs)
{
    GtkArg *args;
    int n, i;
    GtkObject *obj;
    USER_OBJECT_ ans = NULL_USER_OBJECT;
    guint sigId;
    char *sigName;
    GtkSignalQuery *sigInfo;
    char retVal[sizeof(GtkArg)];

    obj = GTK_OBJECT(getPtrValue(sobj));

    n = GET_LENGTH(sargs);
    args = (GtkArg*) R_alloc(n + 1, sizeof(GtkArg));

    sigName = CHAR_DEREF(STRING_ELT(signal, 0));
    sigId = gtk_signal_lookup(sigName, GTK_OBJECT_TYPE(obj));
    sigInfo = gtk_signal_query(sigId);
    
    for(i = 0; i < n; i++) {
	R_setArgFromSValue(VECTOR_ELT(sargs, i), args+i);
        args[i].type = sigInfo->params[i];
        args[i].name = NULL;
    }

/*
 Setup the return value with something sensible:  value and type.
*/
    args[n].type = sigInfo->return_val;
    args[n].name = NULL;
    args[n].d.pointer_data = retVal;

    gtk_signal_emitv(obj, sigId, args);

    if(args[n].type != GTK_TYPE_NONE) {
       ans = convertGtkArgToSValue(args[n]);
    }

    g_free(sigInfo);

    return(ans);
}


gboolean
R_gtkTimeoutHandler(R_gtk_CallbackData *cbdata)
{
    gboolean val = FALSE;
    SEXP e, sval;
    int errorOccurred;

    PROTECT(e = allocVector(LANGSXP, 1 + (cbdata->useData == TRUE ? 1 : 0)));

    SETCAR(e, cbdata->function);
    if(cbdata->useData) {
	SETCAR(CDR(e), cbdata->data);
    }
    sval = R_tryEval(e, R_GlobalEnv, &errorOccurred);

    if(!errorOccurred) {
 	if(TYPEOF(sval) != LGLSXP) {
	    fprintf(stderr, "This %s handler (%ud) didn't return a logical value. Removing it.\n",
                          cbdata->type == RGTK_TIMER ? "timer" : "idle", cbdata->id);
            fflush(stderr);
	    val = FALSE;
	} else
	    val = LOGICAL_DATA(sval)[0];
    }
    UNPROTECT(1);

    return(val);
}

USER_OBJECT_
R_gtkAddTimeout(USER_OBJECT_ sinterval, USER_OBJECT_ sfunc, USER_OBJECT_ data, USER_OBJECT_ useData)
{

    USER_OBJECT_ ans;
    guint id;
    R_gtk_CallbackData *cbdata;

    cbdata = (R_gtk_CallbackData*) malloc(sizeof(R_gtk_CallbackData));

    R_PreserveObject(sfunc);
    cbdata->function = sfunc;
    cbdata->type = RGTK_TIMER;
    if(LOGICAL_DATA(useData)[0]) {
	R_PreserveObject(data);
        cbdata->data = data;
        cbdata->useData = TRUE;
    } else {
        cbdata->useData = FALSE;
	cbdata->data = NULL;
    }

    id = gtk_timeout_add(INTEGER_DATA(sinterval)[0], (GtkFunction) R_gtkTimeoutHandler, cbdata);

    cbdata->id = id;    

    PROTECT(ans = NEW_INTEGER(1));
    INTEGER_DATA(ans)[0] = id;
    SET_CLASS(ans, asRCharacter("GtkTimeoutId"));
    UNPROTECT(1);
    return(ans);
}


USER_OBJECT_
R_gtkRemoveTimeout(USER_OBJECT_ id)
{
    USER_OBJECT_ ans;
    gtk_timeout_remove(INTEGER_DATA(id)[0]);

    ans = NEW_LOGICAL(1);
    LOGICAL_DATA(ans)[0] = TRUE;

    return(ans);
}



USER_OBJECT_
R_gtkAddIdle(USER_OBJECT_ sfunc, USER_OBJECT_ data, USER_OBJECT_ useData)
{
    USER_OBJECT_ ans;
    guint id;
    R_gtk_CallbackData *cbdata;

    cbdata = (R_gtk_CallbackData*) malloc(sizeof(R_gtk_CallbackData));

    R_PreserveObject(sfunc);
    cbdata->function = sfunc;
    cbdata->type = RGTK_IDLE;
    if(LOGICAL_DATA(useData)[0]) {
	R_PreserveObject(data);
        cbdata->data = data;
        cbdata->useData = TRUE;
    } else {
        cbdata->useData = FALSE;
	cbdata->data = NULL;
    }

    id = gtk_idle_add((GtkFunction) R_gtkTimeoutHandler, cbdata);
    cbdata->id = id;        

    PROTECT(ans = NEW_INTEGER(1));
    INTEGER_DATA(ans)[0] = id;
    SET_CLASS(ans, asRCharacter("GtkIdleId"));
    UNPROTECT(1);
    return(ans);
}

USER_OBJECT_
R_gtkRemoveIdle(USER_OBJECT_ id)
{
    USER_OBJECT_ ans;
    gtk_timeout_remove(INTEGER_DATA(id)[0]);

    ans = NEW_LOGICAL(1);
    LOGICAL_DATA(ans)[0] = TRUE;

    return(ans);
}

void
R_setReturnValue(USER_OBJECT_ value, GtkArg *arg)
{

    switch(GTK_FUNDAMENTAL_TYPE(arg->type)) {
      case GTK_TYPE_NONE:
      case GTK_TYPE_INVALID:
	  return;
	  break;
      case GTK_TYPE_BOOL:
	  *GTK_RETLOC_BOOL(*arg) = asLogical(value);
	  break;
      case GTK_TYPE_INT:
	  *GTK_RETLOC_INT(*arg) = asInteger(value);
	  break;
      case GTK_TYPE_UINT:
	  *GTK_RETLOC_UINT(*arg) = asInteger(value);
	  break;
      case GTK_TYPE_LONG:
	  *GTK_RETLOC_LONG(*arg) = asInteger(value);
	  break;
      case GTK_TYPE_ULONG:
	  *GTK_RETLOC_ULONG(*arg) = asReal(value);
	  break;
      case GTK_TYPE_FLOAT:
	  *GTK_RETLOC_FLOAT(*arg) = asReal(value);
	  break;
      case GTK_TYPE_DOUBLE:
	  *GTK_RETLOC_DOUBLE(*arg) = asReal(value);
	  break;
      case GTK_TYPE_STRING:
      {
	  SEXP val = asChar(value);
	  if(val && CHAR(val))
	      *GTK_RETLOC_STRING(*arg) = g_strdup(CHAR(val));
          else
	      *GTK_RETLOC_STRING(*arg) = NULL;
	  break;
      }
    default:
	fprintf(stderr, "Unhandled case %d\n", GTK_FUNDAMENTAL_TYPE(arg->type));fflush(stderr);
	break;
    }

}
