/*
 *  common.c             -
 *
 *  Created: 20020112
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: common.c,v 1.9 2002/03/19 21:58:44 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <common.h>

#include <gdk/gdkkeysyms.h>

/* Funkcja oscugujca sygna "key_press_event" okienka dialogowego. */
gboolean dialog_key_press(GtkWidget *widget, GdkEventKey *event, GtkWidget *dialog)
{
    g_assert(dialog != NULL);
    
    /* Zamykanie okienka dialogowego w wypadku nacinicia klawisza Esc. */
    if (event && event->keyval == GDK_Escape)
        gtk_widget_destroy(dialog);
    
    return TRUE;
}

/* Funkcja obsugujca wcinicie przycisku "Anuluj" okienka dialogowego. */
void dialog_delete(GtkWidget *widget, GtkWidget *dialog)
{
    g_assert(dialog != NULL);

    /* Zamyka okienko dialogowe. */
    gtk_widget_destroy(dialog);
}

/* Funkcja zwalniajca pami zajmowan przez element listy. Wykorzystywana przez funkcj
   create_save_as_list i create_days_list do wywoania g_list_foreach. */
void free_list_item_callback(gpointer data, gpointer user_data)
{
    g_free(data);
}
