/*
 *  fields-dialog.c      -
 *
 *  Created: 20020312
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: fields-dialog.c,v 1.14 2002/03/19 22:49:29 tomek Exp $
 *
 */

/*
 *  TODO:
 *   1. Wykorzysta listy z moliwoci wybierania wielu elementw.
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <fields-dialog.h>

#include <intl.h>
#include <gdk/gdkkeysyms.h>
#include <globals.h>

/* Struktura zawierajca dane okienka dialogowego. */
typedef struct
{
    fields_list_type      list;
    GtkWidget             *dialog;
    GList                 *old_id_list;
    GtkWidget             *available_list;
    GtkWidget             *visible_list;
    GtkWidget             *available_list_item;
    GtkWidget             *visible_list_item;
} fields_dialog_data;

/* Tworzenie elementu listy. */
static GtkWidget *make_list_item(fields_dialog_data *data, guint item_id)
{
    GtkWidget *item;
    
    item = gtk_list_item_new_with_label(gettext(fields_list_items[data->list][item_id].name));
    gtk_widget_show(item);
    
    gtk_object_set_data(GTK_OBJECT(item), "id", (gpointer)item_id);
    
    return item;
}

/* Funkcja tworzca list dostpnych pl okienka dialogowego. */
static void make_list_available_fields(fields_dialog_data *data)
{
    gint i;
    
    /* Usuwanie starej listy. */
    gtk_list_clear_items(GTK_LIST(data->available_list), 0, 
                         g_list_length(GTK_LIST(data->available_list)->children));
    
    /* Tworzenie zawartoci listy. */
    for (i = 0; i < list_items_length(data->list); i++)
        if (g_list_index(list_params[data->list].id_list, (gpointer)i) == -1)
            gtk_container_add(GTK_CONTAINER(data->available_list), make_list_item(data, i));
}

/* Funkcja tworzca list wywietlanych pl okienka dialogowego. */
static void make_list_visible_fields(fields_dialog_data *data)
{
    GList *tmp_list = list_params[data->list].id_list;
    
    while (tmp_list != NULL)
    {
        gtk_container_add(GTK_CONTAINER(data->visible_list),
	                  make_list_item(data, (gint)tmp_list->data));
    
        tmp_list = g_list_next(tmp_list);
    }
}

/* Funkcja obsugujca sygna "clicked" przycisku "Dodaj". */
static void add_button_clicked(GtkWidget *widget, fields_dialog_data *data)
{
    guint item_id;
    
    g_assert(data != NULL);
    
    if (data->available_list_item != NULL)
    {
        /* Pobieranie identyfikatora elementu listy */
        item_id = (gint)gtk_object_get_data(GTK_OBJECT(data->available_list_item), "id");
        
        /* Usuwanie elementu z listy dostpnych pl. */
        gtk_container_remove(GTK_CONTAINER(data->available_list), data->available_list_item);
	
	/* Utworzenie i wstawianie elementu do listy wywietlanych pl. */
	gtk_container_add(GTK_CONTAINER(data->visible_list), make_list_item(data, item_id));
	
	/* Dodanie identyfikatora elementu do listy elementw. */ /* ?? */
	list_params[data->list].id_list = g_list_append(list_params[data->list].id_list,
	                                                (gpointer)item_id);
    }
}

/* Funkcja obsugujca sygna "clicked" przycisku "Usu". */
static void remove_button_clicked(GtkWidget *widget, fields_dialog_data *data)
{
    guint item_id;
    
    g_assert(data != NULL);
    
    if (data->visible_list_item != NULL)
    {
        /* Pobieranie identyfikatora elementu listy. */
	item_id = (gint)gtk_object_get_data(GTK_OBJECT(data->visible_list_item), "id");
	
	/* Usuwanie elementu z listy wywietlanych pl. */
	gtk_container_remove(GTK_CONTAINER(data->visible_list), data->visible_list_item);
	
	/* Usunicie identyfikatora elementu z listy elementw. */
	list_params[data->list].id_list = g_list_remove(list_params[data->list].id_list,
	                                                (gpointer)item_id);
	
	/* Utworzenie listy dostpnych elementw. */
	make_list_available_fields(data);
    }
}

/* Funkcja obsugujca sygna "clicked" przycisku "W gr". */
static void up_button_clicked(GtkWidget *widget, fields_dialog_data *data)
{
    g_assert(data != NULL);

    if (data->visible_list_item != NULL)
    { 
        gint item_id;
        gint position;
    
        /* Pobranie identyfikatora zaznaczonego elementu listy. */
	item_id = (gint)gtk_object_get_data(GTK_OBJECT(data->visible_list_item), "id");
	
	/* Pobieranie pozycji zaznaczonego elementu na licie wywietlanych elementw. */
	position = gtk_list_child_position(GTK_LIST(data->visible_list), data->visible_list_item);
	
	if (position != 0)
	{
	    /* Usunicie zaznaczonego elementu z listy wywietlanych pl. */
	    gtk_container_remove(GTK_CONTAINER(data->visible_list), data->visible_list_item);
	    
	    /* Usunicie identyfikatora zaznaczonego elementu z listy identyfikatorw
	       wywietlanych pl. */
	    list_params[data->list].id_list = g_list_remove(list_params[data->list].id_list,
	                                                    (gpointer)item_id);
	
	    /* Utworzenie i wstawienie elementu do listy wywietlanych pl na pozycji
	       zmniejszonej o 1. */
	    gtk_list_insert_items(GTK_LIST(data->visible_list),
	                          g_list_append(NULL, (gpointer)make_list_item(data, item_id)),
				  position - 1);
	    
	    /* Wstawienie identyfikatora zaznaczonego elementu do listy identyfikatorw
	       wywietlanych pl na pozycji zmniejszonej o 1. */
	    list_params[data->list].id_list = g_list_insert(list_params[data->list].id_list,
	                                                    (gpointer)item_id, position - 1);
	    
	    /* Zaznaczenie przesunitego elementu. */
	    gtk_list_select_item(GTK_LIST(data->visible_list), position - 1);
	}
    }
}

/* Funkcja obsugujca sygna "clicked" przycisku "W d". */
static void down_button_clicked(GtkWidget *widget, fields_dialog_data *data)
{
    g_assert(data != NULL);

    if (data->visible_list_item != NULL)
    {
        gint item_id;
	gint position;
	
        /* Pobranie identyfikatora zaznaczonego elementu listy. */
	item_id = (gint)gtk_object_get_data(GTK_OBJECT(data->visible_list_item), "id");
	
	/* Pobieranie pozycji zaznaczonego elementu na licie wywietlanych pl. */
	position = gtk_list_child_position(GTK_LIST(data->visible_list), data->visible_list_item);
	
	if (position != g_list_length(GTK_LIST(data->visible_list)->children))
	{
	    /* Usunicie zaznaczonego elementu z listy wywietlanych pl. */
	    gtk_container_remove(GTK_CONTAINER(data->visible_list), data->visible_list_item);
	    
	    /* Usunicie identyfikatora zaznaczonego elementu z listy identyfikatorw
	       wywietlanych pl. */
	    list_params[data->list].id_list = g_list_remove(list_params[data->list].id_list,
	                                                    (gpointer)item_id);
	
	    /* Utworzenie i wstawienie elementu do listy wywietlanych pl na pozycji
	       zwikszonej o 1. */
	    gtk_list_insert_items(GTK_LIST(data->visible_list),
	                          g_list_append(NULL, (gpointer)make_list_item(data, item_id)),
				  position + 1);
	    
	    /* Wstawianie identyfikatora zaznaczonego elementu do listy identyfikatorw
	       wywietlanych pl na pozycji zwikszonej o 1. */
	    list_params[data->list].id_list = g_list_insert(list_params[data->list].id_list,
	                                                    (gpointer)item_id, position + 1);
	    
	    /* Zaznaczenie przesunitego elementu. */
	    gtk_list_select_item(GTK_LIST(data->visible_list), position + 1);
	}
    }
}

/* Funkcja obsugujca sygna "select-child" listy dostpnych lub wywietlanych pl. */
static void list_select_child(GtkList *list, GtkWidget *widget, GtkWidget **list_item)
{
    g_assert(widget != NULL);
    g_assert(list_item != NULL);
    
    *list_item = widget;
}

/* Funkcja obsugujca sygna "select-child" listy dostpnych lub wyswietlanych pl. */
static void list_unselect_child(GtkList *list, GtkWidget *widget, GtkWidget **list_item)
{
    g_assert(list_item != NULL);

    *list_item = NULL;
}

/* Funkcja obsugujca sygna "clicked" przycisku "OK". */
static void ok_button_clicked(GtkWidget *widget, fields_dialog_data *data)
{
    g_assert(data != NULL);

    /* Zwalnianie pamici zajmowanej przez star list identyfikatorw. */
    g_list_free(data->old_id_list);
    
    /* Zamyka okno dialogowe. */
    gtk_widget_destroy(data->dialog);
    
    /* Uaktualnianie listy kontaktw. */
    show_fields_list(data->list, FALSE);
    
    /* Zwalnianie pamici zajmowanej przez dane okienka dialogowego. */
    g_free(data);
}

/* Funkcja obsugujca sygna "clicked" przycisku "Anuluj". */
static void cancel_button_clicked(GtkWidget *widget, fields_dialog_data *data)
{
    g_assert(data != NULL);
    
    /* Zwalnianie pamici zajmowanej przez list identyfikatorw. */
    g_list_free(list_params[data->list].id_list);
    list_params[data->list].id_list = data->old_id_list;
    
    /* Zamyka okno dialogowe. */
    gtk_widget_destroy(data->dialog);
}

/* Funkcja obsugujca sygna "key_press_event" okienka dialogowego. */
static void key_pressed(GtkWidget *widget, GdkEventKey *event, fields_dialog_data *data)
{
    g_assert(data != NULL);

    /* Zamykanie okienka dialogowego w wypadku nacinicia klawisza Esc. */
    if (event && event->keyval == GDK_Escape)
        cancel_button_clicked(widget, data);
}

/* Funkcja tworzca okno dialogowe suce do ustalania pl wywietlanych w licie terminw lub
   kontaktw.

   Struktura okna:
   
     GtkDialog (fields_dialog)
      +- GtkVBox (dialog_vbox)
      |   +- GtkFixed
      |       +- GtkLabel                                     "Dostpne pola"
      |       +- GtkScrolledWindow
      |       |   +- GtkViewport
      |       |       +- GtkList
      |       +- GtkButton                                            "Dodaj"
      |       +- GtkButton                                             "Usun"
      |       +- GtkLabel                     "Pokazuj pola w tej kolejnoci"
      |       +- GtkScrolledWindow
      |       |   +- GtkViewport
      |       |       +- GtkList
      |       +- GtkButton                                           "W gr"
      |       +- GtkButton                                            "W d"
      +- GtkHBox
          +- GtkHButtonBox
	      +- GtkButton                                               "OK"
	      +- GtkButton                                           "Anuluj"

*/
void create_fields_dialog(fields_list_type list)
{
    GtkWidget *dialog_vbox;
    GtkWidget *fixed;
    GtkWidget *label;
    GtkWidget *scrolled;
    GtkWidget *viewport;
    GtkWidget *dialog_action_area;
    GtkWidget *hbuttonbox;
    GtkWidget *button;
    
    fields_dialog_data *data;
    
    /* Utworzenie zmiennej suacej do przechowywania danych okienka dialogowego. */
    data = (fields_dialog_data *)g_malloc0(sizeof(fields_dialog_data));
    data->list = list;
    data->old_id_list = g_list_copy(list_params[list].id_list);
    
    /* Utworzenie okienka dialogowego. */
    data->dialog = gtk_dialog_new();

    /* Przypisanie funkcji obsugi sygnaw do okienka dialogowego. */
    gtk_signal_connect(GTK_OBJECT(data->dialog), "delete_event",
                       GTK_SIGNAL_FUNC(cancel_button_clicked), data);
    gtk_signal_connect(GTK_OBJECT(data->dialog), "key_press_event",
                       GTK_SIGNAL_FUNC(key_pressed), data);
    
    /* Ustalanie tytuu i rozmiarw okna. */
    gtk_window_set_title(GTK_WINDOW(data->dialog), _("Show fields..."));
    gtk_widget_set_usize(GTK_WIDGET(data->dialog), 448, 320);
    
        /* Obszar wnetrza okna dialogowego. */
	dialog_vbox = GTK_DIALOG(data->dialog)->vbox;
	gtk_widget_show(dialog_vbox);
	
	    /* Wntrze okienka. */
	    fixed = gtk_fixed_new();
	    gtk_widget_show(fixed);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_vbox), fixed, TRUE, TRUE, 0);
	    
	        /* Etykieta "Dostpne pola:". */
		label = gtk_label_new(_("Available fields:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 8, 8);
		gtk_widget_set_uposition(label, 8, 8);
		gtk_widget_set_usize(label, 168, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Okno z paskami przewijania. */
		scrolled = gtk_scrolled_window_new(NULL, NULL);
		gtk_widget_show(scrolled);
		
		gtk_fixed_put(GTK_FIXED(fixed), scrolled, 8, 32);
		gtk_widget_set_uposition(scrolled, 8, 32);
		gtk_widget_set_usize(scrolled, 168, 192);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
		                               GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
		
		    /* Wntrze okna z paskami. */
		    viewport = gtk_viewport_new(NULL, NULL);
		    gtk_widget_show(viewport);
		    
		    gtk_container_add(GTK_CONTAINER(scrolled), viewport);
		    
		        /* Lista "Dostpne pola". */
			data->available_list = gtk_list_new();
			gtk_widget_show(data->available_list);
			
			gtk_container_add(GTK_CONTAINER(viewport), data->available_list);
			gtk_widget_grab_focus(data->available_list);
			
			gtk_signal_connect(GTK_OBJECT(data->available_list), "select-child",
			                   GTK_SIGNAL_FUNC(list_select_child),
					   &data->available_list_item);
			gtk_signal_connect(GTK_OBJECT(data->available_list), "unselect-child",
			                   GTK_SIGNAL_FUNC(list_unselect_child),
					   &data->available_list_item);
		
		/* Przycisk "Dodaj". */
		button = gtk_button_new_with_label(_("Add ->"));
		gtk_widget_show(button);
		
		gtk_fixed_put(GTK_FIXED(fixed), button, 184, 32);
		gtk_widget_set_uposition(button, 184, 32);
		gtk_widget_set_usize(button, 80, 24);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(add_button_clicked), data);
		
		/* Przycisk "Usun". */
		button = gtk_button_new_with_label(_("<- Remove"));
		gtk_widget_show(button);
		
		gtk_fixed_put(GTK_FIXED(fixed), button, 184, 64);
		gtk_widget_set_uposition(button, 184, 64);
		gtk_widget_set_usize(button, 80, 24);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(remove_button_clicked), data);
		
		/* Etykieta "Pokazuj pola w tej kolejnoci". */
		label = gtk_label_new(_("Showed fields:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 272, 8);
		gtk_widget_set_uposition(label, 272, 8);
		gtk_widget_set_usize(label, 168, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Okno z paskami przewijania. */
		scrolled = gtk_scrolled_window_new(NULL, NULL);
		gtk_widget_show(scrolled);
		
		gtk_fixed_put(GTK_FIXED(fixed), scrolled, 272, 32);
		gtk_widget_set_uposition(scrolled, 272, 32);
		gtk_widget_set_usize(scrolled, 168, 192);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
		                               GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
		
		    /* Wntrze okna z paskami. */
		    viewport = gtk_viewport_new(NULL, NULL);
		    gtk_widget_show(viewport);
		    
		    gtk_container_add(GTK_CONTAINER(scrolled), viewport);
		    
		        /* Lista "Pokazuj pola w tej kolejnoci". */
			data->visible_list = gtk_list_new();
			gtk_widget_show(data->visible_list);
			
 		        gtk_container_add(GTK_CONTAINER(viewport), data->visible_list);
			
			make_list_visible_fields(data);
			make_list_available_fields(data);

			gtk_signal_connect(GTK_OBJECT(data->visible_list), "select-child",
			                   GTK_SIGNAL_FUNC(list_select_child),
					   &data->visible_list_item);
			gtk_signal_connect(GTK_OBJECT(data->visible_list), "unselect-child",
			                   GTK_SIGNAL_FUNC(list_unselect_child),
					   &data->visible_list_item);
			
		/* Przycisk "W gre". */
		button = gtk_button_new_with_label(_("Up"));
		gtk_widget_show(button);
		
		gtk_fixed_put(GTK_FIXED(fixed), button, 272, 232);
		gtk_widget_set_uposition(button, 272, 232);
		gtk_widget_set_usize(button, 80, 24);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(up_button_clicked), data);
		
		/* Przycisk "W dl". */
		button = gtk_button_new_with_label(_("Down"));
		gtk_widget_show(button);
		
		gtk_fixed_put(GTK_FIXED(fixed), button, 360, 232);
		gtk_widget_set_uposition(button, 360, 232);
		gtk_widget_set_usize(button, 80, 24);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(down_button_clicked), data);

        /* Obszar przyciskw okienka dialogowego. */
	dialog_action_area = GTK_DIALOG(data->dialog)->action_area;
	gtk_widget_show(dialog_action_area);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area), 10);
	
	    /* Listwa przyciskw. */
	    hbuttonbox = gtk_hbutton_box_new();
	    gtk_widget_show(hbuttonbox);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_action_area), hbuttonbox, TRUE, TRUE, 0);
	    
	    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
	    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 10);
	    
	        /* Przycisk "OK". */
		button = gtk_button_new_with_label(_("OK"));
		gtk_widget_show(button);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(ok_button_clicked), data);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		
		/* Przycisk "Anuluj". */
		button = gtk_button_new_with_label(_("Cancel"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(cancel_button_clicked), data);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		
    /* Wywietlenie okienka dialogowego. */
    gtk_widget_show(data->dialog);
    
    /* Ustalanie modalnoci okienka. */
    gtk_window_set_modal(GTK_WINDOW(data->dialog), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(data->dialog), GTK_WINDOW(main_window));
}
