/*
 *  main-window.c        -
 *
 *  Created: 20011214
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: main-window.c,v 1.64 2002/03/23 19:34:53 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <main-window.h>

#include <intl.h>
#include <utils.h>
#include <globals.h>
#include <about-dialog.h>
#include <windows-list.h>
#include <fields-dialog.h>
#include <sort-dialog.h>
#include <appointment-window.h>
#include <contact-window.h>

/* Funkcja obsugujaca menu Plik-Zamknij wszystkie, zamykajca wszystkie okienka z wyjtkiem
   okienka gwnego. */
static void close_all_menu(GtkWidget *widget, gpointer data)
{
    close_all_windows();
}

/* Funkcja obsugujca menu Plik-Koniec. */
static void quit_menu(GtkWidget *widget, gpointer data)
{
    if (close_all_windows())
        gtk_main_quit();
}

/* Funkcja obsugujca menu Widok-Poka pola listy terminw lub kontaktw, wywietlajca
   okienko wyboru pl wywietlania. */
static void show_fields_menu(GtkWidget *widget, fields_list_type list)
{
    create_fields_dialog(list);
}

/* Funkcja obsugujca menu Widok-Sortuj listy terminw lub kontaktw, wywietlajca okienko
   wyboru sortowania pl. */
static void sort_fields_menu(GtkWidget *widget, fields_list_type list)
{
    create_sort_fields_dialog(list);
}

/* Funkcja obsugujca menu Poka-Kalendarz i Poka-Kontakty. */
static void fields_menu(GtkWidget *widget, fields_list_type list)
{
    if (current_list != list)
        show_fields_list(list, TRUE);
}

/* Funkcja obsugujca sygna "delete_event" okienka gwnego programu. */
static gint mainwnd_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    if (close_all_windows())
    {
        gtk_main_quit();
    
        return FALSE;
    }
    
    return TRUE;
}

/* Struktura zawierajca menu gwne programu. */
static GtkItemFactoryEntry main_appointment_menu[] =
{
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /*  0 */
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /*  1 */
    { NULL, NULL, new_appointment_menu, 0,              NULL },             /*  2 */
    { NULL, NULL, new_contact_menu,     0,              NULL },             /*  3 */
    { NULL, NULL, NULL,                 0,              "<Separator>" },    /*  4 */
    { NULL, NULL, close_all_menu,       0,              NULL },             /*  5 */
    { NULL, NULL, NULL,                 0,              "<Separator>" },    /*  6 */
    { NULL, NULL, quit_menu,            0,              NULL },             /*  7 */
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /*  8 */
    { NULL, NULL, show_fields_menu,     LT_APPOINTMENT, NULL },             /*  9 */
    { NULL, NULL, sort_fields_menu,     LT_APPOINTMENT, NULL },             /* 10 */
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /* 11 */
    { NULL, NULL, fields_menu,          LT_CONTACT,     NULL },             /* 12 */
    { NULL, NULL, NULL,                 0,              "<LastBranch>" },   /* 13 */
    { NULL, NULL, about_menu,           0,              NULL },             /* 14 */
};

static GtkItemFactoryEntry main_contact_menu[] =
{
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /*  0 */
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /*  1 */
    { NULL, NULL, new_appointment_menu, 0,              NULL },             /*  2 */
    { NULL, NULL, new_contact_menu,     0,              NULL },             /*  3 */
    { NULL, NULL, NULL,                 0,              "<Separator>" },    /*  4 */
    { NULL, NULL, close_all_menu,       0,              NULL },             /*  5 */
    { NULL, NULL, NULL,                 0,              "<Separator>" },    /*  6 */
    { NULL, NULL, quit_menu,            0,              NULL },             /*  7 */
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /*  8 */
    { NULL, NULL, show_fields_menu,     LT_CONTACT,     NULL },             /*  9 */
    { NULL, NULL, sort_fields_menu,     LT_CONTACT,     NULL },             /* 10 */
    { NULL, NULL, NULL,                 0,              "<Branch>" },       /* 11 */
    { NULL, NULL, fields_menu,          LT_APPOINTMENT, NULL },             /* 12 */
    { NULL, NULL, NULL,                 0,              "<LastBranch>" },   /* 13 */
    { NULL, NULL, about_menu,           0,              NULL },             /* 14 */
};

/* Tworzenie menu gwnego programu. */
void update_main_menu()
{
    GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;
    
    /* Usunicie starego menu */
    if (main_menubar != NULL)
        gtk_container_remove(GTK_CONTAINER(main_vbox), main_menubar);

    /* Utworzenie nowego menu. */
    accel_group = gtk_accel_group_new();
    
    item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);
    
    switch (current_list)
    {
        case LT_APPOINTMENT:
            gtk_item_factory_create_items(item_factory, sizeof(main_appointment_menu) / 
	                                  sizeof(main_appointment_menu[0]),
					  main_appointment_menu, NULL);
            gtk_window_add_accel_group(GTK_WINDOW(main_window), accel_group);
	    break;
	case LT_CONTACT:
            gtk_item_factory_create_items(item_factory,
                                          sizeof(main_contact_menu) /
					  sizeof(main_contact_menu[0]),
				          main_contact_menu, NULL);
            gtk_window_add_accel_group(GTK_WINDOW(main_window), accel_group);
            break;
    }

    main_menubar = gtk_item_factory_get_widget(item_factory, "<main>");
	    
    gtk_widget_show(main_menubar);
    
    /* Wstawienie menu i okrelenie jego pozycji w okienku gwnym. */
    gtk_box_pack_start(GTK_BOX(main_vbox), main_menubar, FALSE, FALSE, 0);
    gtk_box_reorder_child(GTK_BOX(main_vbox), main_menubar, 0);
}

/* Funkcja tworzca gwne okno aplikacji.
   
   Struktura okna:
   
     GtkWindow (main_window)
      +- GtkVBox (main_vbox)
          +- GtkMenuBar (menubar)
	  +- GtkHBox (main_hbox, "hbox")
	  |   +- GtkScrolledWindow (scrolled)
	  |   |   +- GtkViewport
	  |   |       +- GtkToolbar
	  |   +- GtkScrolledWindow (contact_list)
	  +- GtkStatusBar (statusbar)

   Klucze zwizane z okienkiem kontaktw:
   
     hbox  - wskanik do gwnej czci okna
        
*/
void create_main_window()
{
    GtkWidget *main_hbox;
    GtkWidget *scrolled;
    GtkWidget *viewport;
    GtkWidget *toolbar;
    GtkWidget *icon;
    GtkWidget *button;
    GtkWidget *statusbar;
    
    /* Utworzenie okienka gwnego aplikacji. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    
    gtk_signal_connect(GTK_OBJECT(main_window), "delete_event",
                       GTK_SIGNAL_FUNC(mainwnd_delete_event), NULL);
    
    /* Ustalenie tytuu i rozmiarw okna. */
    gtk_window_set_title(GTK_WINDOW(main_window), "Rigel");
    gtk_widget_set_usize(GTK_WIDGET(main_window), 400, 300);
    
        /* Obszar zawartoci okna gwnego. */
	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);
	
	gtk_container_border_width(GTK_CONTAINER(main_vbox), 0);
	gtk_container_add(GTK_CONTAINER(main_window), main_vbox);
	
	    /* Uzupenienie struktury zawierajcej menu okienka gwnego. */
	    main_appointment_menu[14].callback_action = (guint)main_window;

	    main_contact_menu[14].callback_action = (guint)main_window;
	    
	    update_main_menu();
	    
	    /* Gwna cz okna */
	    main_hbox = gtk_hbox_new(FALSE, 0);
	    gtk_widget_show(main_hbox);
	    
	    gtk_object_set_data(GTK_OBJECT(main_window), "hbox", main_hbox);
	    
	    gtk_box_pack_start(GTK_BOX(main_vbox), main_hbox, TRUE, TRUE, 0);
	    gtk_container_border_width(GTK_CONTAINER(main_hbox), 0);
	    
		/* Okienko przewijania. */
		scrolled = gtk_scrolled_window_new(NULL, NULL);
		gtk_widget_show(scrolled);
		
		gtk_box_pack_start(GTK_BOX(main_hbox), scrolled, FALSE, FALSE, 0);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
		                               GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		
		    /* Wntrze okienka przewijania. */
		    viewport = gtk_viewport_new(NULL, NULL);
		    gtk_widget_show(viewport);
		    
		    gtk_container_add(GTK_CONTAINER(scrolled), viewport);
		    gtk_widget_set_usize(GTK_WIDGET(viewport), 120, -1);
		    
		        toolbar = gtk_toolbar_new(GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_BOTH);
		        gtk_widget_show(toolbar);
		    
		        gtk_container_set_border_width(GTK_CONTAINER(toolbar), 20);
		        gtk_toolbar_set_space_size(GTK_TOOLBAR(toolbar), 20);
		        gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
		    
		        gtk_container_add(GTK_CONTAINER(viewport), toolbar);
		    
		            /* Przycisk "Kalendarz". */
			    icon = create_pixmap(main_window, "calendar.xpm");
			    button = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
			                                        GTK_TOOLBAR_CHILD_BUTTON, NULL,
							        _("Calendar"), NULL, NULL,
							        icon, NULL, NULL);
			    gtk_widget_show(button);
			    
			    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			                       GTK_SIGNAL_FUNC(fields_menu),
					       GUINT_TO_POINTER(LT_APPOINTMENT));
			    
			    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

		            /* Przycisk "Kontakty". */
			    icon = create_pixmap(main_window, "contacts.xpm");
			    button = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
			                                        GTK_TOOLBAR_CHILD_BUTTON, NULL,
							        _("Contacts"), NULL, NULL,
							        icon, NULL, NULL);
			    gtk_widget_show(button);

			    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			                       GTK_SIGNAL_FUNC(fields_menu),
					       GUINT_TO_POINTER(LT_CONTACT));
	    
	        /* Prawa cz gwnej czci okna - okno z paskami przewijania */
                show_fields_list(LT_CONTACT, TRUE);

	    /* Tworzenie linii statusu. */
	    statusbar = gtk_statusbar_new();
	    gtk_widget_show(statusbar);
	    
	gtk_box_pack_start(GTK_BOX(main_vbox), statusbar, FALSE, FALSE, 0);
    
    /* Wywietlenie okna gownego. */
    gtk_widget_show(main_window);
}

/* Funkcja inicjalizujca menu okienka gwnego. */
void init_gettext_main_window()
{
    main_appointment_menu[0].path = _("/_File");
    main_appointment_menu[1].path = _("/File/_New");
    main_appointment_menu[2].path = _("/File/New/_Appointment");
    main_appointment_menu[3].path = _("/File/New/_Contact");
    main_appointment_menu[4].path = _("/File/sep1");
    main_appointment_menu[5].path = _("/File/_Close all");
    main_appointment_menu[6].path = _("/File/sep2");
    main_appointment_menu[7].path = _("/File/_Quit");
    main_appointment_menu[8].path = _("/_View");
    main_appointment_menu[9].path = _("/View/_Fields...");
    main_appointment_menu[10].path = _("/View/_Sort...");
    main_appointment_menu[11].path = _("/_Go to");
    main_appointment_menu[12].path = _("/Go to/Co_ntacts");
    main_appointment_menu[13].path = _("/_Help");
    main_appointment_menu[14].path = _("/Help/_About...");

    main_contact_menu[0].path = _("/_File");
    main_contact_menu[1].path = _("/File/_New");
    main_contact_menu[2].path = _("/File/New/_Appointment");
    main_contact_menu[3].path = _("/File/New/_Contact");
    main_contact_menu[4].path = _("/File/sep1");
    main_contact_menu[5].path = _("/File/_Close all");
    main_contact_menu[6].path = _("/File/sep2");
    main_contact_menu[7].path = _("/File/_Quit");
    main_contact_menu[8].path = _("/_View");
    main_contact_menu[9].path = _("/View/_Fields...");
    main_contact_menu[10].path = _("/View/_Sort...");
    main_contact_menu[11].path = _("/_Go to");
    main_contact_menu[12].path = _("/Go to/_Calendar");
    main_contact_menu[13].path = _("/_Help");
    main_contact_menu[14].path = _("/Help/_About...");
}
