/*
 * robstrings.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// Contains lots of user-visible names and strings

#include "robstrings.h"

namespace rt {

const char* simVarNames[] = {
	"$Fields",
	"#Pub",
	"$Time",
	"$MaxGeneration",
	"$MaxVars",
	"$MaxTasks",
	"$MaxMybots",
	"$Timeout",
	"$ElimTrigger",
	"$MaxLifetime"
};

const char* progVarNames[] = {
	"$MyBots",
	"$OtherBots",
	"$ID"
};

const char* botVarNames[] = {
	"#Active",
	"$Banks",
	"$Generation",
	"!PosX",
	"!PosY",
	"$InstrSet",
	"$Mobile",
	"$Tasks"
};

const char* taskVarNames[] = {
	"!RunBank",
	"$InstrPos",
	"!Dir",
	"!NumCyclesReq",
	"!NumCyclesDone",
	"!TimingMode"
};
	
const char* failMsg[] = {
	"",
	"Elemination Trigger released",
	"Data Hunger",
	"Division by zero",
	"Invalid source or target bank",
	"Higher instruction set required",
	"Mobility required",
	"DIE executed",
	"Invalid parameter",
	"Unemployment: no tasks left",
	"Instruction duration too high",
	"Maximum Lifetime exceeded",
	"Quit executed"
};

const char* robLoadFailMsg[] = {
	"",
	"No banks defined in bot",
	"Unknown command",
	"Unknown parameter",
	"Wrong number of parameters",
	"Comma expected",
	"Bank expected",
	"Undefined label",
	"Label declared twice",
	"File not found",
	"Not enough memory",
	"RC3 instructions required",
	"Multitasking required",
	"Too many banks in bot",
	"Too many instructions in bank",
	"Generic Define Error",
	"Undeclared Define parameter",
	"Too many Define parameters",
	"Ampersand '&' expected",
	"Opening brace '{' expected",
	"Closing brace '}' expected",
	"Opening bracket '(' expected",
	"Closing bracket ')' expected", 
	"Question mark '?' expected",
	"Too many recursion levels",
	"Undeclared define",
	"Define declared twice",
	"Invalid character in identifier"
};

const char* rbiLoadFailMsg[] = {
	"",
	"No banks defined in bot",
	"Unknown command",
	"Unknown parameter",
	"Wrong number of parameters",
	"File not found",
	"Not enough memory",
	"RC3 instructions required",
	"Multitasking required",
	"Too many banks in bot",
	"Too many instructions in bank",
	"Unexpected end of file",
	"Unknown error"
};

const char* genLoadFailMsg[] = {
	"Unsupported RoboCom Language version"
};






} // namespace
