/*
 * robversion.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/**\file
  * Defines RoboTour's (and the associated programs') current version. 
  */
#include "robvars.h"

namespace rt {

// The RoboTour version.
const char* version = "3.10";
// same as version, but formatted for the user. 
#ifdef __RBI__ // full version
  const char* userVersion = version;
#else // lite version
  const char* userVersion = "3.10-lite (No RBI support)";
#endif

// copyright and release info
const char* aboutText = "Copyright (C) 2000-2004 Florian Fischer and Martin Trautmann\n"
#ifdef EXTRA_DATA_DIR
						"Install(ed) to " EXTRA_DATA_DIR "\n"
#endif
#ifndef __RBI__ // lite version
						"NOTE that this version of RoboTour lacks certain features, such\n"
						"as support for binary robot files (RBI).\n"
						"The full version may be downloaded from the RoboCom homepage.\n"
#endif
						"The RoboCom Homepage: http://www.cyty.com/robocom/"; 


/* The supported RoboCom Language version. This should be a three-digit number,
   it is the xxx in the ROB header  "Published Language RCxxx". */
const int languageVersion = 300;

}; // namespace
