#ifndef TREE_SAVER_XML_H
#define TREE_SAVER_XML_H

#include <iostream>
using namespace std;

#include "common.h"
#include "tree_saver.h"

class TreeSaverXml : public TreeSaver
{
public:
        virtual void save_to_file(const string& filename);

        static TreeSaverXml *instance() {
                if (!instance_) {
                        rpdbgmsg("Creating TreeSaverXml");
                        instance_ = new TreeSaverXml();
                }
                return instance_;
        }

        static void destroy_instance() {
                if (instance_) {
                        rpdbgmsg("Destroying TreeSaverXml");
                        delete instance_;
                        instance_ = 0;
                }
        }               
                        
private:
        static TreeSaverXml *instance_;
};

#endif
