/*
*  Rubrica
*  file: browse.c
*
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*    routine per la nagivazione delle schede inserite
*/
#include <gtk/gtk.h>

#include "browse.h"
#include "rubrica.h"
#include "card.h"


void rubrica_browse_save_path(GtkTreePath *path)
{
  Rubrica *rubrica;
  gchar *str;

  rubrica = rubrica_get_current_rubrica();
  str = gtk_tree_path_to_string(path);
  
  rubrica_set_list_path(rubrica, str);
}


void rubrica_browse_first_card(GtkTreeSelection *select, GtkTreeModel *model)
{ 
  GtkTreeIter iter;
  GtkTreePath *path;
  GtkTreeView *view;

  view = gtk_tree_selection_get_tree_view(select);

  if (gtk_tree_model_get_iter_first(GTK_TREE_MODEL(model), &iter))
    {
      path  = gtk_tree_model_get_path(model, &iter);

      gtk_tree_selection_select_iter(select, &iter);
      gtk_tree_view_scroll_to_cell(view, path, NULL, FALSE, 0.5, 0.0);   
      rubrica_browse_save_path(path);

      gtk_tree_path_free(path);      
    }
}


void rubrica_browse_last_card(GtkTreeSelection *select, GtkTreeModel *model)
{
  GtkTreeIter iter;
  GtkTreePath *path;
  GtkTreeView *view;
  gint n; 

  view = gtk_tree_selection_get_tree_view(select);

  n = gtk_tree_model_iter_n_children(model, NULL);
  if (gtk_tree_model_iter_nth_child(model, &iter, NULL, n-1))
    {
      path = gtk_tree_model_get_path(model, &iter);

      gtk_tree_selection_select_iter(select, &iter);
      gtk_tree_view_scroll_to_cell(view, path, NULL, FALSE, 0.5, 0.0);  
      rubrica_browse_save_path(path);

      gtk_tree_path_free(path);      
    }
}


void rubrica_browse_next_card(GtkTreeSelection *select, GtkTreeModel *model)
{
  GtkTreeIter iter;
  GtkTreeView *view;
  GtkTreePath *path;

  view = gtk_tree_selection_get_tree_view(select);

  if (gtk_tree_selection_get_selected(select, NULL, &iter))
    {
      path = gtk_tree_model_get_path(model, &iter);

      gtk_tree_path_next(path);  
      gtk_tree_selection_select_path(select, path);
      gtk_tree_view_scroll_to_cell(view, path, NULL, FALSE, 0.5, 0.0);
      rubrica_browse_save_path(path);

      gtk_tree_path_free(path);      
    }
}


void rubrica_browse_prev_card(GtkTreeSelection *select, GtkTreeModel *model)
{
  GtkTreeIter iter;
  GtkTreeView *view;
  GtkTreePath *path;

  view = gtk_tree_selection_get_tree_view(select);

  if (gtk_tree_selection_get_selected(select, NULL, &iter))
    {
      path = gtk_tree_model_get_path(model, &iter);
      
      gtk_tree_path_prev(path);
      gtk_tree_selection_select_path(select, path);
      gtk_tree_view_scroll_to_cell(view, path, NULL, TRUE, 0.5, 0.0);
      rubrica_browse_save_path(path);
      
      gtk_tree_path_free(path);
    }
}


void rubrica_browse_nth_card(gchar *path_str)
{  
  GtkTreeView *view;
  GtkTreeSelection *select;
  GtkTreePath *path;
  Rubrica *rubrica;
  gint n;
 
  rubrica = rubrica_get_current_rubrica();  
  
  view = (GtkTreeView *) rubrica_get_view(rubrica);
  select = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
  path = gtk_tree_path_new_from_string(path_str);

  gtk_tree_selection_unselect_all(select);
  gtk_tree_selection_select_path(select, path);      
  gtk_tree_view_scroll_to_cell(view, path, NULL, TRUE, 0.5, 0.0);
  
  n = gtk_tree_path_get_indices(path)[0];
  rubrica_set_index(rubrica, n);
  rubrica_browse_save_path(path);

  gtk_tree_path_free(path);
}


