/*
*  Rubrica
*  file: prefer-configure.h
*
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_PREFERENCES_CONFIGURE_H
#define __RUBRICA_PREFERENCES_CONFIGURE_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "prefer.h"

void rubrica_preferences_reset_errors(void);
gboolean rubrica_preferences_there_are_errors(void);


/*  Setting funcions:
    when the preferences window dialog is called, 
    widgets are filled with values stored in changeset
*/
void rubrica_preferences_configure_path(GConfClient *client, 
					GtkWidget *label, gchar *key);
void rubrica_preferences_configure_label(GConfClient *client, 
					 GtkWidget *label, gchar *key);
void rubrica_preferences_configure_entry(GConfClient *client, 
					 GtkWidget *entry, gchar *key);
void rubrica_preferences_configure_check(GConfClient *client, 
					 GtkWidget *check, gchar *key);
void rubrica_preferences_configure_radio(GConfClient *client, 
					 gint count, ...);
void rubrica_preferences_configure_option_menu(GConfClient *client,
					       GtkWidget *optmenu, gchar* key);

void rubrica_preferences_configure_check_radio(GConfClient *client,
					       GtkWidget *check, 
					       GtkWidget *radio1,
					       GtkWidget *radio2, 
					       gchar *checkkey,
					       gchar *radio1key);

void rubrica_preferences_configure_checked_entry(GConfClient *client,
						 GtkWidget *check, 
						 GtkWidget *gnome_entry,
						 GtkWidget *entry,
						 gchar *key1, gchar *key2);

void rubrica_preferences_configure_spin(GConfClient *client,
					GtkWidget *check, GtkWidget *spin,
					gchar *key1, gchar *key2);
void rubrica_preferences_configure_size_spin(GConfClient *client,
					     GtkWidget *spin, gchar *key);

void rubrica_preferences_configure_combo_entry(GConfClient *client, 
					       GtkWidget *entry, gchar *key);

void rubrica_preferences_configure_radio_dictionary(GConfClient *client, 
						    GtkWidget *radio1, 
						    GtkWidget *radio2,
						    gchar *key1, gchar *key2);

void rubrica_preferences_notify_path_changes(GConfClient* client, 
					     guint cnxn_id, 
					     GConfEntry* entry, gpointer data);

void rubrica_preferences_notify_checked_entry_config(GConfClient *client, 
						     GtkWidget *check,
						     GtkWidget *fileentry, 
						     GtkWidget *entry,
						     gchar *check_key,
						     gchar *entry_key);

void rubrica_preferences_notify_check_config(GConfClient* client,
					     GtkWidget *check, gchar *key);
void rubrica_preferences_notify_check_changes(GConfClient* client, 
					      guint cnxn_id, 
					      GConfEntry* entry,
					      gpointer data);

void rubrica_preferences_notify_autosave_time_changes(GConfClient* client,
						      guint cnxn_id, 
						      GConfEntry *entry,
						      gpointer data);


void rubrica_preferences_column_config(GConfClient *client, 
				       GtkTreeViewColumn *column, 
				       gchar *key);
void rubrica_preferences_notify_column_changes(GConfClient *client,
					       guint cnxn_id, 
					       GConfEntry *entry,
					       gpointer data);

void rubrica_preferences_notify_tooltips_changes(GConfClient *client,
						 guint cnxn_id, 
						 GConfEntry *entry,
						 gpointer data);
void rubrica_preferences_notify_toolbar_style_changes(GConfClient *client,
						      guint cnxn_id, 
						      GConfEntry *entry,
						      gpointer data);

#endif
