/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HELPERS_H
#define HELPERS_H

#include "intincl.h"
#include <stdarg.h>
#include <stdio.h>

//gets path to home directory
const char* get_homedir ();

//returns the number of digits in num
unsigned int numlen (long num);
//requires to link with -lm
//does not work with Cygwin (log10l() not implemented)
/* #include <math.h> */
/* #define numlen(zahl)  ((unsigned int)(log10l(labs(zahl))+1)) */

uint8_t numtype (const char* number);
int is_number(const char* s);
int is_telephone_number (const char* s);
unsigned int hexstr2int(char *hexstring, unsigned int length);

void* mem_alloc (size_t size, short zero_it);
void* mem_realloc (void* oldpointer, size_t size);

char* str_dup (const char* input);
char* strn_dup (const char* input, size_t insize);

/* strlen() does not seem to check for strlen(NULL) and crashes
 */
size_t str_len(const char *s);

/* reverse compare two string
 * returns 1 if the last n characters match else returns 0
 * s1 and s2 can be shorter than n
 */
int strn_reverse_compare (const char* s1, const char* s2, size_t n);

#endif
