/***************************************************************************
                          typedefs.h  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TYPEDEFS_H
#define TYPEDEFS_H

#include <string>
#include <iostream>
enum Error {
        SUCCESS=0,
	ERROR_OPENING_FILE_FOR_WRITING,
	ERROR_OPENING_FILE_FOR_READING,
	ERROR_READING_FILE,
	ERROR_WRITING_FILE,
	ERROR_INVALID_FILE
};



#define ERROR(reason) cout << "Error: " << reason << endl
#define BOUND(bvar,bmin,bmax) (bvar>bmax)?bmax:(bvar<bmin)?bmin:bvar



#define FUNCTION_SUCCESS 0
#define FUNCTION_FAILED -1

// folowing code is from SDL datatype definitions

typedef unsigned char   Uint8;
typedef signed char     Sint8;
typedef unsigned short  Uint16;
typedef signed short    Sint16;
typedef unsigned int    Uint32;
typedef signed int      Sint32;

/* Figure out how to support 64-bit datatypes */
#if defined(__GNUC__) || defined(__MWERKS__) /* MJS */
#define SDL_HAS_64BIT_TYPE      long long
#elif defined(_MSC_VER) /* VC++ */
#define SDL_HAS_64BIT_TYPE      __int64
#endif

/* The 64-bit datatype isn't supported on all platforms */
#ifdef SDL_HAS_64BIT_TYPE
typedef unsigned SDL_HAS_64BIT_TYPE Uint64;
typedef SDL_HAS_64BIT_TYPE Sint64;
#else
/* This is really just a hack to prevent the compiler from complaining */
typedef struct {
        Uint32 hi;
        Uint32 lo;
} Uint64, Sint64;
#endif

#endif
