#include "config.h"
#include "fep.h"
#include <ctype.h>
#include "functions.h"

#define VOW_A	0
#define VOW_I	1
#define VOW_U	2
#define VOW_E	3
#define VOW_O	4

#define CON_0	0
#define CON_K	1
#define CON_S	2
#define CON_T	3
#define	CON_N	4
#define CON_H	5
#define CON_M	6
#define CON_R	7
#define CON_G	8
#define CON_Z	9
#define CON_D	10
#define CON_B	11
#define CON_P	12
#define CON_X	13
#define CON_Y	14
#define CON_W	15
#define CON_KY	16
#define CON_SY	17
#define CON_TY	18
#define CON_NY	19
#define CON_HY	20
#define CON_MY	21
#define CON_RY	22
#define CON_GY	23
#define CON_ZY	24
#define CON_DY	25
#define CON_BY	26
#define CON_PY	27
#define CON_XY	28
#define CON_CH	29
#define CON_J	30
#define CON_SH	31
#define CON_TS	32
#define CON_XW	33
#define CON_F	34
#define CON_V	35
#define CON_DH	36
#define CON_JY	37
#define CON_TH	38
#define CON_NN	39

#define KANA_NN		[CON_NN][0]
#define KANA_XTU	[CON_NN][1]

static
char *HiraTab[][5] = {
	{"$@$"(J","$@$$(J","$@$&(J","$@$((J","$@$*(J"},		/* vowel = 0 */
	{"$@$+(J","$@$-(J","$@$/(J","$@$1(J","$@$3(J"},		/* k = 1 */
	{"$@$5(J","$@$7(J","$@$9(J","$@$;(J","$@$=(J"},		/* s = 2 */
	{"$@$?(J","$@$A(J","$@$D(J","$@$F(J","$@$H(J"},		/* t = 3 */
	{"$@$J(J","$@$K(J","$@$L(J","$@$M(J","$@$N(J"},		/* n = 4 */
	{"$@$O(J","$@$R(J","$@$U(J","$@$X(J","$@$[(J"},		/* h = 5 */
	{"$@$^(J","$@$_(J","$@$`(J","$@$a(J","$@$b(J"},		/* m = 6 */
	{"$@$i(J","$@$j(J","$@$k(J","$@$l(J","$@$m(J"},		/* r = 7 */
	{"$@$,(J","$@$.(J","$@$0(J","$@$2(J","$@$4(J"},		/* g = 8 */
	{"$@$6(J","$@$8(J","$@$:(J","$@$<(J","$@$>(J"},		/* z = 9 */
	{"$@$@(J","$@$B(J","$@$E(J","$@$G(J","$@$I(J"},		/* d = 10 */
	{"$@$P(J","$@$S(J","$@$V(J","$@$Y(J","$@$\(J"},		/* b = 11 */
	{"$@$Q(J","$@$T(J","$@$W(J","$@$Z(J","$@$](J"},		/* p = 12 */
	{"$@$!(J","$@$#(J","$@$%(J","$@$'(J","$@$)(J"},		/* x = 13 */
	{"$@$d(J","$@$$(J","$@$f(J","$@$$$'(J","$@$h(J"},		/* y = 14 */
	{"$@$o(J","$@$&$#(J","$@$&(J","$@$&$'(J","$@$r(J"},		/* w = 15 */
	{"$@$-$c(J","$@$-$#(J","$@$-$e(J","$@$-$'(J","$@$-$g(J"},	/* ky = 16 */
	{"$@$7$c(J","$@$7$#(J","$@$7$e(J","$@$7$'(J","$@$7$g(J"},	/* sy = 17 */
	{"$@$A$c(J","$@$A$#(J","$@$A$e(J","$@$A$'(J","$@$A$g(J"},	/* ty = 18 */
	{"$@$K$c(J","$@$K$#(J","$@$K$e(J","$@$K$'(J","$@$K$g(J"},	/* ny = 19 */
	{"$@$R$c(J","$@$R$#(J","$@$R$e(J","$@$R$'(J","$@$R$g(J"},	/* hy = 20 */
	{"$@$_$c(J","$@$_$#(J","$@$_$e(J","$@$_$'(J","$@$_$g(J"},	/* my = 21 */
	{"$@$j$c(J","$@$j$#(J","$@$j$e(J","$@$j$'(J","$@$j$g(J"},	/* ry = 22 */
	{"$@$.$c(J","$@$.$#(J","$@$.$e(J","$@$.$'(J","$@$.$g(J"},	/* gy = 23 */
	{"$@$8$c(J","$@$8$#(J","$@$8$e(J","$@$8$'(J","$@$8$g(J"},	/* zy = 24 */
	{"$@$B$c(J","$@$B$#(J","$@$B$e(J","$@$B$'(J","$@$B$g(J"},	/* dy = 25 */
	{"$@$S$c(J","$@$S$#(J","$@$S$e(J","$@$S$'(J","$@$S$g(J"},	/* by = 26 */
	{"$@$T$c(J","$@$T$#(J","$@$T$e(J","$@$T$'(J","$@$T$g(J"},	/* py = 27 */
	{"$@$c(J","$@$#(J","$@$e(J","$@$'(J","$@$g(J"},		/* xy = 28 */
	{"$@$A$c(J","$@$A(J","$@$A$e(J","$@$A$'(J","$@$A$g(J"},	/* ch = 29 */
	{"$@$8$c(J","$@$8(J","$@$8$e(J","$@$8$'(J","$@$8$g(J"},	/* j  = 30 */
	{"$@$7$c(J","$@$7(J","$@$7$e(J","$@$7$'(J","$@$7$g(J"},	/* sh = 31 */
	{"$@$D$!(J","$@$D$#(J","$@$D(J","$@$D$'(J","$@$D$)(J"},	/* ts = 32 */
	{"$@$n(J","$@$#(J","$@$%(J","$@$'(J","$@$)(J"},		/* xw = 33 */
	{"$@$U$!(J","$@$U$#(J","$@$U(J","$@$U$'(J","$@$U$)(J"},	/* f  = 34 */
	{"$@$P(J","$@$S(J","$@$V(J","$@$Y(J","$@$\(J"},		/* v  = 35 */
	{"$@$@$!(J","$@$G$#(J","$@$I$%(J","$@$G$'(J","$@$I$)(J"},	/* dh = 36 */
	{"$@$8$c(J","$@$8$#(J","$@$8$e(J","$@$8$((J","$@$8$g(J"},	/* jy = 37 */
	{"$@$F$c(J","$@$F$#(J","$@$F$e(J","$@$F$'(J","$@$F$g(J"},	/* th = 38 */
	{"$@$s(J","$@$C(J","$@$p(J","$@$q(J",""},		/* others = 39 */
};

char *KataTab[][5] = {
	{"$@%"(J","$@%$(J","$@%&(J","$@%((J","$@%*(J"},
	{"$@%+(J","$@%-(J","$@%/(J","$@%1(J","$@%3(J"},
	{"$@%5(J","$@%7(J","$@%9(J","$@%;(J","$@%=(J"},
	{"$@%?(J","$@%A(J","$@%D(J","$@%F(J","$@%H(J"},
	{"$@%J(J","$@%K(J","$@%L(J","$@%M(J","$@%N(J"},
	{"$@%O(J","$@%R(J","$@%U(J","$@%X(J","$@%[(J"},
	{"$@%^(J","$@%_(J","$@%`(J","$@%a(J","$@%b(J"},
	{"$@%i(J","$@%j(J","$@%k(J","$@%l(J","$@%m(J"},
	{"$@%,(J","$@%.(J","$@%0(J","$@%2(J","$@%4(J"},
	{"$@%6(J","$@%8(J","$@%:(J","$@%<(J","$@%>(J"},
	{"$@%@(J","$@%B(J","$@%E(J","$@%G(J","$@%I(J"},
	{"$@%P(J","$@%S(J","$@%V(J","$@%Y(J","$@%\(J"},
	{"$@%Q(J","$@%T(J","$@%W(J","$@%Z(J","$@%](J"},
	{"$@%!(J","$@%#(J","$@%%(J","$@%'(J","$@%)(J"},
	{"$@%d(J","$@%$(J","$@%f(J","$@%$%'(J","$@%h(J"},
	{"$@%o(J","$@%&%#(J","$@%&(J","$@%&%'(J","$@%r(J"},
	{"$@%-%c(J","$@%-%#(J","$@%-%e(J","$@%-%'(J","$@%-%g(J"},
	{"$@%7%c(J","$@%7%#(J","$@%7%e(J","$@%7%'(J","$@%7%g(J"},
	{"$@%A%c(J","$@%A%#(J","$@%A%e(J","$@%A%'(J","$@%A%g(J"},
	{"$@%K%c(J","$@%K%#(J","$@%K%e(J","$@%K%'(J","$@%K%g(J"},
	{"$@%R%c(J","$@%R%#(J","$@%R%e(J","$@%R%'(J","$@%R%g(J"},
	{"$@%_%c(J","$@%_%#(J","$@%_%e(J","$@%_%'(J","$@%_%g(J"},
	{"$@%j%c(J","$@%j%#(J","$@%j%e(J","$@%j%'(J","$@%j%g(J"},
	{"$@%.%c(J","$@%.%#(J","$@%.%e(J","$@%.%'(J","$@%.%g(J"},
	{"$@%8%c(J","$@%8%#(J","$@%8%e(J","$@%8%'(J","$@%8%g(J"},
	{"$@%B%c(J","$@%B%#(J","$@%B%e(J","$@%B%'(J","$@%B%g(J"},
	{"$@%S%c(J","$@%S%#(J","$@%S%e(J","$@%S%'(J","$@%S%g(J"},
	{"$@%T%c(J","$@%T%#(J","$@%T%e(J","$@%T%'(J","$@%T%g(J"},
	{"$@%c(J","$@%#(J","$@%e(J","$@%'(J","$@%g(J"},
	{"$@%A%c(J","$@%A(J","$@%A%e(J","$@%A%'(J","$@%A%g(J"},
	{"$@%8%c(J","$@%8(J","$@%8%e(J","$@%8%'(J","$@%8%g(J"},
	{"$@%7%c(J","$@%7(J","$@%7%e(J","$@%7%'(J","$@%7%g(J"},
	{"$@%D%!(J","$@%D%#(J","$@%D(J","$@%D%'(J","$@%D%)(J"},
	{"$@%n(J","$@%#(J","$@%%(J","$@%'(J","$@%)(J"},
	{"$@%U%!(J","$@%U%#(J","$@%U(J","$@%U%'(J","$@%U%)(J"},
	{"$@%t%!(J","$@%t%#(J","$@%t(J","$@%t%'(J","$@%t%)(J"},
	{"$@%@%!(J","$@%G%#(J","$@%I%%(J","$@%G%'(J","$@%I%)(J"},
	{"$@%8%c(J","$@%8%#(J","$@%8%e(J","$@%8%'(J","$@%8%g(J"},
	{"$@%F%c(J","$@%F%#(J","$@%F%e(J","$@%F%'(J","$@%F%g(J"},
	{"$@%s(J","$@%C(J","$@%p(J","$@%q(J",""},
};

char *ZenkakuAlpha[] = {
/*	SPC	!	"	#	$	%	&	'	*/
	"$@!!(J",	"$@!*(J",	"$@!I(J",	"$@!t(J",	"$@!p(J",	"$@!s(J",	"$@!u(J",	"$@!G(J",
/*	(	)	*	+	,	-	.	/	*/
	"$@!J(J",	"$@!K(J",	"$@!v(J",	"$@!\(J",	"$@!$(J",	"$@!](J",	"$@!%(J",	"$@!?(J",
/*	0	1	2	3	4	5	6	7	*/
	"$@#0(J",	"$@#1(J",	"$@#2(J",	"$@#3(J",	"$@#4(J",	"$@#5(J",	"$@#6(J",	"$@#7(J",
/*	8	9	:	;	<	=	>	?	*/
	"$@#8(J",	"$@#9(J",	"$@!'(J",	"$@!((J",	"$@!c(J",	"$@!a(J",	"$@!d(J",	"$@!)(J",
/*	@	A	B	C	D	E	F	G	*/
	"$@!w(J",	"$@#A(J",	"$@#B(J",	"$@#C(J",	"$@#D(J",	"$@#E(J",	"$@#F(J",	"$@#G(J",
/*	H	I	J	K	L	M	N	O	*/
	"$@#H(J",	"$@#I(J",	"$@#J(J",	"$@#K(J",	"$@#L(J",	"$@#M(J",	"$@#N(J",	"$@#O(J",
/*	P	Q	R	S	T	U	V	W	*/
	"$@#P(J",	"$@#Q(J",	"$@#R(J",	"$@#S(J",	"$@#T(J",	"$@#U(J",	"$@#V(J",	"$@#W(J",
/*	X	Y	Z	[	\	]	^	_	*/
	"$@#X(J",	"$@#Y(J",	"$@#Z(J",	"$@!N(J",	"$@!o(J",	"$@!O(J",	"$@!0(J",	"$@!2(J",
/*	`	a	b	c	d	e	f	g	*/
	"$@!.(J",	"$@#a(J",	"$@#b(J",	"$@#c(J",	"$@#d(J",	"$@#e(J",	"$@#f(J",	"$@#g(J",
/*	h	i	j	k	l	m	n	o	*/
	"$@#h(J",	"$@#i(J",	"$@#j(J",	"$@#k(J",	"$@#l(J",	"$@#m(J",	"$@#n(J",	"$@#o(J",
/*	p	q	r	s	t	u	v	w	*/
	"$@#p(J",	"$@#q(J",	"$@#r(J",	"$@#s(J",	"$@#t(J",	"$@#u(J",	"$@#v(J",	"$@#w(J",
/*	x	y	z	{	|	}	~	DEL	*/
	"$@#x(J",	"$@#y(J",	"$@#z(J",	"$@!P(J",	"$@!C(J",	"$@!Q(J",	"$@!A(J",	"",
};
#ifndef KUTOUTEN /* By Y. Kaneko */
char *ExChars[] = {"$@!<(J","$@!V(J","$@!W(J"};
#else
char *ExChars[] = {"$@!<(J","$@!V(J","$@!W(J","$@!"(J","$@!#(J","$@!&(J"};
#endif

char LastConso[MAX_CONSO];  /* LastConso[0] is always '\0' */
char SmallTU;
short Kindex;
short Nconso;
static char *(*CurrentTab)[5] = HiraTab;

char *modeString[] = {
	"SKK",
	"$@$+$J(J",
	"$@A41Q(J",
	"$@%+%J(J",
	"$@C18lF~NO(J",
	"$@C18lA*Br(J",
};

void writeShells(),flushOut();

void
iKanaV(c)
char c;
{
	inputKanaVowel(c,writeShells);
}

void
iKanaC(c)
char c;
{
	inputKanaConso(c,writeShells,flushOut);
}


void
iZenAl(c)
{
	flushKana();
	inputZenkakuAlpha(c,writeShells);
}

void
iZenEx(c)
char c;
{
	flushKana();
	inputZenkakuEx(c,writeShells);
}

void
flthru(c)
char c;
{
	flushKana();
	thru(c);
}

flushKana()
{
	flushLastConso('\0',writeShells,flushOut);
        Kindex = 0;
}

inputKanaVowel(c,output)
char c;
void (*output)();
{
	int vowelnum;

	switch (c) {
	    case 'a': vowelnum = VOW_A; break;
	    case 'i': vowelnum = VOW_I; break;
	    case 'u': vowelnum = VOW_U; break;
	    case 'e': vowelnum = VOW_E; break;
	    case 'o': vowelnum = VOW_O; break;
	}
	if (Kindex != 0) { /* if preceding consonant exists */
		csrLeft(Nconso);
		erase(Nconso);
		csrLeft(Nconso);
	}
	if (SmallTU && vowelnum == VOW_U) {
		output(CurrentTab KANA_XTU);
	}
	else
		output(CurrentTab[Kindex][vowelnum]);
	SmallTU = 0;
	Kindex = 0;
	Nconso = 0;
}

inputKanaConso(c,output,flush)
char c;
void (*output)();
void (*flush)();
{
	char notOverwrite = 0;
	switch (c) {
	    case 'k': Kindex = CON_K; break;
	    case 's':
		if (LastConso[Nconso] == 't') {
			Kindex = CON_TS;
			notOverwrite = 1;
		}
		else
			Kindex = CON_S;
		break;
	    case 't':
		if (LastConso[Nconso] == 'x') {
			SmallTU = 1;
			notOverwrite = 1;
		}
		Kindex = CON_T;
		break;
	    case 'n':
		if (LastConso[Nconso] == 'n') {
			csrLeft(Nconso);
			output(CurrentTab KANA_NN);
			Nconso = 0;
			Kindex = 0;
			return;
		}
		Kindex = CON_N;
		break;
	    case 'h':
		switch (LastConso[Nconso]) {
		    case 'c':
			notOverwrite = 1;
			Kindex = CON_CH;
			break;
		    case 's':
			notOverwrite = 1;
			Kindex = CON_SH;
			break;
		    case 'd':
			notOverwrite = 1;
			Kindex = CON_DH;
			break;
		    case 't':
			notOverwrite = 1;
			Kindex = CON_TH;
			break;
		    default:
			Kindex = CON_H;
		}
		break;
	    case 'm': Kindex = CON_M; break;
	    case 'r': Kindex = CON_R; break;
	    case 'g': Kindex = CON_G; break;
	    case 'z': Kindex = CON_Z; break;
	    case 'd': Kindex = CON_D; break;
	    case 'b': Kindex = CON_B; break;
	    case 'p': Kindex = CON_P; break;
	    case 'x': Kindex = CON_X; break;
	    case 'y':
		if (LastConso[Nconso] && Kindex < CON_Y) {
			notOverwrite = 1;
			Kindex += (CON_Y+1);
		}
		else if (LastConso[Nconso] == 'j') {
			notOverwrite = 1;
			Kindex = CON_JY;
		}
		else
			Kindex = CON_Y;
		break;
	    case 'w':
		if (LastConso[Nconso] == 'x') {
			notOverwrite = 1;
			Kindex = CON_XW;
		}
		else
			Kindex = CON_W;
		break;
	    case 'j': Kindex = CON_J; break;
	    case 'f': Kindex = CON_F; break;
	    case 'v': Kindex = CON_V; break;
	}
	if (!notOverwrite) {
		flushLastConso(c,output,flush);
	}
	Nconso++;
	LastConso[Nconso] = c;
	write1(c);
}

flushLastConso(c,output,flush)
char c;
void (*output)(),(*flush)();
{
        if (Nconso == 0) {
		return;
	}
	if (Nconso <= 2)
		csrLeft(Nconso);
	else {
		csrLeft(Nconso);
		erase(Nconso);
		csrLeft(Nconso);
	}
	if (LastConso[Nconso] == 'n') {
		output(CurrentTab KANA_NN);
		if (flush != NULL)
			flush(2);
                Nconso = 0;
	}
	else if (LastConso[Nconso] == c) {
		output(CurrentTab KANA_XTU);
		if (flush != NULL)
			flush(2);
                Nconso--;
	}
        else
                Nconso--;
}

void
toKana(c)
char c;
{
	setKeymap(&CurrentKeymap,KanaKeymap);
	if (CurrentTab == HiraTab)
		showmode(KANA_MODE);
	else
		showmode(KKANA_MODE);
}

void
tglK(c)
char c;
{
	flushKana();
	if (CurrentTab == HiraTab) {
		CurrentTab = KataTab;
		showmode(KKANA_MODE);
	}
	else {
		CurrentTab = HiraTab;
		showmode(KANA_MODE);
	}
}

toHira()
{
        CurrentTab = HiraTab;
}

cancelConso()
{
	rubout(Nconso);
	Nconso = 0;
	Kindex = 0;
	SmallTU = 0;
}
	
void
kanaBS(c)
char c;
{
	int i,n;
	char con[MAX_CONSO];
	
	if (Nconso) {
		n = Nconso;
		for (i = 1; i < Nconso; i++)
			con[i] = LastConso[i];
		cancelConso();
		for (i = 1; i < n; i++)
			iKanaC(con[i]);
	}
	else {
#ifdef KANJIBS
		if (KanjiBS)
			writeShell1(c);
		else
#endif
			thru(c);
	}
}

inputZenkakuAlpha(c,output)
char c;
void (*output)();
{
	output(ZenkakuAlpha[c-' ']);
}

inputZenkakuEx(c,output)
char c;
void (*output)();
{
	switch (c) {
	    case '-':
		output(ExChars[0]);
		break;
	    case '[':
		output(ExChars[1]);
		break;
	    case ']':
		output(ExChars[2]);
		break;
#ifdef KUTOUTEN
	    case ',':
		output(ExChars[3]);
		break;
	    case '.':
		output(ExChars[4]);
		break;
	    case '/':
		output(ExChars[5]);
		break;
#endif
	}
}

#define COLBASE	18
char codebuf[5];
int codecol;

codeinMsg()
{
	toMsg();
	writes("JIS or EUC code: ");
}

void
inputCode()
{
	flushKana();
	if (!msgLine())
		return;
	codeinMsg();
	setKeymap(&CurrentKeymap,convertKeymap(&CodeInputKeymap));
	codecol = 0;
}
	
void
cancelCode()
{
	fromMsg();
	setKeymap(&CurrentKeymap,KanaKeymap);
	showmode(KANA_MODE);
}

void
notcodeinput(c)
{
        char buf[7];
        int i,j;

        fromMsg();
        buf[0] = '\\';
        j = 1;
        for (i = 0; i < codecol; i++)
                buf[j++] = codebuf[i];
        buf[j++] = c;
        buf[j] = '\0';
        writeShells(buf);
        toAsc();
}

void
codein(c)
char c;
{
	if (codecol == 4) {
		codecol = 0;
		codeinMsg();
	}
	write1(c);
	codebuf[codecol] = c;
	codecol++;
}

#define HEX1(x)	((x)>'9'?((x)-'a'+10):((x)-'0'))
#define HEX2INT(a,b)	((HEX1(a)<<4)+HEX1(b))

void
enterCode()
{
	char kbuf[3];
        int i;

	if (codecol == 4) {
                for (i = 0; i < 4; i++) 
                        codebuf[i] = tolower(codebuf[i]);
		kbuf[0] = (HEX2INT(codebuf[0],codebuf[1]) | 0x80);
		kbuf[1] = (HEX2INT(codebuf[2],codebuf[3]) | 0x80);
		kbuf[2] = '\0';
		writeShells(kbuf);
	}
	cancelCode();
}

void
hira2kata(buf)
char *buf;
{
    int i,j,k;
    i = 0;
    while (buf[i]) {
	if (buf[i] & 0x80) {
	    for (j = 0; j <= CON_NN; j++) {
		for (k = 0; k < 5; k++) {
		    if (!strncmp(&buf[i],HiraTab[j][k],2)) {
			strncpy(&buf[i],KataTab[j][k],2);
			goto brk1;
		    }
		}
	    }
	brk1: i += 2;
	}
	else
	    i++;
    }
}

