open Formulas

type identifier

type id_ctxs = identifier list contexts

type id_trans = identifier list transitions

(* Initialization routine *)

val init : unit -> unit

(* Routines called during lexical analysis *)

val find_identifier : string -> identifier

(* Routines called during parsing *)

val class_def : id:identifier -> unit

val common_perms_def :
    id:identifier -> perms:identifier list -> unit

val class_perms_def :
    id:identifier -> parent:identifier option -> perms:identifier list -> unit

val mls_common_perms_def :
    id:identifier -> flow:(identifier * identifier list) list -> unit

val mls_class_perms_def :
    id:identifier -> flow:(identifier * identifier list) list -> unit

val attribute_def : id:identifier -> unit

val type_attributes_def :
    id:identifier -> attrs:identifier list -> unit

val type_alias_def :
    id:identifier -> aliases:id_ctxs -> unit

val allow_def :
    sources:id_trans -> targets:id_trans ->
      classes:id_trans -> perms:id_trans -> unit

val never_allow_def :
    sources:id_trans -> targets:id_trans ->
      classes:id_trans -> perms:id_trans -> unit

val role_types_def : id:identifier -> types:id_ctxs -> unit

val role_allow_def : sources:id_trans -> targets:id_trans -> unit

val constrant_def :
    classes:id_trans -> perms:id_trans -> cexpr:id_trans -> unit

val user_roles_def : id:identifier -> roles:id_ctxs -> unit

(* Routines called after parsing *)

val slat : auth:bool -> string list lts
