(* $Id: lex_policy_mls.mll,v 1.2 2004/06/19 04:08:44 ramsdell Exp $ *)

{

open Parse_policy_mls

(* This lexical analyzer needs a keyword table or its too big. *)
let keywords =
  ["CLONE", CLONE; "clone", CLONE;
   "COMMON", COMMON; "common", COMMON;
   "CLASS", CLASS; "class", CLASS;
   "CONSTRAIN", CONSTRAIN; "constrain", CONSTRAIN;
   "INHERITS", INHERITS; "inherits", INHERITS;
   "SID", SID; "sid", SID;
   "ROLE", ROLE; "role", ROLE;
   "ROLES", ROLES; "roles", ROLES;
   "TYPES", TYPES; "types", TYPES;
   "TYPE", TYPE; "type", TYPE;
   "TYPEALIAS", TYPEALIAS; "typealias", TYPEALIAS;
   "ALIAS", ALIAS; "alias", ALIAS;
   "ATTRIBUTE", ATTRIBUTE; "attribute", ATTRIBUTE;
   "TYPE_TRANSITION", TYPE_TRANSITION; "type_transition", TYPE_TRANSITION;
   "TYPE_MEMBER", TYPE_MEMBER; "type_member", TYPE_MEMBER;
   "TYPE_CHANGE", TYPE_CHANGE; "type_change", TYPE_CHANGE;
   "ROLE_TRANSITION", ROLE_TRANSITION; "role_transition", ROLE_TRANSITION;
   "SENSITIVITY", SENSITIVITY; "sensitivity", SENSITIVITY;
   "DOMINANCE", DOMINANCE; "dominance", DOMINANCE;
   "CATEGORY", CATEGORY; "category", CATEGORY;
   "LEVEL", LEVEL; "level", LEVEL;
   "RANGES", RANGES; "ranges", RANGES;
   "USER", USER; "user", USER;
   "NEVERALLOW", NEVERALLOW; "neverallow", NEVERALLOW;
   "ALLOW", ALLOW; "allow", ALLOW;
   "AUDITALLOW", AUDITALLOW; "auditallow", AUDITALLOW;
   "AUDITDENY", AUDITDENY; "auditdeny", AUDITDENY;
   "DONTAUDIT", DONTAUDIT; "dontaudit", DONTAUDIT;
   "SOURCE", SOURCE; "source", SOURCE;
   "TARGET", TARGET; "target", TARGET;
   "SAMEUSER", SAMEUSER; "sameuser", SAMEUSER;
   "OR", OR; "or", OR;
   "AND", AND; "and", AND;
   "NOT", NOT; "not", NOT;
   "EQUALS", EQUALS; "equals", EQUALS;
   "DOM", DOM; "dom", DOM;
   "DOMBY", DOMBY; "domby", DOMBY;
   "INCOMP", INCOMP; "incomp", INCOMP;
   "FSCON", FSCON; "fscon", FSCON;
   "PORTCON", PORTCON; "portcon", PORTCON;
   "NETIFCON", NETIFCON; "netifcon", NETIFCON;
   "NODECON", NODECON; "nodecon", NODECON;
   "GENFSCON", GENFSCON; "genfscon", GENFSCON;
   "FS_USE_PSID", FSUSEPSID; "fs_use_psid", FSUSEPSID;
   "FS_USE_TASK", FSUSETASK; "fs_use_task", FSUSETASK;
   "FS_USE_TRANS", FSUSETRANS; "fs_use_trans", FSUSETRANS;
   "FS_USE_XATTR", FSUSEXATTR; "fs_use_xattr", FSUSEXATTR;
   "R1", R1; "r1", R1;
   "R2", R2; "r2", R2;
   "U1", U1; "u1", U1;
   "U2", U2; "u2", U2;
   "T1", T1; "t1", T1;
   "T2", T2; "t2", T2]
let table = Hashtbl.create (List.length keywords)
let _ = List.iter (fun (kwd, tok) -> Hashtbl.add table kwd tok) keywords
let find_lexem item =
  try
    Hashtbl.find table item
  with Not_found ->
    let id = Identifier.find_identifier item in
    if String.contains item '.' || String.contains item '-' then
      USER_IDENTIFIER id
    else
      IDENTIFIER id

let line_number = ref 1
let line_start = ref 0
let newline_found lexbuf =
  line_number := !line_number + 1;
  line_start := Lexing.lexeme_end lexbuf
let init() =
  line_number := 1;
  line_start := 0
let lexeme_place lexbuf =
  let start =
    Lexing.lexeme_start lexbuf - !line_start + 1 in
  let finish =
    Lexing.lexeme_end lexbuf - !line_start + 1 in
  (!line_number, start, finish)

}

let letter = ['A'-'Z' 'a'-'z']
let digit = ['0'-'9']
let hexval = ['0'-'9' 'A'-'F' 'a'-'f']
let hexval04 = (hexval (hexval (hexval hexval?)?)?)?
let ipv6 = hexval04 ':' hexval04 ':' (hexval | ':' | '.')*
let part = letter | digit| '_' | '.' | '-'
rule token = parse
  (* skip comments starting with # *)
  "#" [^ '\n' ]* '\n'	    { newline_found lexbuf; token lexbuf }
| '\n'                      { newline_found lexbuf; token lexbuf }
| [' ' '\t' '\r']           { token lexbuf }
| (letter part*)            { find_lexem(Lexing.lexeme lexbuf) }
| ('/' (part | '/')*)       { PATH(Lexing.lexeme lexbuf) }
| digit+                    { NUMBER(int_of_string(Lexing.lexeme lexbuf)) }
| ipv6                      { IPV6_ADDR }
| "=="                      { EQUALS }
| "!="                      { NOTEQUAL }
| "&&"                      { AND }
| "!!"                      { OR }
| '!'                       { NOT }
| ','                       { COMMA }
| ':'                       { COLON }
| ';'                       { SEMICOLON }
| '('                       { LPAREN }
| ')'                       { RPAREN }
| '['                       { LBRACK }
| ']'                       { RBRACK }
| '{'                       { LBRACE }
| '}'                       { RBRACE }
| '-'                       { HYPHEN }
| '.'                       { PERIOD }
| '~'                       { TILDE }
| '*'                       { STAR }
| eof                       { EOF }
