#include <stdio.h>
#include <unistd.h>
#include "symbol.h"
#include "intern.h"
#include "scanner.h"

extern int yyparse();

#ifdef PACKAGE
const char package[] = PACKAGE;
#else
const char *package = (const char *)0;
#endif

#ifdef VERSION
const char version[] = VERSION;
#else
const char version[] = "Version information not available";
#endif

static void
print_version(const char *program)
{
  if (package)
    program = package;
  fprintf(stderr, "Package: %s %s\n", program, version);
}

static void
usage(const char *prog)
{
  fprintf(stderr,
	  "Usage: %s [options] [input]\n"
	  "Options:\n"
	  "  -o file -- output to file (default is standard output)\n"
	  "  -v      -- print version information\n"
	  "  -h      -- print this message\n"
	  "Use - as a file name to specify standard input\n",
	  prog);
  print_version(prog);
}

int
main(int argc, char **argv)
{
  extern char *optarg;
  extern int optind;

  char *output = 0;

  for (;;) {
    int c = getopt(argc, argv, "o:vh");
    if (c == -1)
      break;
    switch (c) {
    case 'o':
      output = optarg;
      break;
    case 'v':
      print_version(argv[0]);
      return 0;
    case 'h':
      usage(argv[0]);
      return 0;
    default:
      usage(argv[0]);
      return 1;
    }
  }

  if (setfile(argv[optind]) == -1)
    return 1;

  if (output && !freopen(output, "w", stdout)) {
    perror(output);
    return 1;
  }
  
  symbol_init();
  intern_init();
  return yyparse();
}
