/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "gtkledbar.h"
#include "../player.h"
#include "graphic.h"
#include "gtkled.h"

int
ledbar_timeout (gpointer data)
{
  if (!play->graphic)
    return 1;

  gtk_led_bar_light_percent (ledbar_l, play->ao_left);
  gtk_led_bar_light_percent (ledbar_r, play->ao_right);

  play->ao_left = (play->ao_left > 0.0) ? play->ao_left - 5.0 : 0.0;
  play->ao_right = (play->ao_right > 0.0) ? play->ao_right - 5.0 : 0.0;

  return 1;
}

/* EOF */
