/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import swingwt.awt.Color;
import swingwt.awt.Composite;
import swingwt.awt.Font;
import swingwt.awt.FontMetrics;
import swingwt.awt.Graphics;
import swingwt.awt.Graphics2D;
import swingwt.awt.GraphicsConfiguration;
import swingwt.awt.Image;
import swingwt.awt.Paint;
import swingwt.awt.Rectangle;
import swingwt.awt.RenderingHints;
import swingwt.awt.Shape;
import swingwt.awt.Stroke;
import swingwt.awt.font.FontRenderContext;
import swingwt.awt.font.GlyphVector;
import swingwt.awt.geom.AffineTransform;
import swingwt.awt.image.ImageObserver;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class SWTGraphics2DRenderer
extends Graphics2D {
    protected GC gc = null;
    protected Font f = null;
    protected Color c = null;
    protected boolean shouldDestroy = false;

    public SWTGraphics2DRenderer(final GC gcon) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc = gcon;
                SWTGraphics2DRenderer.this.f = new Font(SWTGraphics2DRenderer.this.gc.getFont());
                SWTGraphics2DRenderer.this.c = new Color(SWTGraphics2DRenderer.this.gc.getForeground());
            }
        });
    }

    public SWTGraphics2DRenderer(GC gc, boolean needToCleanUp) {
        this(gc);
        this.shouldDestroy = needToCleanUp;
    }

    public Graphics create() {
        return this;
    }

    public void dispose() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.dispose();
            }
        });
    }

    public GC getSWTGC() {
        return this.gc;
    }

    public void clearRect(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.fillRectangle(x, y, width, height);
            }
        });
    }

    public void clipRect(int x, int y, int width, int height) {
    }

    public void copyArea(final int x, final int y, final int width, final int height, final int dx, final int dy) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.copyArea(x, y, width, height, dx, dy);
            }
        });
    }

    public void redrawUnder(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)SwingWTUtils.getDisplay(), width, height);
                SWTGraphics2DRenderer.this.gc.copyArea(image, x, y);
                SWTGraphics2DRenderer.this.gc.drawImage(image, x, y);
            }
        });
    }

    public void drawArc(final int x, final int y, final int width, final int height, final int startAngle, final int arcAngle) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
            }
        });
    }

    public void drawBytes(final byte[] data, int offset, int length, final int x, final int y) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(new String(data), x, y, true);
            }
        });
    }

    public void drawChars(final char[] data, int offset, int length, final int x, final int y) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(new String(data), x, y, true);
            }
        });
    }

    public boolean drawImage(final Image img, final int x, final int y, Color bgcolor, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int x, final int y, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int x, final int y, int width, int height, Color bgcolor, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int x, final int y, final int width, final int height, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, 0, 0, img.getWidth(null), img.getHeight(null), x, y, width, height);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int dx1, final int dy1, final int dx2, final int dy2, final int sx1, final int sy1, final int sx2, final int sy2, Color bgcolor, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, sx1, sy1, sx2 - sx1, sy2 - sy1, dx1, dy1, dx2 - dx1, dy2 - dy1);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int dx1, final int dy1, final int dx2, final int dy2, final int sx1, final int sy1, final int sx2, final int sy2, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, sx1, sy1, sx2 - sx1, sy2 - sy1, dx1, dy1, dx2 - dx1, dy2 - dy1);
            }
        });
        return true;
    }

    public void drawLine(final int x1, final int y1, final int x2, final int y2) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawLine(x1, y1, x2, y2);
            }
        });
    }

    public void drawOval(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawOval(x, y, width, height);
            }
        });
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawString(final String str, final int x, final int y) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(str, x, y, false);
            }
        });
    }

    public void drawString(final String str, final int x, final int y, final boolean transparent) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(str, x, y, transparent);
            }
        });
    }

    public void fillArc(final int x, final int y, final int width, final int height, final int startAngle, final int arcAngle) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillArc(x, y, width, height, startAngle, arcAngle);
            }
        });
    }

    public void fillOval(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillOval(x, y, width, height);
            }
        });
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void fillRect(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillRectangle(x, y, width, height);
            }
        });
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRect(x, y, width, height);
    }

    public Font getFont() {
        return this.f;
    }

    public Color getColor() {
        return this.c;
    }

    public void setFont(Font f) {
        if (f != this.f) {
            this.f = f;
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    SWTGraphics2DRenderer.this.gc.setFont(SWTGraphics2DRenderer.this.f.getSWTFont());
                }
            });
        }
    }

    public void setColor(Color color) {
        this.c = color;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setForeground(SWTGraphics2DRenderer.this.c.getSWTColor());
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.shouldDestroy) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    SWTGraphics2DRenderer.this.gc.dispose();
                }
            });
        }
    }

    public void addRenderingHints(Map hints) {
    }

    public void clip(Shape s) {
    }

    public void draw(Shape s) {
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public void fill(Shape s) {
    }

    public Color getBackground() {
        return new Color(this.gc.getBackground());
    }

    public Composite getComposite() {
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public Paint getPaint() {
        return null;
    }

    public Object getRenderingHint(Object hintKey) {
        return null;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Stroke getStroke() {
        return null;
    }

    public AffineTransform getTransform() {
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public void rotate(double theta) {
    }

    public void rotate(double theta, double x, double y) {
    }

    public void scale(double sx, double sy) {
    }

    public void setBackground(final Color color) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(color.getSWTColor());
            }
        });
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
    }

    public void setRenderingHint(Object hintKey, Object hintValue) {
    }

    public void setRenderingHints(Map hints) {
    }

    public void setStroke(Stroke s) {
    }

    public void setTransform(AffineTransform Tx) {
    }

    public void shear(double shx, double shy) {
    }

    public void transform(AffineTransform Tx) {
    }

    public void translate(double tx, double ty) {
    }

    public void translate(int x, int y) {
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        final Rectangle r = new Rectangle();
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                org.eclipse.swt.graphics.Rectangle rc = SWTGraphics2DRenderer.this.gc.getClipping();
                r.height = rc.height;
                r.width = rc.width;
                r.x = rc.x;
                r.y = rc.y;
            }
        });
        return r;
    }

    public FontMetrics getFontMetrics(Font f) {
        return new FontMetrics(f);
    }

    public void setClip(Shape clip) {
    }

    public void setClip(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setClipping(x, y, width, height);
            }
        });
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }
}

