/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.editorpanes;

import java.io.IOException;
import java.net.URL;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.JComponent;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.editorpanes.EditorPane;
import swingwtx.swing.event.HyperlinkListener;
import swingwtx.swing.text.AbstractDocument;
import swingwtx.swing.text.AttributeSet;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.EditorKit;
import swingwtx.swing.text.Element;
import swingwtx.swing.text.JTextComponent;
import swingwtx.swing.text.StyledEditorKit;

public class TextEditorPane
extends JTextComponent
implements EditorPane {
    protected Document doc = new EditorPaneStyledDocument();
    protected Color selectionColor = Color.BLACK;
    protected StyledText ppeer = null;
    protected Object retval = null;

    public void addHyperlinkListener(HyperlinkListener l) {
    }

    public Dimension calculatePreferredSize() {
        Dimension size = new Dimension(300, 200);
        this.setSize(size);
        return size;
    }

    public int getCaretPosition() {
        return super.getCaretPosition();
    }

    public String getContentType() {
        return "text/plain";
    }

    public Document getDocument() {
        return this.doc;
    }

    public EditorKit getEditorKit() {
        return new StyledEditorKit();
    }

    public JComponent getJComponent() {
        return this;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public int getSelectionEnd() {
        return super.getSelectionEnd();
    }

    public int getSelectionStart() {
        return super.getSelectionStart();
    }

    public Control getSWTPeer() {
        return this.ppeer;
    }

    public String getText() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.pText;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                TextEditorPane.this.retval = TextEditorPane.this.ppeer.getText();
            }
        });
        return this.retval.toString();
    }

    public boolean isEditable() {
        return super.isEditable();
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
    }

    public void setCaretPosition(int pos) {
        super.setCaretPosition(pos);
    }

    public void setContentType(String contentType) {
    }

    public void setDocument(Document newdoc) {
        this.doc = newdoc;
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
    }

    public void setEditorKit(EditorKit k) {
        throw new RuntimeException("Setting of EditorKit not yet supported");
    }

    public void setPage(URL url) throws IOException {
        throw new RuntimeException("Cannot set page in TextEditorPane");
    }

    public void setPage(String url) throws IOException {
        throw new RuntimeException("Cannot set page in TextEditorPane");
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        int swtFlags = 2048;
        swtFlags |= this.pWordWrap ? 64 : 0;
        if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            boolean useHorizontal = false;
            boolean useVertical = false;
            switch (scrollPane.getHorizontalScrollBarPolicy()) {
                case 3: {
                    useHorizontal = true;
                    break;
                }
                case 4: {
                    useHorizontal = true;
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    useHorizontal = false;
                }
            }
            switch (scrollPane.getVerticalScrollBarPolicy()) {
                case 0: {
                    useVertical = true;
                    break;
                }
                case 1: {
                    useVertical = true;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    useVertical = false;
                }
            }
            swtFlags |= useHorizontal ? 256 : 0;
            swtFlags |= useVertical ? 512 : 0;
        }
        this.ppeer = new StyledText(parent.getComposite(), swtFlags);
        this.peer = this.ppeer;
        if (this.pText != null && !this.pText.equals("")) {
            this.ppeer.setText(this.pText);
        }
        this.doc = new EditorPaneStyledDocument();
        this.doc.insertString(0, this.pText, null);
    }

    public void setText(String text) {
        this.pText = text;
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)TextEditorPane.this.ppeer)) {
                    TextEditorPane.this.ppeer.setText(TextEditorPane.this.pText);
                }
            }
        });
    }

    private class EditorPaneStyledDocument
    extends AbstractDocument {
        private EditorPaneStyledDocument() {
        }

        public Element getDefaultRootElement() {
            return null;
        }

        public Element getParagraphElement(int pos) {
            return null;
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
        }
    }
}

