/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.undo;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import swingwtx.swing.undo.AbstractUndoableEdit;
import swingwtx.swing.undo.StateEditable;

public class StateEdit
extends AbstractUndoableEdit {
    protected StateEditable object;
    protected Hashtable preState = new Hashtable();
    protected Hashtable postState = new Hashtable();
    protected String undoRedoName;

    public String getPresentationName() {
        return this.undoRedoName;
    }

    public StateEdit(StateEditable stateEditable) {
        this.init(stateEditable, null);
    }

    public StateEdit(StateEditable stateEditable, String undoRedoName) {
        this.init(stateEditable, undoRedoName);
    }

    protected void init(StateEditable stateEditable, String undoRedoName) {
        this.object = stateEditable;
        this.undoRedoName = undoRedoName;
        this.object.storeState(this.preState);
    }

    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }

    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    public void end() {
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    protected void removeRedundantState() {
        Object key;
        ArrayList duplicates = new ArrayList();
        Iterator<Object> iterator = this.preState.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            if (!this.postState.containsKey(key) || !this.preState.get(key).equals(this.postState.get(key))) continue;
            duplicates.add(key);
        }
        iterator = duplicates.iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            this.postState.remove(key);
            this.preState.remove(key);
        }
    }
}

