/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;

public final class Program {
    String name;
    String command;
    String iconName;
    ImageData fImageData;

    Program() {
    }

    public static Program findProgram(String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        return Program.getProgram(extension);
    }

    public static String[] getExtensions() {
        String[] extensions = new String[1024];
        int count = 0;
        extensions[count++] = "xml";
        extensions[count++] = "java";
        extensions[count++] = "properties";
        extensions[count++] = "jar";
        extensions[count++] = "zip";
        extensions[count++] = "xml";
        if (count != extensions.length) {
            String[] newExtension = new String[count];
            System.arraycopy(extensions, 0, newExtension, 0, count);
            extensions = newExtension;
        }
        return extensions;
    }

    static Program getProgram(String key) {
        String name = key;
        if (name == null || name.length() == 0) {
            return null;
        }
        String command = "/usr/bin/open";
        if (command == null || command.length() == 0) {
            return null;
        }
        String iconName = "icon";
        if (iconName == null || iconName.length() == 0) {
            return null;
        }
        Program program = new Program();
        program.name = name;
        program.command = command;
        program.iconName = iconName;
        return program;
    }

    public static Program[] getPrograms() {
        Program[] programs = new Program[1024];
        int count = 0;
        programs[count++] = Program.getProgram(".html");
        if (count != programs.length) {
            Program[] newPrograms = new Program[count];
            System.arraycopy(programs, 0, newPrograms, 0, count);
            programs = newPrograms;
        }
        return programs;
    }

    public static boolean launch(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        String[] args = new String[]{"/usr/bin/open", fileName};
        try {
            Compatibility.exec(args);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        boolean quote = true;
        String prefix = this.command;
        String suffix = "";
        int index = this.command.indexOf("%1");
        if (index != -1) {
            int count = 0;
            int i = index + 2;
            int length = this.command.length();
            while (i < length) {
                if (this.command.charAt(i) == '\"') {
                    ++count;
                }
                ++i;
            }
            quote = count % 2 == 0;
            prefix = this.command.substring(0, index);
            suffix = this.command.substring(index + 2, length);
        }
        if (quote) {
            fileName = " \"" + fileName + "\"";
        }
        try {
            Compatibility.exec(String.valueOf(prefix) + fileName + suffix);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public ImageData getImageData() {
        if (this.fImageData == null) {
            this.fImageData = new ImageData(16, 16, 4, new PaletteData(new RGB[]{new RGB(255, 255, 255), new RGB(95, 95, 95), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(223, 223, 191), new RGB(255, 223, 159), new RGB(0, 0, 0)}));
            this.fImageData.transparentPixel = 6;
            String[] p = new String[]{"CCCCCCCCGGG", "CFAAAAACBGG", "CAAAAAACFBG", "CAAAAAACBBB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CDDDDDDDDDB", "CBBBBBBBBBB"};
            int y = 0;
            while (y < p.length) {
                int x = 0;
                while (x < 11) {
                    this.fImageData.setPixel(x + 3, y + 1, p[y].charAt(x) - 65);
                    ++x;
                }
                ++y;
            }
        }
        return this.fImageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

