/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PlatformUIPreferenceListener;
import org.eclipse.ui.internal.ProductInfo;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroRegistry;
import org.eclipse.ui.internal.intro.IntroRegistryReader;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.ViewRegistryReader;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static WorkbenchPlugin inst;
    private EditorRegistry editorRegistry;
    private DecoratorManager decoratorManager;
    private ThemeRegistry themeRegistry;
    private WorkingSetManager workingSetManager;
    private WorkingSetRegistry workingSetRegistry;
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    private static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private PreferenceManager preferenceManager;
    private ViewRegistry viewRegistry;
    private PerspectiveRegistry perspRegistry;
    private ActionSetRegistry actionSetRegistry;
    private SharedImages sharedImages;
    private ProductInfo productInfo = null;
    private IntroRegistry introRegistry;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
    }

    void reset() {
        this.editorRegistry = null;
        if (this.decoratorManager != null) {
            this.decoratorManager.dispose();
            this.decoratorManager = null;
        }
        this.themeRegistry = null;
        this.workingSetManager = null;
        this.workingSetRegistry = null;
        this.preferenceManager = null;
        this.viewRegistry = null;
        this.perspRegistry = null;
        this.actionSetRegistry = null;
        this.sharedImages = null;
        this.productInfo = null;
        this.introRegistry = null;
        DEBUG = false;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (BundleUtility.isActivated(element.getDeclaringExtension().getNamespace())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PI_WORKBENCH, 4, WorkbenchMessages.getString("WorkbenchPlugin.extension"), (Throwable)e));
        }
    }

    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        if (this.actionSetRegistry == null) {
            this.actionSetRegistry = new ActionSetRegistry();
        }
        return this.actionSetRegistry;
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = new EditorRegistry();
        }
        return this.editorRegistry;
    }

    public IElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, "elementFactories");
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (strID.equals(targetID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + targetID);
            return null;
        }
        IElementFactory factory = null;
        try {
            factory = (IElementFactory)WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create element factory.", e.getStatus());
            factory = null;
        }
        return factory;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        if (this.perspRegistry == null) {
            this.perspRegistry = new PerspectiveRegistry();
            this.perspRegistry.load();
        }
        return this.perspRegistry;
    }

    public IWorkingSetManager getWorkingSetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = new WorkingSetManager();
            this.workingSetManager.restoreState();
        }
        return this.workingSetManager;
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        if (this.workingSetRegistry == null) {
            this.workingSetRegistry = new WorkingSetRegistry();
            this.workingSetRegistry.load();
        }
        return this.workingSetRegistry;
    }

    public IIntroRegistry getIntroRegistry() {
        if (this.introRegistry == null) {
            this.introRegistry = new IntroRegistry();
            IntroRegistryReader reader = new IntroRegistryReader();
            reader.readIntros(Platform.getExtensionRegistry(), this.introRegistry);
        }
        return this.introRegistry;
    }

    public PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = new PreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);
            PreferencePageRegistryReader registryReader = new PreferencePageRegistryReader(this.getWorkbench());
            List pageContributions = registryReader.getPreferenceContributions(Platform.getExtensionRegistry());
            Iterator iterator = pageContributions.iterator();
            while (iterator.hasNext()) {
                this.preferenceManager.addToRoot((IPreferenceNode)iterator.next());
            }
        }
        return this.preferenceManager;
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public IThemeRegistry getThemeRegistry() {
        if (this.themeRegistry == null) {
            try {
                this.themeRegistry = new ThemeRegistry();
                ThemeRegistryReader reader = new ThemeRegistryReader();
                reader.readThemes(Platform.getExtensionRegistry(), this.themeRegistry);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to read theme registry.", e.getStatus());
            }
        }
        return this.themeRegistry;
    }

    public IViewRegistry getViewRegistry() {
        if (this.viewRegistry == null) {
            this.viewRegistry = new ViewRegistry();
            try {
                ViewRegistryReader reader = new ViewRegistryReader();
                reader.readViews(Platform.getExtensionRegistry(), this.viewRegistry);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to read view registry.", e.getStatus());
            }
        }
        return this.viewRegistry;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        JFacePreferences.setPreferenceStore((IPreferenceStore)store);
        store.setDefault("SHOULD_SAVE_WORKBENCH_STATE", false);
        store.setDefault("SHOULD_SHOW_TITLE_BAR", true);
        store.setDefault("SHOULD_SHOW_MENU_BAR", true);
        store.setDefault("SHOULD_SHOW_COOL_BAR", true);
        store.setDefault("SHOULD_SHOW_FAST_VIEW_BARS", false);
        store.setDefault("SHOULD_SHOW_PERSPECTIVE_BAR", false);
        store.setDefault("SHOULD_SHOW_STATUS_LINE", true);
        store.setDefault("SHOULD_SHOW_PROGRESS_INDICATOR", false);
        store.setDefault("CLOSE_EDITORS_ON_EXIT", false);
        store.setDefault("shouldPromptForEnablement", true);
        store.setDefault("EDITORLIST_PULLDOWN_ACTIVE", false);
        store.setDefault("EDITORLIST_DISPLAY_FULL_NAME", false);
        store.setDefault("STICKY_CYCLE", false);
        store.setDefault("REUSE_OPEN_EDITORS_BOOLEAN", false);
        store.setDefault("REUSE_DIRTY_EDITORS", true);
        store.setDefault("REUSE_OPEN_EDITORS", 8);
        store.setDefault("OPEN_ON_SINGLE_CLICK", false);
        store.setDefault("SELECT_ON_HOVER", false);
        store.setDefault("OPEN_AFTER_DELAY", false);
        store.setDefault("RECENT_FILES", 4);
        store.setDefault("VIEW_TAB_POSITION", 128);
        store.setDefault("EDITOR_TAB_POSITION", 128);
        store.setDefault("SHOW_MULTIPLE_EDITOR_TABS", true);
        store.setDefault("SHOW_TRADITIONAL_STYLE_TABS", true);
        store.setDefault("SHOW_TEXT_ON_PERSPECTIVE_BAR", true);
        store.setDefault("DOCK_PERSPECTIVE_BAR", false);
        store.setDefault("EDITOR_TAB_WIDTH", 3);
        store.setDefault("OPEN_VIEW_MODE", 0);
        store.setDefault("OPEN_PERSPECTIVE_MODE", 0);
        store.setDefault("ENABLED_DECORATORS", "");
        store.setDefault("EDITORLIST_SELECTION_SCOPE", 1);
        store.setDefault("EDITORLIST_SORT_CRITERIA", 0);
        store.setDefault("COLOR_ICONS", true);
        store.setDefault("SHOW_SHORTCUT_BAR", true);
        store.setDefault("SHOW_STATUS_LINE", true);
        store.setDefault("SHOW_TOOL_BAR", true);
        store.setDefault("MULTI_KEY_ASSIST", false);
        store.setDefault("MULTI_KEY_ASSIST_TIME", 1000);
        store.setDefault("ENABLE_CONFIGURABLE_PROJECT_WIZARD", false);
        store.setDefault("SINGLE_CLICK_METHOD", 0);
        store.setDefault("ENABLE_COOL_BARS", true);
        store.setDefault("ENABLE_NEW_MENUS", true);
        store.setDefault("DISABLE_DIALOG_FONT", false);
        FontRegistry registry = JFaceResources.getFontRegistry();
        this.initializeFont("org.eclipse.jface.dialogfont", registry, store);
        this.initializeFont("org.eclipse.jface.bannerfont", registry, store);
        this.initializeFont("org.eclipse.jface.headerfont", registry, store);
        this.initializeFont("org.eclipse.jface.textfont", registry, store);
        store.addPropertyChangeListener(FontDefinition.getPreferenceListener());
        store.addPropertyChangeListener((IPropertyChangeListener)new PlatformUIPreferenceListener());
    }

    private void initializeFont(String fontKey, FontRegistry registry, IPreferenceStore store) {
        FontData[] fontData = registry.getFontData(fontKey);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)fontKey, (FontData[])fontData);
    }

    public static void log(String message) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        System.err.println(message);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
            System.err.println(String.valueOf(message) + "\nReason:");
        }
        WorkbenchPlugin.getDefault().getLog().log(status);
        System.err.println(status.getMessage());
    }

    public void setWorkbench(IWorkbench aWorkbench) {
    }

    public DecoratorManager getDecoratorManager() {
        if (this.decoratorManager == null) {
            this.decoratorManager = new DecoratorManager();
            this.decoratorManager.restoreListeners();
        }
        return this.decoratorManager;
    }

    public void startup() throws CoreException {
    }

    public String getAppName() {
        return this.getProductInfo().getAppName();
    }

    public String getProductName() {
        return this.getProductInfo().getProductName();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.getProductInfo().getWindowImages();
    }

    private ProductInfo getProductInfo() {
        if (this.productInfo == null) {
            this.productInfo = new ProductInfo(Platform.getProduct());
        }
        return this.productInfo;
    }
}

