/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.ui.internal.activities.AbstractActivityRegistry;
import org.eclipse.ui.internal.activities.ActivityActivityBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;

final class ExtensionActivityRegistry
extends AbstractActivityRegistry {
    private List activityActivityBindingDefinitions;
    private List activityDefinitions;
    private List activityPatternBindingDefinitions;
    private List categoryActivityBindingDefinitions;
    private List categoryDefinitions;
    private List defaultEnabledActivities;
    private IExtensionRegistry extensionRegistry;

    ExtensionActivityRegistry(IExtensionRegistry extensionRegistry) {
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistry.addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent registryChangeEvent) {
                IExtensionDelta[] extensionDeltas = registryChangeEvent.getExtensionDeltas("org.eclipse.ui", "activities");
                if (extensionDeltas.length != 0) {
                    try {
                        ExtensionActivityRegistry.this.load();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        try {
            this.load();
        }
        catch (IOException iOException) {}
    }

    private String getPluginId(IConfigurationElement configurationElement) {
        IExtension extension;
        String pluginId = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            pluginId = extension.getParentIdentifier();
        }
        return pluginId;
    }

    private void load() throws IOException {
        if (this.activityActivityBindingDefinitions == null) {
            this.activityActivityBindingDefinitions = new ArrayList();
        } else {
            this.activityActivityBindingDefinitions.clear();
        }
        if (this.activityDefinitions == null) {
            this.activityDefinitions = new ArrayList();
        } else {
            this.activityDefinitions.clear();
        }
        if (this.activityPatternBindingDefinitions == null) {
            this.activityPatternBindingDefinitions = new ArrayList();
        } else {
            this.activityPatternBindingDefinitions.clear();
        }
        if (this.categoryActivityBindingDefinitions == null) {
            this.categoryActivityBindingDefinitions = new ArrayList();
        } else {
            this.categoryActivityBindingDefinitions.clear();
        }
        if (this.categoryDefinitions == null) {
            this.categoryDefinitions = new ArrayList();
        } else {
            this.categoryDefinitions.clear();
        }
        if (this.defaultEnabledActivities == null) {
            this.defaultEnabledActivities = new ArrayList();
        } else {
            this.defaultEnabledActivities.clear();
        }
        IConfigurationElement[] configurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.activities");
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[i];
            String name = configurationElement.getName();
            if ("activityActivityBinding".equals(name)) {
                this.readActivityActivityBindingDefinition(configurationElement);
            } else if ("activity".equals(name)) {
                this.readActivityDefinition(configurationElement);
            } else if ("activityPatternBinding".equals(name)) {
                this.readActivityPatternBindingDefinition(configurationElement);
            } else if ("categoryActivityBinding".equals(name)) {
                this.readCategoryActivityBindingDefinition(configurationElement);
            } else if ("category".equals(name)) {
                this.readCategoryDefinition(configurationElement);
            } else if ("defaultEnablement".equals(name)) {
                this.readDefaultEnablement(configurationElement);
            }
            ++i;
        }
        boolean activityRegistryChanged = false;
        if (!this.activityActivityBindingDefinitions.equals(((AbstractActivityRegistry)this).activityActivityBindingDefinitions)) {
            ((AbstractActivityRegistry)this).activityActivityBindingDefinitions = Collections.unmodifiableList(this.activityActivityBindingDefinitions);
            activityRegistryChanged = true;
        }
        if (!this.activityDefinitions.equals(((AbstractActivityRegistry)this).activityDefinitions)) {
            ((AbstractActivityRegistry)this).activityDefinitions = Collections.unmodifiableList(this.activityDefinitions);
            activityRegistryChanged = true;
        }
        if (!this.activityPatternBindingDefinitions.equals(((AbstractActivityRegistry)this).activityPatternBindingDefinitions)) {
            ((AbstractActivityRegistry)this).activityPatternBindingDefinitions = Collections.unmodifiableList(this.activityPatternBindingDefinitions);
            activityRegistryChanged = true;
        }
        if (!this.categoryActivityBindingDefinitions.equals(((AbstractActivityRegistry)this).categoryActivityBindingDefinitions)) {
            ((AbstractActivityRegistry)this).categoryActivityBindingDefinitions = Collections.unmodifiableList(this.categoryActivityBindingDefinitions);
            activityRegistryChanged = true;
        }
        if (!this.categoryDefinitions.equals(((AbstractActivityRegistry)this).categoryDefinitions)) {
            ((AbstractActivityRegistry)this).categoryDefinitions = Collections.unmodifiableList(this.categoryDefinitions);
            activityRegistryChanged = true;
        }
        if (!this.defaultEnabledActivities.equals(((AbstractActivityRegistry)this).defaultEnabledActivities)) {
            ((AbstractActivityRegistry)this).defaultEnabledActivities = Collections.unmodifiableList(this.defaultEnabledActivities);
            activityRegistryChanged = true;
        }
        if (activityRegistryChanged) {
            this.fireActivityRegistryChanged();
        }
    }

    private void readDefaultEnablement(IConfigurationElement configurationElement) {
        String enabledActivity = Persistence.readDefaultEnablement(new ConfigurationElementMemento(configurationElement));
        if (enabledActivity != null) {
            this.defaultEnabledActivities.add(enabledActivity);
        }
    }

    private void readActivityActivityBindingDefinition(IConfigurationElement configurationElement) {
        ActivityActivityBindingDefinition activityActivityBindingDefinition = Persistence.readActivityActivityBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getPluginId(configurationElement));
        if (activityActivityBindingDefinition != null) {
            this.activityActivityBindingDefinitions.add(activityActivityBindingDefinition);
        }
    }

    private void readActivityDefinition(IConfigurationElement configurationElement) {
        ActivityDefinition activityDefinition = Persistence.readActivityDefinition(new ConfigurationElementMemento(configurationElement), this.getPluginId(configurationElement));
        if (activityDefinition != null) {
            this.activityDefinitions.add(activityDefinition);
        }
    }

    private void readActivityPatternBindingDefinition(IConfigurationElement configurationElement) {
        ActivityPatternBindingDefinition activityPatternBindingDefinition = Persistence.readActivityPatternBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getPluginId(configurationElement));
        if (activityPatternBindingDefinition != null) {
            this.activityPatternBindingDefinitions.add(activityPatternBindingDefinition);
        }
    }

    private void readCategoryActivityBindingDefinition(IConfigurationElement configurationElement) {
        CategoryActivityBindingDefinition categoryActivityBindingDefinition = Persistence.readCategoryActivityBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getPluginId(configurationElement));
        if (categoryActivityBindingDefinition != null) {
            this.categoryActivityBindingDefinitions.add(categoryActivityBindingDefinition);
        }
    }

    private void readCategoryDefinition(IConfigurationElement configurationElement) {
        CategoryDefinition categoryDefinition = Persistence.readCategoryDefinition(new ConfigurationElementMemento(configurationElement), this.getPluginId(configurationElement));
        if (categoryDefinition != null) {
            this.categoryDefinitions.add(categoryDefinition);
        }
    }
}

