/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragSource;
import org.eclipse.ui.internal.dnd.IDropTarget;

class DragListener {
    private static final int HYSTERESIS = 10;
    private static final String SOURCE_ID = "org.eclipse.ui.internal.dnd.dragSource";
    private Point anchor = new Point(0, 0);
    private boolean isDragAllowed = false;
    private Control dragControl = null;
    private IDragSource dragSource = null;
    private Object draggedItem = null;
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            DragListener.this.isDragAllowed = DragListener.this.draggedItem != null;
        }
    };
    private Listener moveListener = new Listener(){

        public void handleEvent(Event event) {
            DragListener.this.handleMouseMove(event);
        }
    };
    private Listener clickListener = new Listener(){

        public void handleEvent(Event e) {
            DragListener.this.handleMouseClick(e);
        }
    };
    private Listener mouseDownListener = new Listener(){

        public void handleEvent(Event event) {
            DragListener.this.dragControl = (Control)event.widget;
            DragListener.this.anchor = DragListener.getEventLoc(event);
            DragListener.this.dragSource = (IDragSource)DragListener.this.dragControl.getData(DragListener.SOURCE_ID);
            DragListener.this.draggedItem = null;
            if (DragListener.this.dragSource != null) {
                DragListener.this.draggedItem = DragListener.this.dragSource.getDraggedItem(DragListener.this.anchor);
            }
        }
    };

    private static Point getEventLoc(Event event) {
        Control ctrl = (Control)event.widget;
        return ctrl.toDisplay(new Point(event.x, event.y));
    }

    private boolean hasMovedEnough(Event event) {
        return Geometry.distanceSquared((Point)DragListener.getEventLoc(event), (Point)this.anchor) >= 100;
    }

    public void attach(Control control, IDragSource source) {
        control.addListener(29, this.dragListener);
        control.addListener(4, this.clickListener);
        control.addListener(8, this.clickListener);
        control.addListener(3, this.mouseDownListener);
        control.addListener(5, this.moveListener);
        control.setData(SOURCE_ID, (Object)source);
    }

    public void detach(Control control) {
        control.removeListener(29, this.dragListener);
        control.removeListener(4, this.clickListener);
        control.removeListener(8, this.clickListener);
        control.removeListener(3, this.mouseDownListener);
        control.removeListener(5, this.moveListener);
        control.setData(SOURCE_ID, null);
    }

    protected void handleMouseClick(Event event) {
        this.isDragAllowed = false;
    }

    protected void handleMouseMove(Event e) {
        if (this.isDragAllowed && this.hasMovedEnough(e)) {
            this.openTracker(e);
        }
    }

    private void openTracker(Event e) {
        this.dragSource.dragStarted(this.draggedItem);
        Rectangle sourceBounds = this.dragSource.getDragRectangle(this.draggedItem);
        this.isDragAllowed = false;
        Point location = DragListener.getEventLoc(e);
        sourceBounds.x += location.x - this.anchor.x;
        sourceBounds.y += location.y - this.anchor.y;
        if (this.dragControl instanceof Control) {
            this.dragControl.setCapture(true);
        }
        IDropTarget target = DragUtil.dragToTarget(this.draggedItem, sourceBounds, location, true);
        if (this.dragControl instanceof Control) {
            this.dragControl.setCapture(false);
        }
        this.dragSource.dragFinished(this.draggedItem, target != null);
        if (target != null) {
            target.drop();
        }
    }
}

