/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class SizeCache {
    private Control control;
    private Point preferredSize;
    private Point cachedWidth;
    private Point cachedHeight;

    public SizeCache(Control control) {
        this.control = control;
    }

    public void flush() {
        this.preferredSize = null;
        this.cachedWidth = null;
        this.cachedHeight = null;
    }

    public Point computeSize(int widthHint, int heightHint) {
        if (widthHint == -1 && heightHint == -1) {
            if (this.preferredSize == null) {
                this.preferredSize = SizeCache.computeSize(this.control, widthHint, heightHint);
            }
            return this.preferredSize;
        }
        if (widthHint == -1) {
            if (this.preferredSize != null && heightHint == this.preferredSize.y) {
                return this.preferredSize;
            }
            if (this.cachedWidth == null || this.cachedWidth.y != heightHint) {
                this.cachedWidth = SizeCache.computeSize(this.control, widthHint, heightHint);
            }
            return this.cachedWidth;
        }
        if (heightHint == -1) {
            if (this.preferredSize != null && widthHint == this.preferredSize.x) {
                return this.preferredSize;
            }
            if (this.cachedHeight == null || this.cachedHeight.x != widthHint) {
                this.cachedHeight = SizeCache.computeSize(this.control, widthHint, heightHint);
            }
            return this.cachedHeight;
        }
        return SizeCache.computeSize(this.control, widthHint, heightHint);
    }

    private static Point computeSize(Control control, int widthHint, int heightHint) {
        Point result = control.computeSize(widthHint, heightHint);
        if (widthHint != -1) {
            result.x = widthHint;
        }
        if (heightHint != -1) {
            result.y = heightHint;
        }
        return result;
    }
}

