/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.ProgressFloatingWindow;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AnimationItem {
    WorkbenchWindow window;
    private ProgressFloatingWindow floatingWindow;
    IAnimationContainer animationContainer = new IAnimationContainer(){

        public void animationDone() {
        }

        public void animationStart() {
        }
    };
    private Object windowLock = new Object();

    public AnimationItem(WorkbenchWindow workbenchWindow) {
        this.window = workbenchWindow;
    }

    public void createControl(Composite parent) {
        Control animationItem = this.createAnimationItem(parent);
        animationItem.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                ProgressManagerUtil.openProgressView(AnimationItem.this.window);
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        animationItem.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseHover(MouseEvent e) {
                AnimationItem.this.openFloatingWindow();
            }
        });
        AnimationManager.getInstance().addItem(this);
    }

    protected abstract Control createAnimationItem(Composite var1);

    void paintImage(PaintEvent event, Image image, ImageData imageData) {
        event.gc.drawImage(image, 0, 0);
    }

    public abstract Control getControl();

    void openFloatingWindow() {
        Object object = this.windowLock;
        synchronized (object) {
            if (this.floatingWindow != null) {
                return;
            }
            if (!this.window.getShell().isVisible()) {
                return;
            }
            this.floatingWindow = new ProgressFloatingWindow(this.window, this.getControl());
        }
        WorkbenchJob floatingJob = new WorkbenchJob(ProgressMessages.getString("AnimationItem.openFloatingWindowJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object object = AnimationItem.this.windowLock;
                synchronized (object) {
                    if (AnimationItem.this.window.getShell() == null || !AnimationItem.this.window.getShell().isVisible() || AnimationItem.this.getControl().isDisposed()) {
                        AnimationItem.this.closeAndClearFloatingWindow();
                    }
                    if (AnimationItem.this.floatingWindow == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (AnimationItem.this.window != null && AnimationItem.this.window == AnimationItem.this.window.getWorkbench().getActiveWorkbenchWindow()) {
                        AnimationItem.this.floatingWindow.open();
                        int index = 0;
                        while (index < AnimationItem.this.window.getWorkbench().getWorkbenchWindowCount()) {
                            WorkbenchWindow progressToClose = (WorkbenchWindow)AnimationItem.this.window.getWorkbench().getWorkbenchWindows()[index];
                            if (progressToClose != AnimationItem.this.window) {
                                progressToClose.closeFloatingWindow();
                            }
                            ++index;
                        }
                    }
                    return Status.OK_STATUS;
                }
            }

            public boolean shouldRun() {
                if (AnimationManager.getInstance().isAnimated()) {
                    return true;
                }
                Object object = AnimationItem.this.windowLock;
                synchronized (object) {
                    AnimationItem.this.closeWindowInUI();
                    return false;
                }
            }
        };
        floatingJob.setSystem(true);
        floatingJob.schedule(500L);
    }

    void animationStart() {
        this.animationContainer.animationStart();
    }

    void animationDone() {
        this.closeFloatingWindow();
        this.animationContainer.animationDone();
    }

    public void closeFloatingWindow() {
        Object object = this.windowLock;
        synchronized (object) {
            this.closeWindowInUI();
        }
    }

    private void closeWindowInUI() {
        UIJob closeJob = new UIJob(ProgressMessages.getString("AnimationItem.CloseWindowJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AnimationItem.this.closeAndClearFloatingWindow();
                return Status.OK_STATUS;
            }
        };
        closeJob.setSystem(true);
        closeJob.schedule();
    }

    public int getPreferredWidth() {
        return AnimationManager.getInstance().getPreferredWidth() + 5;
    }

    private void closeAndClearFloatingWindow() {
        if (this.floatingWindow != null) {
            this.floatingWindow.close();
        }
        this.floatingWindow = null;
    }

    void setAnimationContainer(IAnimationContainer container) {
        this.animationContainer = container;
    }

    interface IAnimationContainer {
        public void animationStart();

        public void animationDone();
    }
}

