/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;

class JobInfo
extends JobTreeElement {
    private ArrayList children = new ArrayList();
    private Job job;
    private TaskInfo taskInfo;
    private IStatus blockedStatus;
    private boolean canceled = false;
    private GroupInfo parent;
    private int ticks = -1;

    Job getJob() {
        return this.job;
    }

    boolean hasTaskInfo() {
        return this.taskInfo != null;
    }

    void setTaskName(String name) {
        this.taskInfo.setTaskName(name);
    }

    JobInfo(Job enclosingJob) {
        this.job = enclosingJob;
    }

    String getDisplayString() {
        String name = this.getDisplayStringWithStatus();
        if (this.job.isSystem()) {
            return ProgressMessages.format("JobInfo.System", new Object[]{this.getJob().getName()});
        }
        return name;
    }

    private String getDisplayStringWithStatus() {
        if (this.isCanceled()) {
            return ProgressMessages.format("JobInfo.Cancelled", new Object[]{this.getJob().getName()});
        }
        if (this.isBlocked()) {
            return ProgressMessages.format("JobInfo.Blocked", new Object[]{this.getJob().getName(), this.blockedStatus.getMessage()});
        }
        if (this.getJob().getState() == 4) {
            if (this.taskInfo == null) {
                return this.getJob().getName();
            }
            return this.taskInfo.getDisplayString();
        }
        if (this.getJob().getState() == 1) {
            return ProgressMessages.format("JobInfo.Sleeping", new Object[]{this.getJob().getName()});
        }
        return ProgressMessages.format("JobInfo.Waiting", new Object[]{this.getJob().getName()});
    }

    public Image getDisplayImage() {
        int done = this.getPercentDone();
        if (done > 0) {
            return ProgressManager.getProgressImageFor(done);
        }
        if (this.isBlocked()) {
            return JFaceResources.getImage((String)"LOCKED_JOB");
        }
        int state = this.getJob().getState();
        if (state == 1) {
            return JFaceResources.getImage((String)"SLEEPING_JOB");
        }
        if (state == 2) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        return ProgressManager.getProgressImageFor(0);
    }

    Object[] getChildren() {
        return this.children.toArray();
    }

    boolean hasChildren() {
        return this.children.size() > 0;
    }

    void beginTask(String taskName, int work) {
        this.taskInfo = new TaskInfo(this, taskName, work);
    }

    void addSubTask(String subTaskName) {
        this.children.add(new SubTaskInfo(this, subTaskName));
    }

    void addWork(double workIncrement) {
        if (this.taskInfo == null) {
            return;
        }
        if (this.parent == null || this.ticks < 1) {
            this.taskInfo.addWork(workIncrement);
        } else {
            this.taskInfo.addWork(workIncrement, this.parent, this.ticks);
        }
    }

    void clearChildren() {
        this.children.clear();
    }

    Object getParent() {
        return this.parent;
    }

    boolean isJobInfo() {
        return true;
    }

    void clearTaskInfo() {
        this.taskInfo = null;
    }

    public int compareTo(Object arg0) {
        if (!(arg0 instanceof JobInfo)) {
            return super.compareTo(arg0);
        }
        JobInfo element = (JobInfo)arg0;
        if (element.getJob().getState() == this.getJob().getState()) {
            return this.compareJobs(this.getJob(), element.getJob());
        }
        if (this.getJob().getState() == 4) {
            return -1;
        }
        return 1;
    }

    int getPercentDone() {
        if (this.hasTaskInfo()) {
            return (int)this.taskInfo.preWork * 100 / this.taskInfo.totalWork;
        }
        return -1;
    }

    public IStatus getBlockedStatus() {
        return this.blockedStatus;
    }

    public void setBlockedStatus(IStatus blockedStatus) {
        this.blockedStatus = blockedStatus;
    }

    public boolean isBlocked() {
        return this.getBlockedStatus() != null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    void setGroupInfo(GroupInfo group) {
        this.parent = group;
    }

    void dispose() {
        if (this.parent != null) {
            this.parent.removeJobInfo(this);
        }
    }

    GroupInfo getGroupInfo() {
        if (this.parent != null && this.parent.isActive()) {
            return this.parent;
        }
        return null;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    boolean isActive() {
        return this.getJob().getState() != 0;
    }

    String getCondensedDisplayString() {
        if (this.hasTaskInfo()) {
            return this.getTaskInfo().getDisplayStringWithoutTask();
        }
        return this.getJob().getName();
    }

    public void cancel() {
        this.canceled = true;
        this.job.cancel();
    }

    public boolean isCancellable() {
        return super.isCancellable();
    }

    private int compareJobs(Job job1, Job job2) {
        if (job1.getPriority() == job2.getPriority()) {
            return job1.getName().compareTo(job2.getName());
        }
        if (job1.getPriority() > job2.getPriority()) {
            return 1;
        }
        return -1;
    }
}

