/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Iterator;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;

class ProgressTreeViewer
extends TreeViewer {
    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        if (element instanceof JobTreeElement && item != null && item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            this.updateColors(treeItem, (JobTreeElement)element);
            if (treeItem.getItemCount() > 0) {
                treeItem.setExpanded(true);
            }
        }
    }

    protected void updateColors(TreeItem treeItem, JobTreeElement element) {
        JobInfo info;
        if (element.isJobInfo() && (info = (JobInfo)element).getJob().getState() != 4) {
            this.setNotRunningColor(treeItem);
            return;
        }
        treeItem.setForeground(treeItem.getDisplay().getSystemColor(24));
    }

    protected void setNotRunningColor(TreeItem treeItem) {
        treeItem.setForeground(JFaceColors.getActiveHyperlinkText((Display)treeItem.getDisplay()));
    }

    public ProgressTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected void createChildren(Widget widget) {
        super.createChildren(widget);
        this.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ProgressTreeViewer.this.cancelSelection();
                }
            }
        });
    }

    public void cancelSelection() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Iterator elements = structured.iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                ((JobTreeElement)next).cancel();
            }
        }
    }
}

