/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.RegistryManager;
import org.eclipse.ui.internal.registry.ViewDescriptor;

public class ViewRegistry
extends RegistryManager
implements IViewRegistry,
IRegistryChangeListener {
    private List views = new ArrayList();
    private boolean dirtyViews = true;
    private List categories = new ArrayList();
    private boolean dirtyCategories = true;
    private Category miscCategory;
    protected static final String TAG_DESCRIPTION = "description";

    public ViewRegistry() {
        super(WorkbenchPlugin.PI_WORKBENCH, "views");
        InternalPlatform.getDefault().getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void add(Category desc) {
        if (this.findCategory(desc.getId()) == null) {
            this.dirtyCategories = true;
            ViewRegistryElement element = new ViewRegistryElement();
            element.addCategory(desc);
            this.add(element, desc.getPluginId());
        }
    }

    public void add(IViewDescriptor desc) {
        this.dirtyViews = true;
        ViewRegistryElement element = new ViewRegistryElement();
        element.addViewDescriptor(desc);
        this.add(element, desc.getConfigurationElement().getDeclaringExtension().getNamespace());
    }

    public Object buildNewCacheObject(IExtensionDelta delta) {
        IExtension extension = delta.getExtension();
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ViewRegistryElement regElement = new ViewRegistryElement();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement singleton = elements[i];
            String id = singleton.getAttribute("id");
            if (singleton.getName().equals("view")) {
                if (this.find(id) == null) {
                    try {
                        String descText = "";
                        IConfigurationElement[] children = singleton.getChildren(TAG_DESCRIPTION);
                        if (children.length >= 1) {
                            descText = children[0].getValue();
                        }
                        ViewDescriptor desc = new ViewDescriptor(singleton, descText);
                        regElement.addViewDescriptor(desc);
                        this.dirtyViews = true;
                    }
                    catch (CoreException e) {
                        WorkbenchPlugin.log("Unable to create view descriptor.", e.getStatus());
                    }
                }
            } else if (singleton.getName().equals("category")) {
                try {
                    if (this.findCategory(id) == null) {
                        Category category = new Category(singleton);
                        regElement.addCategory(category);
                        this.dirtyCategories = true;
                    }
                }
                catch (WorkbenchException e) {
                    WorkbenchPlugin.log("Unable to create view category.", e.getStatus());
                }
            }
            ++i;
        }
        List categories = regElement.getCategories();
        List views = regElement.getViewDescriptors();
        if (!(categories != null && categories.size() != 0 || views != null && views.size() != 0)) {
            return null;
        }
        return regElement;
    }

    public IViewDescriptor find(String id) {
        this.buildViews();
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor desc = (IViewDescriptor)iterator.next();
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public Category findCategory(String id) {
        this.buildCategories();
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category cat = (Category)iterator.next();
            if (!id.equals(cat.getRootPath())) continue;
            return cat;
        }
        return null;
    }

    public Category[] getCategories() {
        this.buildCategories();
        int nSize = this.categories.size();
        Category[] retArray = new Category[nSize];
        this.categories.toArray(retArray);
        return retArray;
    }

    public int getCategoryCount() {
        this.buildCategories();
        return this.categories.size();
    }

    public Category getMiscCategory() {
        return this.miscCategory;
    }

    public int getViewCount() {
        this.buildViews();
        return this.views.size();
    }

    public IViewDescriptor[] getViews() {
        this.buildViews();
        int nSize = this.views.size();
        IViewDescriptor[] retArray = new IViewDescriptor[nSize];
        this.views.toArray(retArray);
        return retArray;
    }

    public void mapViewsToCategories() {
        this.buildCategories();
        this.buildViews();
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor desc = (IViewDescriptor)iterator.next();
            Category cat = null;
            String[] catPath = desc.getCategoryPath();
            if (catPath != null) {
                String rootCat = catPath[0];
                cat = this.findCategory(rootCat);
            }
            if (cat != null) {
                if (cat.hasElement(desc)) continue;
                cat.addElement(desc);
                continue;
            }
            if (this.miscCategory == null) {
                this.miscCategory = new Category();
                this.add(this.miscCategory);
                this.buildCategories();
            }
            if (catPath != null) {
                String fmt = "Category {0} not found for view {1}.  This view added to ''{2}'' category.";
                WorkbenchPlugin.log(MessageFormat.format(fmt, catPath[0], desc.getID(), this.miscCategory.getLabel()));
            }
            this.miscCategory.addElement(desc);
        }
    }

    private void buildViews() {
        if (this.dirtyViews) {
            this.views = new ArrayList();
            Object[] regElements = this.getRegistryObjects();
            if (regElements == null) {
                this.dirtyViews = false;
                return;
            }
            int i = 0;
            while (i < regElements.length) {
                ViewRegistryElement element = (ViewRegistryElement)regElements[i];
                List viewDescs = element.getViewDescriptors();
                if (viewDescs != null && viewDescs.size() != 0) {
                    Iterator iter = viewDescs.iterator();
                    while (iter.hasNext()) {
                        IViewDescriptor view = (IViewDescriptor)iter.next();
                        this.views.add(view);
                    }
                }
                ++i;
            }
            this.dirtyViews = false;
        }
    }

    private void buildCategories() {
        if (this.dirtyCategories) {
            this.categories = new ArrayList();
            Object[] regElements = this.getRegistryObjects();
            if (regElements == null) {
                this.dirtyCategories = false;
                return;
            }
            int i = 0;
            while (i < regElements.length) {
                ViewRegistryElement element = (ViewRegistryElement)regElements[i];
                List tempCategories = element.getCategories();
                if (tempCategories != null && tempCategories.size() != 0) {
                    Iterator iter = tempCategories.iterator();
                    while (iter.hasNext()) {
                        Category category = (Category)iter.next();
                        this.categories.add(category);
                    }
                }
                ++i;
            }
            this.dirtyCategories = false;
        }
    }

    public void postChangeProcessing() {
        this.mapViewsToCategories();
    }

    private class ViewRegistryElement {
        private List viewDescriptors = new ArrayList();
        private List categoryDescriptors = new ArrayList();

        public void addCategory(Category element) {
            this.categoryDescriptors.add(element);
        }

        public void addViewDescriptor(IViewDescriptor element) {
            this.viewDescriptors.add(element);
        }

        public List getCategories() {
            return this.categoryDescriptors;
        }

        public List getViewDescriptors() {
            return this.viewDescriptors;
        }
    }
}

