/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IThemePreview;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingTheme;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementCategory;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public final class ColorsAndFontsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final ResourceBundle RESOURCE_BUNDLE;
    private Font appliedDialogFont;
    private Combo categoryCombo;
    private Map categoryMap = new HashMap(7);
    private Composite colorControls;
    private Map colorPreferencesToSet = new HashMap(7);
    private CascadingColorRegistry colorRegistry;
    private Button colorResetButton;
    private ColorSelector colorSelector;
    private Map colorValuesToSet = new HashMap(7);
    private TableColumn column;
    private Text commentText;
    private Composite controlArea;
    private StackLayout controlAreaLayout;
    private Composite defaultPreviewControl;
    private Text descriptionText;
    private List dialogFontWidgets = new ArrayList();
    private Button fontChangeButton;
    private Composite fontControls;
    private Map fontPreferencesToSet = new HashMap(7);
    private CascadingFontRegistry fontRegistry;
    private Button fontResetButton;
    private Button fontSystemButton;
    private Map fontValuesToSet = new HashMap(7);
    private TableViewer presentationList;
    private Composite previewComposite;
    private Map previewMap = new HashMap(7);
    private Set previewSet = new HashSet(7);
    private StackLayout stackLayout;
    private static String lastCategory;
    private final IThemeRegistry themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
    private ITheme currentTheme;
    private PresentationLabelProvider labelProvider;
    private CascadingTheme cascadingTheme;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.themes.ColorsAndFontsPreferencePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0x1000008);
        button.setText(label);
        this.myApplyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        button.setEnabled(false);
        return button;
    }

    private ThemeElementCategory createCategoryControl(Composite mainColumn) {
        Label label = new Label(mainColumn, 16384);
        label.setText(RESOURCE_BUNDLE.getString("category"));
        this.myApplyDialogFont((Control)label);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.categoryCombo = new Combo(mainColumn, 8);
        this.myApplyDialogFont((Control)this.categoryCombo);
        ThemeElementCategory[] categories = this.themeRegistry.getCategories();
        int i = 0;
        while (i < categories.length) {
            this.categoryCombo.add(categories[i].getLabel());
            ++i;
        }
        this.categoryCombo.add(RESOURCE_BUNDLE.getString("uncategorized"));
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.categoryCombo.setLayoutData((Object)data);
        if (categories.length == 0) {
            this.categoryCombo.select(0);
            return null;
        }
        int idx = 0;
        if (lastCategory != null && (idx = Arrays.binarySearch(categories, lastCategory, IThemeRegistry.ID_COMPARATOR)) < 0) {
            this.categoryCombo.select(categories.length);
            return null;
        }
        this.categoryCombo.select(idx);
        return categories[idx];
    }

    private void createColorControl() {
        Composite composite = new Composite(this.colorControls, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.colorSelector = new ColorSelector(composite);
        this.colorSelector.getButton().setLayoutData((Object)new GridData());
        this.myApplyDialogFont((Control)this.colorSelector.getButton());
        this.colorSelector.setEnabled(false);
        this.colorResetButton = this.createButton(composite, RESOURCE_BUNDLE.getString("reset"));
    }

    private void createCommentControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("comment"));
        this.myApplyDialogFont((Control)label);
        this.commentText = new Text(composite, 2888);
        this.commentText.setLayoutData((Object)new GridData(1808));
        this.commentText.setText("\n\n");
        this.myApplyDialogFont((Control)this.commentText);
    }

    protected Control createContents(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ColorsAndFontsPreferencePage.this.appliedDialogFont != null) {
                    ColorsAndFontsPreferencePage.this.appliedDialogFont.dispose();
                }
            }
        });
        Composite mainColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainColumn.setFont(parent.getFont());
        mainColumn.setLayout((Layout)layout);
        ThemeElementCategory category = this.createCategoryControl(mainColumn);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        Label label = new Label(mainColumn, 16384);
        label.setText(RESOURCE_BUNDLE.getString("colorsAndFonts"));
        this.myApplyDialogFont((Control)label);
        label.setLayoutData((Object)data);
        this.createList(mainColumn);
        Composite controlColumn = new Composite(mainColumn, 0);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        controlColumn.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlColumn.setLayout((Layout)layout);
        this.controlArea = new Composite(controlColumn, 0);
        this.controlAreaLayout = new StackLayout();
        this.controlArea.setLayout((Layout)this.controlAreaLayout);
        this.colorControls = new Composite(this.controlArea, 0);
        this.colorControls.setLayout((Layout)new FillLayout());
        this.createColorControl();
        this.fontControls = new Composite(this.controlArea, 0);
        this.fontControls.setLayout((Layout)new FillLayout());
        this.createFontControl();
        this.createCommentControl(controlColumn);
        this.createDescriptionControl(mainColumn);
        this.createPreviewControl(mainColumn);
        this.updateCategorySelection(category == null ? null : category.getId());
        this.hookListeners();
        return mainColumn;
    }

    private void createDescriptionControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 3;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("description"));
        this.myApplyDialogFont((Control)label);
        this.descriptionText = new Text(composite, 2888);
        data = new GridData(1808);
        this.descriptionText.setText("\n\n");
        this.descriptionText.setLayoutData((Object)data);
        this.myApplyDialogFont((Control)this.descriptionText);
    }

    private void createFontControl() {
        Composite composite = new Composite(this.fontControls, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fontSystemButton = this.createButton(composite, WorkbenchMessages.getString("FontsPreference.useSystemFont"));
        this.fontChangeButton = this.createButton(composite, JFaceResources.getString((String)"openChange"));
        this.fontResetButton = this.createButton(composite, RESOURCE_BUNDLE.getString("reset"));
    }

    private void createList(Composite parent) {
        this.presentationList = new TableViewer(parent, 2820);
        this.presentationList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelProvider = new PresentationLabelProvider();
        this.presentationList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.presentationList.setSorter(new ViewerSorter());
        GridData data = new GridData(1810);
        data.heightHint = 175;
        this.presentationList.getControl().setLayoutData((Object)data);
        this.column = new TableColumn(this.presentationList.getTable(), 16384);
        this.myApplyDialogFont(this.presentationList.getControl());
    }

    private void createPreviewControl(Composite mainColumn) {
        Composite composite = new Composite(mainColumn, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.widthHint = 400;
        data.heightHint = 175;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("preview"));
        this.myApplyDialogFont((Control)label);
        this.previewComposite = new Composite(composite, 0);
        data = new GridData(1808);
        this.previewComposite.setLayoutData((Object)data);
        this.stackLayout = new StackLayout();
        this.previewComposite.setLayout((Layout)this.stackLayout);
    }

    public void dispose() {
        super.dispose();
        this.clearPreviews();
        this.colorRegistry.dispose();
        this.fontRegistry.dispose();
    }

    private void clearPreviews() {
        if (this.cascadingTheme != null) {
            this.cascadingTheme.dispose();
        }
        Iterator i = this.previewSet.iterator();
        while (i.hasNext()) {
            IThemePreview preview = (IThemePreview)i.next();
            try {
                preview.dispose();
            }
            catch (RuntimeException e) {
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("errorDisposePreviewLog"), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            }
        }
        this.previewSet.clear();
    }

    private ColorDefinition getColorAncestor(ColorDefinition definition) {
        String defaultsTo = definition.getDefaultsTo();
        if (defaultsTo == null) {
            return null;
        }
        return this.themeRegistry.findColor(defaultsTo);
    }

    private RGB getColorAncestorValue(ColorDefinition definition) {
        ColorDefinition ancestor = this.getColorAncestor(definition);
        if (ancestor == null) {
            return null;
        }
        return this.getColorValue(ancestor);
    }

    private RGB getColorValue(ColorDefinition definition) {
        String id = definition.getId();
        RGB updatedRGB = (RGB)this.colorPreferencesToSet.get(id);
        if (updatedRGB == null && (updatedRGB = (RGB)this.colorValuesToSet.get(id)) == null) {
            updatedRGB = this.currentTheme.getColorRegistry().getRGB(id);
        }
        return updatedRGB;
    }

    private Composite getDefaultPreviewControl() {
        if (this.defaultPreviewControl == null) {
            this.defaultPreviewControl = new Composite(this.previewComposite, 0);
            this.defaultPreviewControl.setLayout((Layout)new FillLayout());
            Label l = new Label(this.defaultPreviewControl, 16384);
            l.setText(RESOURCE_BUNDLE.getString("noPreviewAvailable"));
            this.myApplyDialogFont((Control)l);
        }
        return this.defaultPreviewControl;
    }

    private ColorDefinition[] getDescendantColors(ColorDefinition definition) {
        ArrayList<ColorDefinition> list = new ArrayList<ColorDefinition>(5);
        String id = definition.getId();
        IHierarchalThemeElementDefinition[] colors = this.themeRegistry.getColors();
        ColorDefinition[] sorted = new ColorDefinition[colors.length];
        System.arraycopy(colors, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted, new IThemeRegistry.HierarchyComparator(colors));
        int i = 0;
        while (i < sorted.length) {
            if (id.equals(sorted[i].getDefaultsTo())) {
                list.add(sorted[i]);
            }
            ++i;
        }
        return list.toArray(new ColorDefinition[list.size()]);
    }

    private FontDefinition[] getDescendantFonts(FontDefinition definition) {
        ArrayList<FontDefinition> list = new ArrayList<FontDefinition>(5);
        String id = definition.getId();
        IHierarchalThemeElementDefinition[] fonts = this.themeRegistry.getFonts();
        FontDefinition[] sorted = new FontDefinition[fonts.length];
        System.arraycopy(fonts, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted, new IThemeRegistry.HierarchyComparator(fonts));
        int i = 0;
        while (i < sorted.length) {
            if (id.equals(sorted[i].getDefaultsTo())) {
                list.add(sorted[i]);
            }
            ++i;
        }
        return list.toArray(new FontDefinition[list.size()]);
    }

    private FontDefinition getFontAncestor(FontDefinition definition) {
        String defaultsTo = definition.getDefaultsTo();
        if (defaultsTo == null) {
            return null;
        }
        return this.themeRegistry.findFont(defaultsTo);
    }

    private FontData[] getFontAncestorValue(FontDefinition definition) {
        FontDefinition ancestor = this.getFontAncestor(definition);
        if (ancestor == null) {
            return PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)definition.getId());
        }
        return this.getFontValue(ancestor);
    }

    protected FontData[] getFontValue(FontDefinition definition) {
        String id = definition.getId();
        FontData[] updatedFD = (FontData[])this.fontPreferencesToSet.get(id);
        if (updatedFD == null && (updatedFD = (FontData[])this.fontValuesToSet.get(id)) == null) {
            updatedFD = this.currentTheme.getFontRegistry().getFontData(id);
        }
        return updatedFD;
    }

    protected ColorDefinition getSelectedColorDefinition() {
        Object o = ((IStructuredSelection)this.presentationList.getSelection()).getFirstElement();
        if (o instanceof ColorDefinition) {
            return (ColorDefinition)o;
        }
        return null;
    }

    protected FontDefinition getSelectedFontDefinition() {
        Object o = ((IStructuredSelection)this.presentationList.getSelection()).getFirstElement();
        if (o instanceof FontDefinition) {
            return (FontDefinition)o;
        }
        return null;
    }

    private void hookListeners() {
        this.categoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorsAndFontsPreferencePage.this.refreshCategory();
            }
        });
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ColorDefinition definition = ColorsAndFontsPreferencePage.this.getSelectedColorDefinition();
                RGB newRGB = (RGB)event.getNewValue();
                if (definition != null && newRGB != null && !newRGB.equals(event.getOldValue())) {
                    ColorsAndFontsPreferencePage.this.setColorPreferenceValue(definition, newRGB);
                    ColorsAndFontsPreferencePage.this.setRegistryValue(definition, newRGB);
                }
                ColorsAndFontsPreferencePage.this.updateColorControls(definition);
            }
        });
        this.presentationList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    ColorsAndFontsPreferencePage.this.swapNoControls();
                    ColorsAndFontsPreferencePage.this.updateColorControls(null);
                } else {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (element instanceof ColorDefinition) {
                        ColorsAndFontsPreferencePage.this.swapColorControls();
                        ColorsAndFontsPreferencePage.this.updateColorControls((ColorDefinition)element);
                    } else if (element instanceof FontDefinition) {
                        ColorsAndFontsPreferencePage.this.swapFontControls();
                        ColorsAndFontsPreferencePage.this.updateFontControls((FontDefinition)element);
                    }
                }
            }
        });
        this.colorResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDefinition definition = ColorsAndFontsPreferencePage.this.getSelectedColorDefinition();
                if (ColorsAndFontsPreferencePage.this.resetColor(definition)) {
                    ColorsAndFontsPreferencePage.this.updateColorControls(definition);
                }
            }
        });
        this.fontResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDefinition definition = ColorsAndFontsPreferencePage.this.getSelectedFontDefinition();
                if (ColorsAndFontsPreferencePage.this.resetFont(definition)) {
                    ColorsAndFontsPreferencePage.this.updateFontControls(definition);
                }
            }
        });
        this.fontChangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDefinition definition = ColorsAndFontsPreferencePage.this.getSelectedFontDefinition();
                if (definition != null) {
                    FontDialog fontDialog = new FontDialog(ColorsAndFontsPreferencePage.this.fontChangeButton.getShell());
                    FontData[] currentData = ColorsAndFontsPreferencePage.this.getFontValue(definition);
                    fontDialog.setFontList(currentData);
                    if (fontDialog.open() != null) {
                        ColorsAndFontsPreferencePage.this.setFontPreferenceValue(definition, fontDialog.getFontList());
                        ColorsAndFontsPreferencePage.this.setRegistryValue(definition, fontDialog.getFontList());
                    }
                    ColorsAndFontsPreferencePage.this.updateFontControls(definition);
                }
            }
        });
        this.fontSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDefinition definition = ColorsAndFontsPreferencePage.this.getSelectedFontDefinition();
                if (definition != null) {
                    FontData[] defaultFontData = JFaceResources.getDefaultFont().getFontData();
                    ColorsAndFontsPreferencePage.this.setFontPreferenceValue(definition, defaultFontData);
                    ColorsAndFontsPreferencePage.this.setRegistryValue(definition, defaultFontData);
                    ColorsAndFontsPreferencePage.this.updateFontControls(definition);
                }
            }
        });
        this.presentationList.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ColorsAndFontsPreferencePage.this.column.setWidth(((ColorsAndFontsPreferencePage)ColorsAndFontsPreferencePage.this).presentationList.getControl().getSize().x - 4);
            }
        });
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(workbench.getPreferenceStore());
        final IThemeManager themeManager = workbench.getThemeManager();
        themeManager.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                    ColorsAndFontsPreferencePage.this.updateThemeInfo(themeManager);
                    ColorsAndFontsPreferencePage.this.refreshCategory();
                }
            }
        });
        this.updateThemeInfo(themeManager);
    }

    private void updateThemeInfo(IThemeManager manager) {
        this.clearPreviews();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.colorRegistry != null) {
            this.colorRegistry.dispose();
        }
        if (this.fontRegistry != null) {
            this.fontRegistry.dispose();
        }
        this.currentTheme = manager.getCurrentTheme();
        this.colorRegistry = new CascadingColorRegistry(this.currentTheme.getColorRegistry());
        this.fontRegistry = new CascadingFontRegistry(this.currentTheme.getFontRegistry());
        this.fontPreferencesToSet.clear();
        this.fontValuesToSet.clear();
        this.colorPreferencesToSet.clear();
        this.colorValuesToSet.clear();
        if (this.labelProvider != null) {
            this.labelProvider.hookListeners();
        }
    }

    private boolean isDefault(ColorDefinition definition) {
        String id = definition.getId();
        return this.colorPreferencesToSet.containsKey(id) ? (definition.getValue() != null ? this.colorPreferencesToSet.get(id).equals(definition.getValue()) : this.colorPreferencesToSet.get(id).equals(this.getColorAncestorValue(definition))) : (definition.getValue() != null ? this.getPreferenceStore().isDefault(id) : this.getColorValue(definition).equals((Object)this.getColorAncestorValue(definition)));
    }

    private boolean isDefault(FontDefinition definition) {
        String id = definition.getId();
        if (this.fontPreferencesToSet.containsKey(id)) {
            if (definition.getValue() != null) {
                if (Arrays.equals((FontData[])this.fontPreferencesToSet.get(id), new FontData[]{StringConverter.asFontData((String)this.getPreferenceStore().getDefaultString(id), null)})) {
                    return true;
                }
            } else {
                Object[] ancestor = this.getFontAncestorValue(definition);
                if (Arrays.equals((FontData[])this.fontPreferencesToSet.get(id), ancestor)) {
                    return true;
                }
            }
        } else if (definition.getValue() != null) {
            if (this.getPreferenceStore().isDefault(id)) {
                return true;
            }
        } else {
            Object[] ancestor = this.getFontAncestorValue(definition);
            if (ancestor == null) {
                return true;
            }
            if (Arrays.equals(this.getFontValue(definition), ancestor)) {
                return true;
            }
        }
        return false;
    }

    private void myApplyDialogFont(Control control) {
        control.setFont(JFaceResources.getDialogFont());
        this.dialogFontWidgets.add(control);
    }

    protected void performApply() {
        super.performApply();
        Font oldFont = this.appliedDialogFont;
        FontDefinition fontDefinition = this.themeRegistry.findFont("org.eclipse.jface.dialogfont");
        if (fontDefinition == null) {
            return;
        }
        FontData[] newData = this.getFontValue(fontDefinition);
        this.appliedDialogFont = new Font((Device)this.getControl().getDisplay(), newData);
        this.updateForDialogFontChange(this.appliedDialogFont);
        this.getApplyButton().setFont(this.appliedDialogFont);
        this.getDefaultsButton().setFont(this.appliedDialogFont);
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    private void performColorDefaults() {
        IHierarchalThemeElementDefinition[] definitions = this.themeRegistry.getColors();
        ColorDefinition[] definitionsCopy = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, definitionsCopy, 0, definitions.length);
        Arrays.sort(definitionsCopy, new IThemeRegistry.HierarchyComparator(definitions));
        int i = 0;
        while (i < definitionsCopy.length) {
            this.resetColor(definitionsCopy[i]);
            ++i;
        }
        this.updateColorControls(this.getSelectedColorDefinition());
    }

    private boolean performColorOk() {
        String id;
        Iterator i = this.colorPreferencesToSet.keySet().iterator();
        while (i.hasNext()) {
            String storeString;
            id = (String)i.next();
            String key = ThemeElementHelper.createPreferenceKey(this.currentTheme, id);
            RGB rgb = (RGB)this.colorPreferencesToSet.get(id);
            String rgbString = StringConverter.asString((RGB)rgb);
            if (rgbString.equals(storeString = this.getPreferenceStore().getString(key))) continue;
            this.currentTheme.getColorRegistry().put(id, rgb);
            this.colorValuesToSet.remove(id);
            this.getPreferenceStore().setValue(key, rgbString);
        }
        this.colorPreferencesToSet.clear();
        i = this.colorValuesToSet.keySet().iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            RGB rgb = (RGB)this.colorValuesToSet.get(id);
            this.currentTheme.getColorRegistry().put(id, rgb);
        }
        this.colorValuesToSet.clear();
        return true;
    }

    protected void performDefaults() {
        this.performColorDefaults();
        this.performFontDefaults();
    }

    private void performFontDefaults() {
        IHierarchalThemeElementDefinition[] definitions = this.themeRegistry.getFonts();
        FontDefinition[] definitionsCopy = new FontDefinition[definitions.length];
        System.arraycopy(definitions, 0, definitionsCopy, 0, definitions.length);
        Arrays.sort(definitionsCopy, new IThemeRegistry.HierarchyComparator(definitions));
        int i = 0;
        while (i < definitionsCopy.length) {
            this.resetFont(definitionsCopy[i]);
            ++i;
        }
        this.updateFontControls(this.getSelectedFontDefinition());
    }

    private boolean performFontOk() {
        String id;
        Iterator i = this.fontPreferencesToSet.keySet().iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            String key = ThemeElementHelper.createPreferenceKey(this.currentTheme, id);
            FontData[] fd = (FontData[])this.fontPreferencesToSet.get(id);
            this.currentTheme.getFontRegistry().put(id, fd);
            this.fontValuesToSet.remove(id);
            this.getPreferenceStore().setValue(key, PreferenceConverter.getStoredRepresentation((FontData[])fd));
        }
        this.fontPreferencesToSet.clear();
        i = this.fontValuesToSet.keySet().iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            FontData[] fd = (FontData[])this.fontValuesToSet.get(id);
            this.currentTheme.getFontRegistry().put(id, fd);
        }
        this.fontValuesToSet.clear();
        return true;
    }

    public boolean performOk() {
        return this.performColorOk() && this.performFontOk();
    }

    private void refreshCategory() {
        int index = this.categoryCombo.getSelectionIndex();
        if (index == this.categoryCombo.getItemCount() - 1) {
            this.updateCategorySelection(null);
        } else {
            this.updateCategorySelection(this.themeRegistry.getCategories()[index].getId());
        }
        this.updateColorControls(null);
        this.updateFontControls(null);
    }

    private boolean resetColor(ColorDefinition definition) {
        RGB newRGB;
        if (!this.isDefault(definition) && (newRGB = definition.getValue() != null ? definition.getValue() : this.getColorAncestorValue(definition)) != null) {
            this.setColorPreferenceValue(definition, newRGB);
            this.setRegistryValue(definition, newRGB);
            return true;
        }
        return false;
    }

    protected boolean resetFont(FontDefinition definition) {
        FontData[] newFD;
        if (!this.isDefault(definition) && (newFD = definition.getDefaultsTo() != null ? this.getFontAncestorValue(definition) : PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)definition.getId())) != null) {
            this.setFontPreferenceValue(definition, newFD);
            this.setRegistryValue(definition, newFD);
            return true;
        }
        return false;
    }

    protected void setColorPreferenceValue(ColorDefinition definition, RGB newRGB) {
        this.setDescendantRegistryValues(definition, newRGB);
        this.colorPreferencesToSet.put(definition.getId(), newRGB);
    }

    private void setDescendantRegistryValues(ColorDefinition definition, RGB newRGB) {
        ColorDefinition[] children = this.getDescendantColors(definition);
        int i = 0;
        while (i < children.length) {
            if (this.isDefault(children[i])) {
                this.setDescendantRegistryValues(children[i], newRGB);
                this.setRegistryValue(children[i], newRGB);
                this.colorValuesToSet.put(children[i].getId(), newRGB);
            }
            ++i;
        }
    }

    private void setDescendantRegistryValues(FontDefinition definition, FontData[] datas) {
        FontDefinition[] children = this.getDescendantFonts(definition);
        int i = 0;
        while (i < children.length) {
            if (this.isDefault(children[i])) {
                this.setDescendantRegistryValues(children[i], datas);
                this.setRegistryValue(children[i], datas);
                this.fontValuesToSet.put(children[i].getId(), datas);
            }
            ++i;
        }
    }

    protected void setFontPreferenceValue(FontDefinition definition, FontData[] datas) {
        this.setDescendantRegistryValues(definition, datas);
        this.fontPreferencesToSet.put(definition.getId(), datas);
    }

    protected void setRegistryValue(ColorDefinition definition, RGB newRGB) {
        this.colorRegistry.put(definition.getId(), newRGB);
    }

    protected void setRegistryValue(FontDefinition definition, FontData[] datas) {
        this.fontRegistry.put(definition.getId(), datas);
    }

    protected void swapColorControls() {
        this.controlAreaLayout.topControl = this.colorControls;
        this.controlArea.layout();
    }

    protected void swapFontControls() {
        this.controlAreaLayout.topControl = this.fontControls;
        this.controlArea.layout();
    }

    protected void swapNoControls() {
        this.controlAreaLayout.topControl = null;
        this.controlArea.layout();
    }

    private void updateCategorySelection(String categoryId) {
        String key = categoryId;
        ThemeElementCategory category = null;
        if (categoryId == null) {
            key = "uncategorized";
        } else {
            int idx = Arrays.binarySearch(this.themeRegistry.getCategories(), categoryId, IThemeRegistry.ID_COMPARATOR);
            if (idx == -1) {
                categoryId = null;
            } else {
                category = this.themeRegistry.getCategories()[idx];
            }
        }
        lastCategory = key;
        Object[] defintions = (Object[])this.categoryMap.get(key);
        if (defintions == null) {
            ArrayList<ICategorizedThemeElementDefinition> list = new ArrayList<ICategorizedThemeElementDefinition>();
            ColorDefinition[] colorDefinitions = this.themeRegistry.getColors();
            int i = 0;
            while (i < colorDefinitions.length) {
                String catId;
                if (colorDefinitions[i].isEditable() && ((catId = colorDefinitions[i].getCategoryId()) == null && categoryId == null || catId != null && categoryId != null && categoryId.equals(catId))) {
                    list.add(colorDefinitions[i]);
                }
                ++i;
            }
            FontDefinition[] fontDefinitions = this.themeRegistry.getFonts();
            int i2 = 0;
            while (i2 < fontDefinitions.length) {
                String catId;
                if (fontDefinitions[i2].isEditable() && ((catId = fontDefinitions[i2].getCategoryId()) == null && categoryId == null || catId != null && categoryId != null && categoryId.equals(catId))) {
                    list.add(fontDefinitions[i2]);
                }
                ++i2;
            }
            defintions = new Object[list.size()];
            list.toArray(defintions);
            this.categoryMap.put(key, defintions);
        }
        this.presentationList.setInput((Object)defintions);
        Composite previewControl = (Composite)this.previewMap.get(key);
        if (previewControl == null && category != null) {
            try {
                IThemePreview preview = category.createPreview();
                if (preview != null) {
                    previewControl = new Composite(this.previewComposite, 0);
                    previewControl.setLayout((Layout)new FillLayout());
                    this.myApplyDialogFont((Control)previewControl);
                    ITheme theme = this.getCascadingTheme();
                    preview.createControl(previewControl, theme);
                    this.previewSet.add(preview);
                }
            }
            catch (CoreException e) {
                previewControl = new Composite(this.previewComposite, 0);
                previewControl.setLayout((Layout)new FillLayout());
                this.myApplyDialogFont((Control)previewControl);
                Text error = new Text(previewControl, 72);
                error.setText(RESOURCE_BUNDLE.getString("errorCreatingPreview"));
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("errorCreatePreviewLog"), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            }
        }
        if (previewControl == null) {
            previewControl = this.getDefaultPreviewControl();
        }
        this.previewMap.put(key, previewControl);
        this.stackLayout.topControl = previewControl;
        this.previewComposite.layout();
    }

    private ITheme getCascadingTheme() {
        if (this.cascadingTheme == null) {
            this.cascadingTheme = new CascadingTheme(this.currentTheme, this.colorRegistry, this.fontRegistry);
        }
        return this.cascadingTheme;
    }

    protected void updateColorControls(ColorDefinition definition) {
        if (definition != null) {
            this.colorSelector.setColorValue(this.getColorValue(definition));
        }
        if (definition != null) {
            this.colorResetButton.setEnabled(true);
            this.colorSelector.setEnabled(true);
            if (this.isDefault(definition)) {
                if (definition.getDefaultsTo() != null) {
                    int idx = Arrays.binarySearch(this.themeRegistry.getColors(), definition.getDefaultsTo(), IThemeRegistry.ID_COMPARATOR);
                    if (idx >= 0) {
                        this.commentText.setText(MessageFormat.format(RESOURCE_BUNDLE.getString("Colors.currentlyMappedTo"), this.themeRegistry.getColors()[idx].getLabel()));
                    } else {
                        this.commentText.setText("");
                    }
                } else {
                    this.commentText.setText(RESOURCE_BUNDLE.getString("Colors.currentlyDefault"));
                }
            } else {
                this.commentText.setText(RESOURCE_BUNDLE.getString("Colors.customValue"));
            }
            String description = definition.getDescription();
            this.descriptionText.setText(description == null ? "" : description);
        } else {
            this.colorResetButton.setEnabled(false);
            this.colorSelector.setEnabled(false);
            this.commentText.setText("");
            this.descriptionText.setText("");
        }
    }

    protected void updateFontControls(FontDefinition definition) {
        if (definition != null) {
            this.fontSystemButton.setEnabled(true);
            this.fontResetButton.setEnabled(true);
            this.fontChangeButton.setEnabled(true);
            String valueString = StringConverter.asString((FontData)this.getFontValue(definition)[0]);
            if (this.isDefault(definition)) {
                if (definition.getDefaultsTo() != null) {
                    int idx = Arrays.binarySearch(this.themeRegistry.getFonts(), definition.getDefaultsTo(), IThemeRegistry.ID_COMPARATOR);
                    if (idx >= 0) {
                        this.commentText.setText(MessageFormat.format(RESOURCE_BUNDLE.getString("Fonts.currentlyMappedTo"), this.themeRegistry.getFonts()[idx].getLabel(), valueString));
                    } else {
                        this.commentText.setText("");
                    }
                } else {
                    this.commentText.setText(MessageFormat.format(RESOURCE_BUNDLE.getString("Fonts.currentlyDefault"), valueString));
                }
            } else {
                this.commentText.setText(MessageFormat.format(RESOURCE_BUNDLE.getString("Fonts.customValue"), valueString));
            }
            String description = definition.getDescription();
            this.descriptionText.setText(description == null ? "" : description);
        } else {
            this.fontSystemButton.setEnabled(false);
            this.fontResetButton.setEnabled(false);
            this.fontChangeButton.setEnabled(false);
            this.commentText.setText("");
            this.descriptionText.setText("");
        }
    }

    private void updateForDialogFontChange(Font newFont) {
        Iterator iterator = this.dialogFontWidgets.iterator();
        while (iterator.hasNext()) {
            ((Control)iterator.next()).setFont(newFont);
        }
    }

    private class PresentationLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private HashMap fonts = new HashMap();
        private HashMap images = new HashMap();
        private int imageSize = -1;
        private int usableImageSize = -1;
        private IPropertyChangeListener listener = new IPropertyChangeListener(this){
            final /* synthetic */ PresentationLabelProvider this$1;
            {
                this.this$1 = presentationLabelProvider;
            }

            public void propertyChange(PropertyChangeEvent event) {
                PresentationLabelProvider.access$0(this.this$1, new LabelProviderChangedEvent((IBaseLabelProvider)this.this$1));
            }
        };
        private Image emptyImage;

        public PresentationLabelProvider() {
            this.hookListeners();
        }

        public void hookListeners() {
            ColorsAndFontsPreferencePage.this.colorRegistry.addListener(this.listener);
            ColorsAndFontsPreferencePage.this.fontRegistry.addListener(this.listener);
        }

        public void dispose() {
            super.dispose();
            ColorsAndFontsPreferencePage.this.colorRegistry.removeListener(this.listener);
            ColorsAndFontsPreferencePage.this.fontRegistry.removeListener(this.listener);
            Iterator i = this.images.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.images.clear();
            i = this.fonts.values().iterator();
            while (i.hasNext()) {
                ((Font)i.next()).dispose();
            }
            this.fonts.clear();
            if (this.emptyImage != null) {
                this.emptyImage.dispose();
                this.emptyImage = null;
            }
        }

        public Font getFont(Object element) {
            if (element instanceof FontDefinition) {
                int parentHeight = ColorsAndFontsPreferencePage.this.presentationList.getControl().getFont().getFontData()[0].getHeight();
                Display display = ColorsAndFontsPreferencePage.this.presentationList.getControl().getDisplay();
                Font baseFont = ColorsAndFontsPreferencePage.this.fontRegistry.get(((FontDefinition)element).getId());
                Font font = (Font)this.fonts.get(baseFont);
                if (font == null) {
                    FontData[] data = baseFont.getFontData();
                    int i = 0;
                    while (i < data.length) {
                        data[i].setHeight(parentHeight);
                        ++i;
                    }
                    font = new Font((Device)display, data);
                    this.fonts.put(baseFont, font);
                }
                return font;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof ColorDefinition) {
                Color c = ColorsAndFontsPreferencePage.this.colorRegistry.get(((ColorDefinition)element).getId());
                Image image = (Image)this.images.get(c);
                if (image == null) {
                    Display display = ColorsAndFontsPreferencePage.this.presentationList.getControl().getDisplay();
                    this.ensureImageSize(display);
                    image = new Image((Device)display, this.imageSize, this.imageSize);
                    GC gc = new GC((Drawable)image);
                    gc.setBackground(ColorsAndFontsPreferencePage.this.presentationList.getControl().getBackground());
                    gc.setForeground(ColorsAndFontsPreferencePage.this.presentationList.getControl().getBackground());
                    gc.drawRectangle(0, 0, this.imageSize - 1, this.imageSize - 1);
                    gc.setForeground(ColorsAndFontsPreferencePage.this.presentationList.getControl().getForeground());
                    gc.setBackground(c);
                    int offset = (this.imageSize - this.usableImageSize) / 2;
                    gc.drawRectangle(offset, offset, this.usableImageSize - offset, this.usableImageSize - offset);
                    gc.fillRectangle(offset + 1, offset + 1, this.usableImageSize - offset - 1, this.usableImageSize - offset - 1);
                    gc.dispose();
                    this.images.put(c, image);
                }
                return image;
            }
            if (this.emptyImage == null) {
                Display display = ColorsAndFontsPreferencePage.this.presentationList.getControl().getDisplay();
                this.ensureImageSize(display);
                this.emptyImage = new Image((Device)display, this.imageSize, this.imageSize);
                GC gc = new GC((Drawable)this.emptyImage);
                gc.setBackground(ColorsAndFontsPreferencePage.this.presentationList.getControl().getBackground());
                gc.setForeground(ColorsAndFontsPreferencePage.this.presentationList.getControl().getBackground());
                gc.fillRectangle(0, 0, this.imageSize - 1, this.imageSize - 1);
                gc.dispose();
            }
            return this.emptyImage;
        }

        private void ensureImageSize(Display display) {
            if (this.imageSize == -1) {
                this.imageSize = ColorsAndFontsPreferencePage.this.presentationList.getTable().getItemHeight();
                this.usableImageSize = Math.max(1, this.imageSize - 4);
            }
        }

        public String getText(Object element) {
            if (element instanceof IThemeElementDefinition) {
                return ((IThemeElementDefinition)element).getLabel();
            }
            return "";
        }

        static /* synthetic */ void access$0(PresentationLabelProvider presentationLabelProvider, LabelProviderChangedEvent labelProviderChangedEvent) {
            presentationLabelProvider.fireLabelProviderChanged(labelProviderChangedEvent);
        }
    }
}

