/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ContentTypeManager
implements IContentTypeManager,
IRegistryChangeListener {
    private static ContentTypeManager instance;
    private static final int MARK_LIMIT = 1024;
    public static final String PT_CONTENTTYPES = "contentTypes";
    private Map catalog = new HashMap();

    static String getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        return dotPosition == -1 || dotPosition == fileName.length() - 1 ? null : fileName.substring(dotPosition + 1);
    }

    public static synchronized IContentTypeManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ContentTypeManager();
        instance.startup();
        return instance;
    }

    protected ContentTypeManager() {
    }

    protected void addContentType(IContentType contentType) {
        this.catalog.put(contentType.getId(), contentType);
    }

    protected IContentType createContentType(String namespace, String simpleId, String name, String[] fileExtensions, String[] fileNames, String baseTypeId) {
        ContentType contentType = new ContentType(this);
        contentType.setSimpleId(simpleId);
        contentType.setNamespace(namespace);
        contentType.setName(name);
        contentType.setFileExtensions(fileExtensions);
        contentType.setFileNames(fileNames);
        contentType.setBaseTypeId(baseTypeId);
        return contentType;
    }

    private void ensureValid(ContentType type) {
        if (type.getValidation() != 3) {
            return;
        }
        if (type.getBaseTypeId() == null) {
            type.setValidation((byte)1);
            return;
        }
        ContentType baseType = (ContentType)this.catalog.get(type.getBaseTypeId());
        if (baseType == null) {
            type.setValidation((byte)2);
            return;
        }
        type.setValidation((byte)2);
        this.ensureValid(baseType);
        type.setValidation(baseType.getValidation());
    }

    public IContentType findContentTypeFor(InputStream contents, IContentType[] subset) throws IOException {
        ByteArrayInputStream buffer = this.readBuffer(contents);
        if (buffer == null) {
            return null;
        }
        if (subset == null) {
            subset = this.getAllContentTypes();
        }
        ArrayList<IContentType> appropriate = new ArrayList<IContentType>();
        int i = 0;
        while (i < subset.length) {
            IContentDescriber describer = ((ContentType)subset[i]).getDescriber();
            if (describer != null && this.describe(describer, buffer, null, 0) == 0) {
                appropriate.add(subset[i]);
            }
            ++i;
        }
        return this.mostAppropriate(appropriate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteArrayInputStream readBuffer(InputStream contents) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        boolean failed = false;
        try {
            try {
                contents.mark(1024);
                byte[] buffer = new byte[1024];
                int read = contents.read(buffer);
                byteArrayInputStream = read == -1 ? null : new ByteArrayInputStream(buffer, 0, read);
                Object var5_7 = null;
                if (failed) return byteArrayInputStream;
            }
            catch (IOException ioe) {
                failed = true;
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (failed) throw throwable;
            contents.reset();
            throw throwable;
        }
        contents.reset();
        return byteArrayInputStream;
    }

    public IContentType findContentTypeForFileName(String fileName) {
        IContentType[] associated = this.findContentTypesForFileName(fileName);
        return associated.length == 0 ? null : associated[1];
    }

    public IContentType[] findContentTypesFor(InputStream contents, IContentType[] subset) throws IOException {
        ByteArrayInputStream buffer = this.readBuffer(contents);
        if (buffer == null) {
            return null;
        }
        if (subset == null) {
            subset = this.getAllContentTypes();
        }
        ArrayList<IContentType> appropriate = new ArrayList<IContentType>();
        int i = 0;
        while (i < subset.length) {
            IContentDescriber describer = ((ContentType)subset[i]).getDescriber();
            if (describer != null && this.describe(describer, buffer, null, 0) == 0) {
                appropriate.add(subset[i]);
            }
            ++i;
        }
        return appropriate.toArray(new IContentType[appropriate.size()]);
    }

    public IContentType[] findContentTypesForFileName(String fileName) {
        HashSet<ContentType> types = new HashSet<ContentType>();
        Iterator iter = this.catalog.values().iterator();
        while (iter.hasNext()) {
            ContentType contentType = (ContentType)iter.next();
            if (!contentType.isValid() || this.indexOf(contentType.getFileNames(), fileName) < 0) continue;
            types.add(contentType);
        }
        String fileExtension = ContentTypeManager.getFileExtension(fileName);
        if (fileExtension != null) {
            Iterator iter2 = this.catalog.values().iterator();
            while (iter2.hasNext()) {
                ContentType contentType = (ContentType)iter2.next();
                if (!contentType.isValid() || this.indexOf(contentType.getFileExtensions(), fileExtension) < 0) continue;
                types.add(contentType);
            }
        }
        return types.toArray(new IContentType[types.size()]);
    }

    public IContentType[] getAllContentTypes() {
        ArrayList<ContentType> result = new ArrayList<ContentType>(this.catalog.size());
        Iterator i = this.catalog.values().iterator();
        while (i.hasNext()) {
            ContentType type = (ContentType)i.next();
            if (!type.isValid()) continue;
            result.add(type);
        }
        return result.toArray(new IContentType[result.size()]);
    }

    public IContentType getContentType(String contentTypeIdentifier) {
        ContentType type = (ContentType)this.catalog.get(contentTypeIdentifier);
        return type != null && type.isValid() ? type : null;
    }

    public IContentDescription getDescriptionFor(InputStream contents, IContentType[] subset, int optionsMask) throws IOException {
        ByteArrayInputStream buffer = this.readBuffer(contents);
        if (buffer == null) {
            return null;
        }
        IContentType selected = this.findContentTypeFor(contents, subset);
        if (selected == null) {
            return null;
        }
        ContentDescription description = new ContentDescription();
        description.setContentType(selected);
        IContentDescriber selectedDescriber = ((ContentType)selected).getDescriber();
        if (selectedDescriber != null && (selectedDescriber.getSupportedOptions() & optionsMask) == optionsMask) {
            this.describe(selectedDescriber, buffer, description, optionsMask);
        }
        if ((optionsMask & 1) != 0 && description.getCharset() == null) {
            description.setCharset(selected.getDefaultCharset());
        }
        description.markAsImmutable();
        return description;
    }

    private int describe(IContentDescriber selectedDescriber, ByteArrayInputStream contents, ContentDescription description, int optionsMask) throws IOException {
        try {
            int n = selectedDescriber.describe(contents, description, optionsMask);
            Object var5_6 = null;
            contents.reset();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            contents.reset();
            throw throwable;
        }
    }

    private int indexOf(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isBaseTypeOf(IContentType base, IContentType target) {
        IContentType targetBase = target.getBaseType();
        if (targetBase == null) {
            return false;
        }
        return targetBase == base ? true : this.isBaseTypeOf(base, targetBase);
    }

    private int moreAppropriate(IContentType type1, IContentType type2) {
        return this.isBaseTypeOf(type1, type2) ? -1 : (this.isBaseTypeOf(type2, type1) ? 1 : 0);
    }

    private IContentType mostAppropriate(List candidates) {
        int candidatesCount = candidates.size();
        if (candidatesCount == 0) {
            return null;
        }
        IContentType chosen = (IContentType)candidates.remove(candidatesCount - 1);
        if (candidatesCount == 1) {
            return chosen;
        }
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            IContentType current = (IContentType)i.next();
            i.remove();
            switch (this.moreAppropriate(current, chosen)) {
                case -1: {
                    break;
                }
                case 1: {
                    chosen = current;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return chosen;
    }

    private String[] parseItems(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        if (!tokenizer.hasMoreTokens()) {
            return new String[0];
        }
        String first = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return new String[]{first};
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(first);
        do {
            items.add(tokenizer.nextToken());
        } while (tokenizer.hasMoreTokens());
        return items.toArray(new String[items.size()]);
    }

    protected void registerContentType(IConfigurationElement contentTypeCE) {
        ContentType contentType = new ContentType(this, contentTypeCE);
        contentType.setSimpleId(contentTypeCE.getAttributeAsIs("id"));
        contentType.setNamespace(contentTypeCE.getDeclaringExtension().getNamespace());
        contentType.setName(contentTypeCE.getAttribute("name"));
        contentType.setFileExtensions(this.parseItems(contentTypeCE.getAttributeAsIs("file-extensions")));
        contentType.setFileNames(this.parseItems(contentTypeCE.getAttributeAsIs("file-names")));
        contentType.setBaseTypeId(contentTypeCE.getAttributeAsIs("base-type"));
        contentType.setDefaultCharset(contentTypeCE.getAttributeAsIs("default-charset"));
        contentType.setDescriberClass(contentTypeCE.getAttributeAsIs("describer-class") != null);
        this.catalog.put(contentType.getId(), contentType);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.core.runtime", PT_CONTENTTYPES);
        int i = 0;
        while (i < deltas.length) {
            IConfigurationElement[] configElements = deltas[i].getExtension().getConfigurationElements();
            if (deltas[i].getKind() == 1) {
                int j = 0;
                while (j < configElements.length) {
                    this.registerContentType(configElements[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.validateContentTypes();
    }

    protected void startup() {
        IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
        InternalPlatform.getDefault().getRegistry().addRegistryChangeListener(this, "org.eclipse.core.runtime");
        this.catalog = new HashMap();
        IExtensionPoint contentTypesXP = registry.getExtensionPoint("org.eclipse.core.runtime", PT_CONTENTTYPES);
        IConfigurationElement[] allContentTypeCEs = contentTypesXP.getConfigurationElements();
        int j = 0;
        while (j < allContentTypeCEs.length) {
            this.registerContentType(allContentTypeCEs[j]);
            ++j;
        }
        this.validateContentTypes();
    }

    protected void validateContentTypes() {
        Iterator i = this.catalog.values().iterator();
        while (i.hasNext()) {
            ((ContentType)i.next()).setValidation((byte)3);
        }
        i = this.catalog.values().iterator();
        while (i.hasNext()) {
            this.ensureValid((ContentType)i.next());
        }
    }
}

