/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class InternalJob
extends PlatformObject
implements Comparable {
    public static final int BLOCKED = 8;
    public static final int ABOUT_TO_RUN = 16;
    protected static final long T_INFINITE = Long.MAX_VALUE;
    protected static final long T_NONE = -1L;
    private static final int M_STATE = 255;
    private static final int M_SYSTEM = 256;
    private static final JobManager manager = JobManager.getInstance();
    private static int nextJobNumber = 0;
    private volatile int flags = 0;
    private final int jobNumber = nextJobNumber++;
    private List listeners;
    private IProgressMonitor monitor;
    private String name;
    private InternalJob next;
    private InternalJob previous;
    private int priority = 30;
    private IStatus result;
    private ISchedulingRule schedulingRule;
    private long startTime;
    private Thread thread = null;
    static /* synthetic */ Class class$0;

    protected InternalJob(String name) {
        Assert.isNotNull(name);
        this.name = name;
    }

    protected void addJobChangeListener(IJobChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList(2));
        }
        this.listeners.add(listener);
    }

    final void addLast(InternalJob entry) {
        if (this.previous == null) {
            this.previous = entry;
            entry.next = this;
            entry.previous = null;
        } else {
            Assert.isTrue(this.previous.next() == this);
            this.previous.addLast(entry);
        }
    }

    protected boolean belongsTo(Object family) {
        return false;
    }

    protected boolean cancel() {
        return manager.cancel(this);
    }

    public final int compareTo(Object otherJob) {
        return (int)(((InternalJob)otherJob).startTime - this.startTime);
    }

    protected void done(IStatus result) {
        manager.endJob(this, result, true);
    }

    final List getListeners() {
        return this.listeners;
    }

    protected String getName() {
        return this.name;
    }

    protected int getPriority() {
        return this.priority;
    }

    final IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected IStatus getResult() {
        return this.result;
    }

    protected ISchedulingRule getRule() {
        return this.schedulingRule;
    }

    final long getStartTime() {
        return this.startTime;
    }

    protected int getState() {
        int state = this.flags & 0xFF;
        switch (state) {
            case 8: {
                return 2;
            }
            case 16: {
                return 4;
            }
        }
        return state;
    }

    protected Thread getThread() {
        return this.thread;
    }

    final int internalGetState() {
        return this.flags & 0xFF;
    }

    final void internalSetPriority(int newPriority) {
        this.priority = newPriority;
    }

    final void internalSetRule(ISchedulingRule rule) {
        this.schedulingRule = rule;
    }

    final void internalSetState(int i) {
        this.flags = this.flags & 0xFFFFFF00 | i;
    }

    final boolean isConflicting(InternalJob otherJob) {
        ISchedulingRule otherRule = otherJob.getRule();
        if (this.schedulingRule == null || otherRule == null) {
            return false;
        }
        Class<?> clazz = this.schedulingRule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.jobs.MultiRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.schedulingRule.isConflicting(otherRule);
        }
        return otherRule.isConflicting(this.schedulingRule);
    }

    protected boolean isSystem() {
        return (this.flags & 0x100) != 0;
    }

    protected void join() throws InterruptedException {
        manager.join(this);
    }

    final InternalJob next() {
        return this.next;
    }

    final InternalJob previous() {
        return this.previous;
    }

    final InternalJob remove() {
        if (this.next != null) {
            this.next.setPrevious(this.previous);
        }
        if (this.previous != null) {
            this.previous.setNext(this.next);
        }
        this.previous = null;
        this.next = null;
        return this;
    }

    protected void removeJobChangeListener(IJobChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected void schedule(long delay) {
        manager.schedule(this, delay);
    }

    protected void setName(String name) {
        Assert.isNotNull(name);
        this.name = name;
    }

    final void setNext(InternalJob entry) {
        this.next = entry;
    }

    final void setPrevious(InternalJob entry) {
        this.previous = entry;
    }

    protected void setPriority(int newPriority) {
        switch (newPriority) {
            case 10: 
            case 20: 
            case 30: 
            case 40: 
            case 50: {
                manager.setPriority(this, newPriority);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(newPriority));
            }
        }
    }

    protected void setProgressGroup(IProgressMonitor group, int ticks) {
        Assert.isNotNull(group);
        IProgressMonitor result = manager.createMonitor(this, group, ticks);
        if (result != null) {
            this.setProgressMonitor(result);
        }
    }

    final void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    final void setResult(IStatus result) {
        this.result = result;
    }

    protected void setRule(ISchedulingRule rule) {
        manager.setRule(this, rule);
    }

    final void setStartTime(long time) {
        this.startTime = time;
    }

    protected void setSystem(boolean value) {
        this.flags = value ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    protected void setThread(Thread thread) {
        this.thread = thread;
    }

    protected boolean shouldSchedule() {
        return true;
    }

    protected boolean sleep() {
        return manager.sleep(this);
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.jobNumber + ")";
    }

    protected void wakeUp(long delay) {
        manager.wakeUp(this, delay);
    }
}

