/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.LookupOrder;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    public static final String PT_PREFERENCES = "preferences";
    private static final String[] DEFAULT_DEFAULT_LOOKUP_ORDER = new String[]{"project", "instance", "configuration", "default"};
    private static IPreferencesService instance = null;
    private static Map defaultsRegistry = new HashMap();
    private static Map scopeRegistry = new HashMap();
    private static RootPreferences root = new RootPreferences();
    private static IStatus statusOK;
    private static final String VERSION_KEY = "file_export_version";
    private static final char EXPORT_ROOT_PREFIX = '!';
    private static final float EXPORT_VERSION = 3.0f;

    private PreferencesService() {
        PreferencesService.initializeScopes();
    }

    public static IPreferencesService getDefault() {
        if (instance == null) {
            instance = new PreferencesService();
        }
        return instance;
    }

    private static void scopeAdded(IConfigurationElement element) {
        String key = element.getAttribute("scope");
        if (key == null) {
            String message = Policy.bind("preferences.missingScopeAttribute", element.getDeclaringExtension().getUniqueIdentifier());
            PreferencesService.log(PreferencesService.createStatusWarning(message, null));
            return;
        }
        scopeRegistry.put(key, element);
        root.addChild(key);
    }

    protected IEclipsePreferences createNode(String name) {
        IScope scope = null;
        Object value = scopeRegistry.get(name);
        if (value instanceof IConfigurationElement) {
            try {
                scope = (IScope)((IConfigurationElement)value).createExecutableExtension("class");
                scopeRegistry.put(name, scope);
            }
            catch (ClassCastException e) {
                String message = Policy.bind("preferences.classCast");
                PreferencesService.log(PreferencesService.createStatusError(message, e));
                return new EclipsePreferences(root, name);
            }
            catch (CoreException e) {
                PreferencesService.log(e.getStatus());
                return new EclipsePreferences(root, name);
            }
        } else {
            scope = (IScope)value;
        }
        return scope.create(root, name);
    }

    private static void scopeRemoved(String key) throws BackingStoreException {
        IEclipsePreferences node = (IEclipsePreferences)root.node(key);
        node.removeNode();
        root.removeNode(node);
        scopeRegistry.remove(key);
    }

    private static void initializeScopes() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.runtime", PT_PREFERENCES);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (PT_PREFERENCES.equalsIgnoreCase(elements[j].getName())) {
                    PreferencesService.scopeAdded(elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void log(IStatus status) {
        InternalPlatform.getDefault().log(status);
    }

    public String get(String key, String defaultValue, Preferences[] nodes) {
        if (nodes == null) {
            return defaultValue;
        }
        int i = 0;
        while (i < nodes.length) {
            String result;
            Preferences node = nodes[i];
            if (node != null && (result = node.get(key, null)) != null) {
                return result;
            }
            ++i;
        }
        return defaultValue;
    }

    public boolean getBoolean(String qualifier, String key, boolean defaultValue, IScopeContext[] scopes) {
        String result = this.get(key, null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : Boolean.getBoolean(result);
    }

    public byte[] getByteArray(String qualifier, String key, byte[] defaultValue, IScopeContext[] scopes) {
        String result = this.get(key, null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : result.getBytes();
    }

    public String[] getDefaultLookupOrder(String qualifier, String key) {
        LookupOrder order = (LookupOrder)defaultsRegistry.get(this.getRegistryKey(qualifier, key));
        return order == null ? null : order.getOrder();
    }

    public void setDefaultLookupOrder(String qualifier, String key, String[] order) {
        String registryKey = this.getRegistryKey(qualifier, key);
        if (order == null) {
            defaultsRegistry.remove(registryKey);
        } else {
            LookupOrder obj = new LookupOrder(qualifier, key, order);
            defaultsRegistry.put(registryKey, obj);
        }
    }

    private String getRegistryKey(String qualifier, String key) {
        if (qualifier == null) {
            return key;
        }
        if (key == null) {
            return qualifier;
        }
        return String.valueOf(qualifier) + '/' + key;
    }

    public double getDouble(String qualifier, String key, double defaultValue, IScopeContext[] scopes) {
        String value = this.get(key, null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public float getFloat(String qualifier, String key, float defaultValue, IScopeContext[] scopes) {
        String value = this.get(key, null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public int getInt(String qualifier, String key, int defaultValue, IScopeContext[] scopes) {
        String value = this.get(key, null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public long getLong(String qualifier, String key, long defaultValue, IScopeContext[] scopes) {
        String value = this.get(key, null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String[] getLookupOrder(String qualifier, String key) {
        String[] order = this.getDefaultLookupOrder(qualifier, key);
        if (order == null && key != null) {
            order = this.getDefaultLookupOrder(qualifier, null);
        }
        if (order == null) {
            order = DEFAULT_DEFAULT_LOOKUP_ORDER;
        }
        return order;
    }

    private Preferences[] getNodes(String qualifier, String key, IScopeContext[] contexts) {
        String[] order = this.getLookupOrder(qualifier, key);
        ArrayList<Preferences> result = new ArrayList<Preferences>();
        int i = 0;
        while (i < order.length) {
            String scopeString = order[i];
            boolean found = false;
            int j = 0;
            while (contexts != null && j < contexts.length) {
                IEclipsePreferences node;
                IScopeContext context = contexts[j];
                if (context != null && context.getName().equals(scopeString) && (node = context.getNode(qualifier)) != null) {
                    found = true;
                    result.add(node);
                }
                ++j;
            }
            if (!found) {
                result.add(this.getRootNode().node(scopeString).node(qualifier));
            }
            found = false;
            ++i;
        }
        return result.toArray(new Preferences[result.size()]);
    }

    public IEclipsePreferences getRootNode() {
        return root;
    }

    public String getString(String qualifier, String key, String defaultValue, IScopeContext[] scopes) {
        return this.get(key, defaultValue, this.getNodes(qualifier, key, scopes));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IExportedPreferences readPreferences(InputStream input) throws CoreException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Reading preferences from stream...");
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                String message = Policy.bind("preferences.importProblems");
                throw new CoreException(PreferencesService.createStatusError(message, e));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        input.close();
        if (this.isLegacy(properties)) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
            return this.convertFromProperties(properties);
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Read preferences file.");
        }
        properties.remove(VERSION_KEY);
        return this.convertFromProperties(properties);
    }

    private IExportedPreferences convertFromProperties(Properties properties) {
        ExportedPreferences result = new ExportedPreferences(null, "");
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String pathString = (String)i.next();
            if (pathString.charAt(0) == '!') {
                pathString = pathString.substring(1, pathString.length());
                ExportedPreferences current = (ExportedPreferences)result.node(pathString);
                current.setExportRoot();
                continue;
            }
            Path path = new Path(pathString);
            IExportedPreferences current = (IExportedPreferences)result.node(path.removeLastSegments(1));
            String key = path.lastSegment();
            String value = properties.getProperty(pathString);
            current.put(key, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Converted preferences file to IExportedPreferences tree:");
            System.out.println(result.toDeepDebugString());
        }
        return result;
    }

    public IStatus importPreferences(InputStream input) throws CoreException {
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Importing preferences...");
        }
        return this.applyPreferences(this.readPreferences(input));
    }

    public IStatus applyPreferences(IExportedPreferences preferences) throws CoreException {
        if (preferences == null) {
            throw new IllegalArgumentException();
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Applying exported preferences:");
            System.out.println(((ExportedPreferences)preferences).toDeepDebugString());
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 0, "Problems applying preference changes.", null);
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                IEclipsePreferences globalNode = node.parent() == null ? root : (IEclipsePreferences)root.node(node.absolutePath());
                ExportedPreferences epNode = (ExportedPreferences)node;
                boolean removed = false;
                if (epNode.isExportRoot()) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("Found export root: " + epNode.absolutePath());
                    }
                    globalNode.removeNode();
                    removed = true;
                }
                if (epNode.properties != null && !epNode.properties.isEmpty()) {
                    if (removed) {
                        globalNode = (IEclipsePreferences)root.node(node.absolutePath());
                    }
                    Iterator<Object> i = epNode.properties.keySet().iterator();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        String value = node.get(key = key.intern(), null);
                        if (value == null) continue;
                        if (InternalPlatform.DEBUG_PREFERENCES) {
                            System.out.println("Setting: " + globalNode.absolutePath() + '/' + key + '=' + value);
                        }
                        globalNode.put(key, value);
                    }
                }
                return true;
            }
        };
        try {
            preferences.accept(visitor);
        }
        catch (BackingStoreException e) {
            String message = "Problems applying preferences.";
            throw new CoreException(PreferencesService.createStatusError(message, (Exception)((Object)e)));
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Current list of all settings:");
            System.out.println(((EclipsePreferences)Platform.getPreferencesService().getRootNode()).toDeepDebugString());
        }
        return result;
    }

    public IStatus exportPreferences(IEclipsePreferences node, OutputStream output, String[] excludesList) throws CoreException {
        if (node == null || output == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = null;
        if (excludesList == null) {
            excludesList = new String[]{};
        }
        try {
            properties = this.convertToProperties(node, excludesList);
            properties.put(VERSION_KEY, Float.toString(3.0f));
            properties.put(String.valueOf('!') + node.absolutePath(), "");
        }
        catch (BackingStoreException e) {
            throw new CoreException(PreferencesService.createStatusError(e.getMessage(), (Exception)((Object)e)));
        }
        try {
            properties.store(output, null);
        }
        catch (IOException e) {
            String message = Policy.bind("preferences.exportProblems");
            throw new CoreException(PreferencesService.createStatusError(message, e));
        }
        return PreferencesService.createStatusOK();
    }

    private static IStatus createStatusError(String message, Exception e) {
        return new Status(4, "org.eclipse.core.runtime", 4, message, e);
    }

    private static IStatus createStatusWarning(String message, Exception e) {
        return new Status(2, "org.eclipse.core.runtime", 2, message, e);
    }

    private static IStatus createStatusOK() {
        if (statusOK == null) {
            statusOK = new Status(0, "org.eclipse.core.runtime", 0, "OK", null);
        }
        return statusOK;
    }

    private Properties convertToProperties(IEclipsePreferences preferences, final String[] excludesList) throws BackingStoreException {
        final Properties result = new Properties();
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                String pathString = node.absolutePath();
                Path path = new Path(pathString);
                if (path.segmentCount() > 0 && "default".equals(path.segment(0))) {
                    return false;
                }
                int i = 0;
                while (i < excludesList.length) {
                    if (pathString.startsWith(excludesList[i])) {
                        return false;
                    }
                    ++i;
                }
                String[] keys = node.keys();
                int i2 = 0;
                while (i2 < keys.length) {
                    String value;
                    String key = keys[i2];
                    String fullKeyPath = path.append(key).toString();
                    boolean ignore = false;
                    int j = 0;
                    while (!ignore && j < excludesList.length) {
                        if (fullKeyPath.startsWith(excludesList[j])) {
                            ignore = true;
                        }
                        ++j;
                    }
                    if (!ignore && (value = node.get(key, null)) != null) {
                        result.put(fullKeyPath, value);
                    }
                    ++i2;
                }
                return true;
            }
        };
        preferences.accept(visitor);
        return result;
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty(VERSION_KEY) == null;
    }

    private Properties convertFromLegacy(Properties properties) {
        Properties result = new Properties();
        IPath prefix = new Path("instance").makeAbsolute();
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = properties.getProperty(key);
            if (value == null) continue;
            Path path = new Path(key);
            if (path.segmentCount() == 1) {
                result.put(String.valueOf('!') + prefix.append(key).toString(), "");
                continue;
            }
            result.put(prefix.append(path).toString(), value);
        }
        return result;
    }

    public IScope getScope(Preferences node) {
        Path path = new Path(node.absolutePath());
        if (path.segmentCount() < 1) {
            return null;
        }
        String key = path.segment(0);
        return (IScope)scopeRegistry.get(key);
    }
}

