/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

class AccumulatingProgressMonitor
extends ProgressMonitorWrapper {
    private Display display;
    private Collector collector;

    public AccumulatingProgressMonitor(IProgressMonitor monitor, Display display) {
        super(monitor);
        Assert.isNotNull(display);
        this.display = display;
    }

    public void beginTask(final String name, final int totalWork) {
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.syncExec(new Runnable(){

            public void run() {
                AccumulatingProgressMonitor.this.getWrappedProgressMonitor().beginTask(name, totalWork);
            }
        });
    }

    private synchronized void clearCollector(Collector collector) {
        if (this.collector == collector) {
            this.collector = null;
        }
    }

    private void createCollector(String subTask, double work) {
        this.collector = new Collector(subTask, work, this.getWrappedProgressMonitor());
        this.display.asyncExec((Runnable)this.collector);
    }

    public void done() {
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.syncExec(new Runnable(){

            public void run() {
                AccumulatingProgressMonitor.this.getWrappedProgressMonitor().done();
            }
        });
    }

    public synchronized void internalWorked(double work) {
        if (this.collector == null) {
            this.createCollector(null, work);
        } else {
            this.collector.worked(work);
        }
    }

    public void setTaskName(final String name) {
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.syncExec(new Runnable(){

            public void run() {
                AccumulatingProgressMonitor.this.getWrappedProgressMonitor().setTaskName(name);
            }
        });
    }

    public synchronized void subTask(String name) {
        if (this.collector == null) {
            this.createCollector(name, 0.0);
        } else {
            this.collector.subTask(name);
        }
    }

    public synchronized void worked(int work) {
        this.internalWorked(work);
    }

    public void clearBlocked() {
        final IProgressMonitor pm = this.getWrappedProgressMonitor();
        if (!(pm instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                ((IProgressMonitorWithBlocking)pm).clearBlocked();
            }
        });
    }

    public void setBlocked(final IStatus reason) {
        final IProgressMonitor pm = this.getWrappedProgressMonitor();
        if (!(pm instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                ((IProgressMonitorWithBlocking)pm).setBlocked(reason);
            }
        });
    }

    private class Collector
    implements Runnable {
        private String subTask;
        private double worked;
        private IProgressMonitor monitor;

        public Collector(String subTask, double work, IProgressMonitor monitor) {
            this.subTask = subTask;
            this.worked = work;
            this.monitor = monitor;
        }

        public void worked(double worked) {
            this.worked += worked;
        }

        public void subTask(String subTask) {
            this.subTask = subTask;
        }

        public void run() {
            AccumulatingProgressMonitor.this.clearCollector(this);
            if (this.subTask != null) {
                this.monitor.subTask(this.subTask);
            }
            if (this.worked > 0.0) {
                this.monitor.internalWorked(this.worked);
            }
        }
    }
}

