/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import demo.swingset.ButtonDemo;
import demo.swingset.DemoModule;
import demo.swingset.DirectionPanel;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.LayoutManager;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.ItemEvent;
import swingwt.awt.event.ItemListener;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.Box;
import swingwtx.swing.BoxLayout;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JRadioButton;
import swingwtx.swing.SwingConstants;

public class LayoutControlPanel
extends JPanel
implements SwingConstants {
    private boolean absolutePositions;
    private DirectionPanel textPosition = null;
    private DirectionPanel labelAlignment = null;
    private ButtonDemo demo = null;

    LayoutControlPanel(ButtonDemo buttonDemo) {
        this.demo = buttonDemo;
        this.setLayout((LayoutManager)new BoxLayout((Container)this, 1));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.absolutePositions = true;
        this.textPosition = new DirectionPanel(true, "E", new TextPositionListener());
        this.labelAlignment = new DirectionPanel(true, "C", new LabelAlignmentListener());
        for (int i = 0; i < buttonDemo.getCurrentControls().size(); ++i) {
            Component component = (Component)buttonDemo.getCurrentControls().elementAt(i);
            this.setPosition(component, 4, 0);
            this.setAlignment(component, 0, 0);
        }
        JLabel jLabel = new JLabel("Text Position:");
        this.add((Component)jLabel);
        this.add((Component)this.textPosition);
        this.add(Box.createRigidArea((Dimension)DemoModule.VGAP20));
        jLabel = new JLabel("Content Alignment:");
        this.add((Component)jLabel);
        this.add((Component)this.labelAlignment);
        this.add(Box.createGlue());
    }

    void setPosition(Component component, int n, int n2) {
        boolean bl = true;
        bl = component.getComponentOrientation().isLeftToRight();
        if (this.absolutePositions) {
            if (n == 10) {
                n = bl ? 2 : 4;
            } else if (n == 11) {
                n = bl ? 4 : 2;
            }
        } else if (n == 2) {
            n = bl ? 10 : 11;
        } else if (n == 4) {
            int n3 = n = bl ? 11 : 10;
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setHorizontalTextPosition(n);
            abstractButton.setVerticalTextPosition(n2);
        } else if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalTextPosition(n);
            jLabel.setVerticalTextPosition(n2);
        }
    }

    void setAlignment(Component component, int n, int n2) {
        boolean bl = true;
        bl = component.getComponentOrientation().isLeftToRight();
        if (this.absolutePositions) {
            if (n == 10) {
                n = bl ? 2 : 4;
            } else if (n == 11) {
                n = bl ? 4 : 2;
            }
        } else if (n == 2) {
            n = bl ? 10 : 11;
        } else if (n == 4) {
            int n3 = n = bl ? 11 : 10;
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setHorizontalAlignment(n);
            abstractButton.setVerticalAlignment(n2);
        } else if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalAlignment(n);
            jLabel.setVerticalAlignment(n2);
        }
    }

    class LabelAlignmentListener
    implements ActionListener {
        LabelAlignmentListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (!jRadioButton.isSelected()) {
                return;
            }
            String string = jRadioButton.getActionCommand();
            if (string.equals("NW")) {
                n2 = 2;
                n = 1;
            } else if (string.equals("N")) {
                n2 = 0;
                n = 1;
            } else if (string.equals("NE")) {
                n2 = 4;
                n = 1;
            } else if (string.equals("W")) {
                n2 = 2;
                n = 0;
            } else if (string.equals("C")) {
                n2 = 0;
                n = 0;
            } else if (string.equals("E")) {
                n2 = 4;
                n = 0;
            } else if (string.equals("SW")) {
                n2 = 2;
                n = 3;
            } else if (string.equals("S")) {
                n2 = 0;
                n = 3;
            } else {
                n2 = 4;
                n = 3;
            }
            for (int i = 0; i < LayoutControlPanel.this.demo.getCurrentControls().size(); ++i) {
                Component component = (Component)LayoutControlPanel.this.demo.getCurrentControls().elementAt(i);
                LayoutControlPanel.this.setAlignment(component, n2, n);
                component.invalidate();
            }
            LayoutControlPanel.this.demo.invalidate();
            LayoutControlPanel.this.demo.validate();
            LayoutControlPanel.this.demo.repaint();
        }
    }

    class TextPositionListener
    implements ActionListener {
        TextPositionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (!jRadioButton.isSelected()) {
                return;
            }
            String string = jRadioButton.getActionCommand();
            if (string.equals("NW")) {
                n2 = 2;
                n = 1;
            } else if (string.equals("N")) {
                n2 = 0;
                n = 1;
            } else if (string.equals("NE")) {
                n2 = 4;
                n = 1;
            } else if (string.equals("W")) {
                n2 = 2;
                n = 0;
            } else if (string.equals("C")) {
                n2 = 0;
                n = 0;
            } else if (string.equals("E")) {
                n2 = 4;
                n = 0;
            } else if (string.equals("SW")) {
                n2 = 2;
                n = 3;
            } else if (string.equals("S")) {
                n2 = 0;
                n = 3;
            } else {
                n2 = 4;
                n = 3;
            }
            for (int i = 0; i < LayoutControlPanel.this.demo.getCurrentControls().size(); ++i) {
                Component component = (Component)LayoutControlPanel.this.demo.getCurrentControls().elementAt(i);
                LayoutControlPanel.this.setPosition(component, n2, n);
            }
            LayoutControlPanel.this.demo.invalidate();
            LayoutControlPanel.this.demo.validate();
            LayoutControlPanel.this.demo.repaint();
        }
    }

    class PositioningListener
    implements ItemListener {
        PositioningListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (jRadioButton.getText().equals("Absolute") && jRadioButton.isSelected()) {
                LayoutControlPanel.this.absolutePositions = true;
            } else if (jRadioButton.getText().equals("Relative") && jRadioButton.isSelected()) {
                LayoutControlPanel.this.absolutePositions = false;
            }
            for (int i = 0; i < LayoutControlPanel.this.demo.getCurrentControls().size(); ++i) {
                int n;
                int n2;
                int n3;
                int n4;
                Component component = (Component)LayoutControlPanel.this.demo.getCurrentControls().elementAt(i);
                if (component instanceof AbstractButton) {
                    n4 = ((AbstractButton)component).getHorizontalTextPosition();
                    n3 = ((AbstractButton)component).getVerticalTextPosition();
                    n2 = ((AbstractButton)component).getHorizontalAlignment();
                    n = ((AbstractButton)component).getVerticalAlignment();
                } else {
                    if (!(component instanceof JLabel)) continue;
                    n4 = ((JLabel)component).getHorizontalTextPosition();
                    n3 = ((JLabel)component).getVerticalTextPosition();
                    n2 = ((JLabel)component).getHorizontalAlignment();
                    n = ((JLabel)component).getVerticalAlignment();
                }
                LayoutControlPanel.this.setPosition(component, n4, n3);
                LayoutControlPanel.this.setAlignment(component, n2, n);
            }
            LayoutControlPanel.this.demo.invalidate();
            LayoutControlPanel.this.demo.validate();
            LayoutControlPanel.this.demo.repaint();
        }
    }

    class OrientationChangeListener
    implements ActionListener {
        OrientationChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("OrientationChanged")) {
                return;
            }
            if (LayoutControlPanel.this.absolutePositions) {
                return;
            }
            String string = LayoutControlPanel.this.textPosition.getSelection();
            if (string.equals("NW")) {
                LayoutControlPanel.this.textPosition.setSelection("NE");
            } else if (string.equals("NE")) {
                LayoutControlPanel.this.textPosition.setSelection("NW");
            } else if (string.equals("E")) {
                LayoutControlPanel.this.textPosition.setSelection("W");
            } else if (string.equals("W")) {
                LayoutControlPanel.this.textPosition.setSelection("E");
            } else if (string.equals("SE")) {
                LayoutControlPanel.this.textPosition.setSelection("SW");
            } else if (string.equals("SW")) {
                LayoutControlPanel.this.textPosition.setSelection("SE");
            }
            String string2 = LayoutControlPanel.this.labelAlignment.getSelection();
            if (string2.equals("NW")) {
                LayoutControlPanel.this.labelAlignment.setSelection("NE");
            } else if (string2.equals("NE")) {
                LayoutControlPanel.this.labelAlignment.setSelection("NW");
            } else if (string2.equals("E")) {
                LayoutControlPanel.this.labelAlignment.setSelection("W");
            } else if (string2.equals("W")) {
                LayoutControlPanel.this.labelAlignment.setSelection("E");
            } else if (string2.equals("SE")) {
                LayoutControlPanel.this.labelAlignment.setSelection("SW");
            } else if (string2.equals("SW")) {
                LayoutControlPanel.this.labelAlignment.setSelection("SE");
            }
        }
    }
}

