/*
 * SwingWT browser demo. 
 *
 * @author R. Rawson-Tetley
 *
 * $Log: SwingWTBrowser.java,v $
 * Revision 1.5  2004/06/23 07:34:16  bobintetley
 * MacOSX users are now first class citizens and SwingWT now works properly
 *
 * Revision 1.4  2003/12/14 08:47:37  bobintetley
 * Added useful comments and CVS log header
 *
 */

package demo;

import swingwtx.swing.*;
import swingwtx.swing.event.*;
import swingwt.awt.*;
import swingwt.awt.event.*;

import java.net.*;
import java.io.*;

/** 
 *  Very simplistic "Web browser" using SwingWT. Supply a URL on the 
 *  command line to see it initially, and to set the destination
 *  of the "home" button.
 */

public class SwingWTBrowser extends JFrame implements HyperlinkListener, ActionListener {
  public static void main(String[] args) {
       if (SwingWTUtils.isMacOSX()) {
	    SwingWTUtils.initialiseMacOSX(new Runnable() {
		public void run() {
                    new SwingWTBrowser();
		}
	    });
	}
	else {
	   if (args.length == 0)
              new SwingWTBrowser();
           else
              new SwingWTBrowser(args[0]);
	}
  }

  private JButton homeButton;
  private JTextField urlField;
  private JEditorPane htmlPane;
  private String initialURL;

  public SwingWTBrowser() { this(""); }
  
  public SwingWTBrowser(String initialURL) {
    super("Simple SwingWT Browser");
    this.initialURL = initialURL;

    JPanel topPanel = new JPanel();
    topPanel.setLayout(new BorderLayout());
    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new FlowLayout());
    topPanel.add(buttonPanel, BorderLayout.WEST);
    
    homeButton = new JButton();
    homeButton.setIcon(new ImageIcon(getClass().getResource("/demo/Homepage.png")));
    homeButton.addActionListener(this);
    urlField = new JTextField(100);
    urlField.setText(initialURL);
    topPanel.add(urlField, BorderLayout.CENTER);
    
    urlField.addKeyListener(new KeyListener() {
        public void keyPressed(KeyEvent k) {
           if (k.getKeyCode() == KeyEvent.VK_ENTER) {
                String url = urlField.getText();
                try {
                  htmlPane.setPage(new URL(url));
                  urlField.setText(url);
                } catch(IOException ioe) {
                  warnUser("Can't follow link to " + url + ": " + ioe);
                }    
            }
        }
        public void keyReleased(KeyEvent k) {}
        public void keyTyped(KeyEvent k) {
        }
    });
    
    buttonPanel.add(homeButton);
    
    getContentPane().add(topPanel, BorderLayout.NORTH);

    String sample = "<html><body><h2>Test HTML</h2><p>This is a simple browser test. Type in a URL at the top to go to a new location, or hit the home button to go back to the URL you supplied.</p></body></html>";
    
    try {
        if (initialURL.equals(""))
            htmlPane = new JEditorPane("text/html", sample);
        else
            htmlPane = new JEditorPane(initialURL);
        htmlPane.setEditable(false);
        htmlPane.addHyperlinkListener(this);
        JScrollPane scrollPane = new JScrollPane(htmlPane);
        getContentPane().add(scrollPane, BorderLayout.CENTER);
    } catch(IOException ioe) {
       warnUser("Can't build HTML pane for " + initialURL 
                + ": " + ioe);
    }

    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    int width = screenSize.width * 8 / 10;
    int height = screenSize.height * 8 / 10;
    setBounds(width/8, height/8, width, height);
    setVisible(true);
    
  }

  public void actionPerformed(ActionEvent event) {
    String url = initialURL;
    if (url.equals("")) {
        warnUser("You didn't supply an initial home URL!");
        return;
    }
    try {
      htmlPane.setPage(new URL(url));
      urlField.setText(url);
    } catch(IOException ioe) {
      warnUser("Can't follow link to " + url + ": " + ioe);
    }
  }

  public void hyperlinkUpdate(HyperlinkEvent event) {
    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
      try {
        htmlPane.setPage(event.getURL());
        urlField.setText(event.getURL().toExternalForm());
      } catch(IOException ioe) {
        warnUser("Can't follow link to " 
                 + event.getURL().toExternalForm() + ": " + ioe);
      }
    }
  }

  private void warnUser(String message) {
    JOptionPane.showMessageDialog(this, message, "Error", 
                                  JOptionPane.ERROR_MESSAGE);
  }
}
    
    
