/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: MouseEvent.java,v $
   Revision 1.14  2004/06/11 03:29:28  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.13  2004/05/27 14:05:38  bobintetley
   Fixed MouseEvent to use bitwise tests

   Revision 1.12  2004/05/27 03:05:00  dannaab
   Add a couple methods from Component.java to Window.java so the Shell peer is used instead of the generic composite peer

   Revision 1.11  2004/05/06 12:35:21  bobintetley
   Parity with Swing constants for Binary Compatibility + fixes to JDesktopPane

   Revision 1.10  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.9  2004/04/23 10:02:49  bobintetley
   MouseEvent BUTTON_MASK constants, JSlider.createStandardLabels(), FontMetrics
   thread safety, Component/Toolkit.getFontMetrics() and MouseMotionAdapter

   Revision 1.8  2004/04/16 10:19:06  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.7  2004/01/26 14:05:23  bobintetley
   Compatibility methods

   Revision 1.6  2003/12/17 10:57:35  bobintetley
   JTableHeader implementation plus Table event/model fixes

   Revision 1.5  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwt.awt.event;

import swingwt.awt.*;

public class MouseEvent extends InputEvent implements java.io.Serializable {
    
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int BUTTON1_MASK = BUTTON1;
    public static final int BUTTON2_MASK = BUTTON2;
    public static final int BUTTON3_MASK = BUTTON3;
    
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = MOUSE_FIRST;
    public static final int MOUSE_PRESSED = 1 + MOUSE_FIRST; 
    public static final int MOUSE_RELEASED = 2 + MOUSE_FIRST;
    public static final int MOUSE_MOVED = 3 + MOUSE_FIRST;
    public static final int MOUSE_ENTERED = 4 + MOUSE_FIRST; 
    public static final int MOUSE_EXITED = 5 + MOUSE_FIRST; 
    public static final int MOUSE_DRAGGED = 6 + MOUSE_FIRST; 
    public static final int MOUSE_WHEEL = 7 + MOUSE_FIRST; 
    
    public int clickCount = 1;
    public int eventID = 0;
    private int button = 0;
    private int x = 0;
    private int y = 0;
    private boolean popupTrigger = false;

    public static final int CLICKED = 0;
    public static final int ENTERED = 1;
    public static final int EXITED = 2;
    public static final int PRESSED = 3;
    public static final int RELEASED = 4;

    public MouseEvent( Component source, int id, long when, int modifiers,
                int x, int y, int clickCount, boolean popupTrigger ) {
        this(source, id, when, modifiers, x, y, clickCount, popupTrigger, NOBUTTON);
    }

    public MouseEvent( Component source, int id, long when, int modifiers, int x, int y,
                int clickCount, boolean popupTrigger, int button) {
        super(source, id, when, modifiers);

        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.popupTrigger = popupTrigger;
        this.button = button;
    }

    public MouseEvent(Component source) {
        super(source);
    }

    /**
     * If this mouse event should trigger a popup I guess.
     * I never used this, but I've just set it to respond
     * to whether it's a right click for convenience
     */
    public boolean isPopupTrigger() {
        return button == 3;
    }

    public int getModifiers() {
        // We don't have keyboard modifiers for mice (unlike AWT)
        return 0;    
    }
    
    /** Returns the number of mouse clicks associated with this event */
    public int getClickCount() {
        return clickCount;    
    }
    
    /** Getter for property button.
     * @return Value of property button.
     *
     */
    public int getButton() {
        return button;
    }
    
    /** Setter for property button.
     * @param button New value of property button.
     *
     */
    public void setButton(int button) {
        this.button = button;
    }
    
    /** Getter for property x.
     * @return Value of property x.
     *
     */
    public int getX() {
        return x;
    }
    
    /** Setter for property x.
     * @param x New value of property x.
     *
     */
    public void setX(int x) {
        this.x = x;
    }
    
    /** Getter for property y.
     * @return Value of property y.
     *
     */
    public int getY() {
        return y;
    }
    
    /** Setter for property y.
     * @param y New value of property y.
     *
     */
    public void setY(int y) {
        this.y = y;
    }

    public Point getPoint() {
        return new Point(x, y);
    }

    public void translatePoint(int x, int y) {
        this.x += x;
        this.y += y;
    }
    
    public int translateSWTButton(int swtButton) {
        int ret = NOBUTTON;
        if (( swtButton & org.eclipse.swt.SWT.BUTTON1 ) > 0) ret = ret | BUTTON1;
        if (( swtButton & org.eclipse.swt.SWT.BUTTON2 ) > 0) ret = ret | BUTTON2;
        if (( swtButton & org.eclipse.swt.SWT.BUTTON3 ) > 0) ret = ret | BUTTON3;
        return ret;
    }
}
