/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

*/


package swingwtx.swing;

import swingwt.awt.Color;
import swingwtx.swing.text.*;
import swingwtx.swing.editorpanes.*;

import java.net.*;
import java.io.*;

public class JEditorPane extends swingwtx.swing.text.JTextComponent {

    /** The EditorPane implementation we are using */
    protected EditorPane editorPaneImpl = null;
    
    public JEditorPane() { 
    	loadBrowserEditorPane(); 
    }
    
    public JEditorPane(String url) throws IOException { 
        loadBrowserEditorPane(); 
        setPage(url);
    }
    
    public JEditorPane(String type, String text) { 
        if (type.equalsIgnoreCase("text/html"))
            loadBrowserEditorPane();
        else
            loadTextEditorPane();
        setText(text);
    }
    
    public JEditorPane(URL url)  throws IOException { 
        loadBrowserEditorPane();
        setPage(url); 
    }
    
    private void loadTextEditorPane() {
        loadEditor("swingwtx.swing.editorpanes.TextEditorPane");
    }
    private void loadBrowserEditorPane() {
        if (!loadEditor("swingwtx.swing.editorpanes.PlatformBrowserEditorPane"))
            loadEditor("swingwtx.swing.editorpanes.FakeBrowserEditorPane");
    }
    /**
     * Uses reflection to load an implementation of the class. Returns false if it
     * failed for some reason. This allows us to remove implementation classes
     * (for example, to get rid of the dependency on Mozilla for GTK2 users/builds
     */
    private boolean loadEditor(String clazz) {
        try {
            Class c = Class.forName(clazz);
            editorPaneImpl = (EditorPane) c.getConstructors()[0].newInstance(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
    
    /** Overriden to calculate non-realised
     *  preferred size.
     */
    protected swingwt.awt.Dimension calculatePreferredSize() {
        // Default 300x200
        swingwt.awt.Dimension size = new swingwt.awt.Dimension(300, 200);
        setSize(size);
        return size;
    }
    
    /**
     * Once a parent component receives an "add" call for a child, this being
     * the child, this should be called to tell us to instantiate the peer
     * and load in any cached properties.
     */
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
        editorPaneImpl.setSwingWTParent(parent);
        peer = editorPaneImpl.getSWTPeer();
    }

    public String getText() { return editorPaneImpl.getText(); }
    public void setText(String text) { editorPaneImpl.setText(text); }
    public String getContentType() { return editorPaneImpl.getContentType(); }
    public void setContentType(String contentType) { editorPaneImpl.setContentType(contentType); }
    public boolean isEditable() { return editorPaneImpl.isEditable(); }
    public void setEditable(boolean b) { editorPaneImpl.setEditable(b); }
    public void setDocument(Document newdoc) { editorPaneImpl.setDocument(newdoc); }
    public Document getDocument() { return editorPaneImpl.getDocument(); }
    public void setPage(URL url) throws IOException {
        // If we haven't created a peer yet, force us to use a browser, since
        // setPage is really aimed at HTML.
        if (!SwingWTUtils.isSWTControlAvailable(editorPaneImpl.getSWTPeer())) {
            loadBrowserEditorPane();
        }
        editorPaneImpl.setPage(url); 
    }
    public void setPage(String url) throws IOException { setPage(new URL(url)); }
    public void addHyperlinkListener(swingwtx.swing.event.HyperlinkListener l) { editorPaneImpl.addHyperlinkListener(l); }
    public void removeHyperlinkListener(swingwtx.swing.event.HyperlinkListener l) { editorPaneImpl.removeHyperlinkListener(l); }
    public void setCaretPosition(int pos) { editorPaneImpl.setCaretPosition(pos); }
    public int getCaretPosition() { return editorPaneImpl.getCaretPosition(); }
    public int getSelectionStart() { return editorPaneImpl.getSelectionStart(); }
    public int getSelectionEnd() { return editorPaneImpl.getSelectionEnd(); }
    public EditorKit getEditorKit() { return editorPaneImpl.getEditorKit(); }
    public void setEditorKit(EditorKit k) { editorPaneImpl.setEditorKit(k); }
    public void setSelectionColor(Color color) { editorPaneImpl.setSelectionColor(color); }    
    public Color getSelectionColor(){ return editorPaneImpl.getSelectionColor(); }
    
}

/*
 
   $Log: JEditorPane.java,v $
   Revision 1.27  2004/11/01 13:08:45  bobintetley
   Editorpane defaults to browser since most people will use it for that

   Revision 1.26  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.25  2004/10/29 10:24:06  bobintetley
   Separate EditorPane implementations to decouple platform specifics,
   stubbing of HTMLEditorKit

   Revision 1.24  2004/10/19 14:22:04  bobintetley
   Start of JEditorPane StyledDocument support and fixes to native build script

   Revision 1.23  2004/09/17 19:11:11  dannaab
   Load documents in-memory and set with Browser.setText() instead of creating temp files

   Revision 1.22  2004/04/30 13:20:43  bobintetley
   Fix to unrealised peer preferred sizes, forwarding window events to
   content panes and fix for mouse drag events.

   Revision 1.21  2004/04/28 08:38:11  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.20  2004/03/18 16:21:37  bobintetley
   JTextComponent/Caret implementation and fix to JFileChooser for bug in GNU classpath

   Revision 1.19  2004/02/24 09:26:34  bobintetley
   Better explanation when no Mozilla found

   Revision 1.18  2004/02/24 09:12:17  bobintetley
   Hyperlink.ENTERED now fires correctly

   Revision 1.17  2004/02/20 10:22:07  bobintetley
   GCJ/GIJ compatible replacement for StringBuffer.indexOf()

   Revision 1.16  2004/02/12 10:49:45  bobintetley
   No more ugly runtime exceptions if Mozilla is unavailable

   Revision 1.15  2004/02/12 09:55:53  bobintetley
   JEditorPane Document support

   Revision 1.14  2004/01/27 09:39:30  bobintetley
   Text/Document support

   Revision 1.13  2004/01/27 09:05:10  bobintetley
   ListModel and List Selection implemented. ScrollPane fix so all components
      scrollable

   Revision 1.12  2003/12/16 17:46:17  bobintetley
   Additional thread safety methods

   Revision 1.11  2003/12/16 13:14:33  bobintetley
   Use of SwingWTUtils.isSWTControlAvailable instead of null test

   Revision 1.10  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.9  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.8  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/
