/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JPopupMenu.java,v $
   Revision 1.14  2004/09/30 18:19:30  dannaab
   ButtonGroup, Popup listener fixes

   Revision 1.13  2004/06/08 09:24:23  dannaab
   Rename Component.getPeer() -> getSWTPeer().  added ComponentPeer and stubbed out support classes.

   Revision 1.12  2004/05/05 12:43:21  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.11  2004/04/18 12:45:59  bobintetley
   Popup menu fix to recreate peers when the peer's parent is destroyed

   Revision 1.10  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.9  2004/01/15 10:11:15  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.8  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.7  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwtx.swing.event.*;

import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import java.util.*;

public class JPopupMenu extends JMenuBar {
    
    protected Vector popupListeners = new Vector();
    
    protected final static int CANCELED = 0;
    protected final static int INVISIBLE = 1;
    protected final static int VISIBLE = 2;
    
    public JPopupMenu() { }
    public JPopupMenu(String label) { }
    
    /** Only to be used by JMenu on demand for getPopupMenu() */
    protected JPopupMenu(Vector childComponents) { this.components = childComponents; }
    
    public void addPopupMenuListener(PopupMenuListener l) {
        popupListeners.add(l);
    }
    
    public void removePopupMenuListener(PopupMenuListener l) {
        popupListeners.remove(l);
    }
    
    public void processPopupMenuEvent(int id) {
        Iterator i = popupListeners.iterator();
        PopupMenuEvent e = new PopupMenuEvent(this);
        while (i.hasNext()) {
            PopupMenuListener l = (PopupMenuListener) i.next();
            switch(id) {
                case CANCELED: l.popupMenuCanceled(e); break;
                case INVISIBLE: l.popupMenuWillBecomeInvisible(e); break;
                case VISIBLE: l.popupMenuWillBecomeVisible(e); break;
            }
        }
    }
    
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b)
            processPopupMenuEvent(VISIBLE);
        else {
            processPopupMenuEvent(INVISIBLE);
            processPopupMenuEvent(CANCELED);
        }
    }
    
    public void show(swingwt.awt.Component c, int x, int y) { 
        
        // Create the actual menu if it hasn't been already
        // and tie it to the component
	boolean needToCreatePeer = menu == null;
	if (!needToCreatePeer)
	    needToCreatePeer = menu.isDisposed();
	
        if (needToCreatePeer) {
            setSwingWTParent(c.getSWTPeer().getShell());
            c.getSWTPeer().setMenu(menu);
        }
        
        // activate it's popup menu:
        menu.setVisible(true);
        
    }

    public void setSwingWTParent(Shell parent) {
        shell = parent;
        menu = new Menu(parent, SWT.POP_UP);
        // If we have some children waiting to be added, do it now
        if (components.size() > 0) {
             Iterator i = components.iterator();
             while (i.hasNext()) {
                  add((JSWTMenuComponent) i.next());
             }
        }
        menu.addMenuListener((MenuListener) new MenuListener() {
            
			public void menuHidden(MenuEvent arg0) {
	            processPopupMenuEvent(INVISIBLE);
	            processPopupMenuEvent(CANCELED);
			}

			public void menuShown(MenuEvent arg0) {
                processPopupMenuEvent(VISIBLE);
			}
        	
        });
    }   
    
}
