/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: EmptyBorder.java,v $
   Revision 1.4  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.border;

import swingwt.awt.*;

public class EmptyBorder extends AbstractBorder implements Border {
    protected int left, right, top, bottom;

    public EmptyBorder(Insets borderInsets) {
        this(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right);
    }
    public EmptyBorder(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Insets getBorderInsets(Component c) { return getBorderInsets(); }
    public Insets getBorderInsets() { return new Insets(top, left, bottom, right); }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = top;
        insets.left = left;
        insets.bottom = bottom;
        insets.right = right;
        return insets;
    }
}
