/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.HistogramWindowPanel;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class HistogramWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter = null;
    private Function function = null;
    private JMenu windowsMenu = null;
    private JMenu unitsSubMenu = null;
    private JScrollPane sp = null;
    private HistogramWindowPanel panel = null;
    private Vector data = null;
    private int valueType = 2;
    private int units = 0;
    private JCheckBoxMenuItem slidersCheckBox = null;
    private JLabel numBinsLabel = new JLabel("Number of Bins");
    private JSlider numBinsSlider = new JSlider(0, 100, 10);
    private int numBins = 10;

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Options");
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Number of Bins Slider", false);
        this.slidersCheckBox.addActionListener(this);
        jMenu3.add(this.slidersCheckBox);
        Object var6_6 = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.unitsSubMenu = new JMenu("Select Units");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jMenu3.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Subroutines", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive Per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jMenu3.add(jMenu);
        jMenu3.addMenuListener(this);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu4 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu4.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu4.add(jMenuItem);
        jMenu4.addMenuListener(this);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(this.windowsMenu);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
    }

    public HistogramWindow(ParaProfTrial paraProfTrial, DataSorter dataSorter, Function function) {
        this.ppTrial = paraProfTrial;
        this.dataSorter = dataSorter;
        this.function = function;
        this.setTitle("Histogram: " + paraProfTrial.getTrialIdentifier(true));
        this.setLocation(new Point(300, 200));
        this.setSize(new Dimension(670, 630));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HistogramWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        this.setupMenus();
        this.numBinsSlider.setPaintTicks(true);
        this.numBinsSlider.setMajorTickSpacing(50);
        this.numBinsSlider.setMinorTickSpacing(10);
        this.numBinsSlider.setPaintLabels(true);
        this.numBinsSlider.setSnapToTicks(false);
        this.numBinsSlider.addChangeListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new HistogramWindowPanel(paraProfTrial, this);
        this.sp = new JScrollPane(this.panel);
        this.setHeader();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.95;
        gridBagConstraints.weighty = 0.98;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block27: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block27;
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                    break block27;
                }
                if (string.equals("Preferences...")) {
                    this.ppTrial.getPreferences().showPreferencesWindow();
                    break block27;
                }
                if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                    break block27;
                }
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                    break block27;
                }
                if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                    break block27;
                }
                if (string.equals("Exclusive")) {
                    this.valueType = 2;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Inclusive")) {
                    this.valueType = 4;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Number of Calls")) {
                    this.valueType = 6;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Number of Subroutines")) {
                    this.valueType = 8;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Inclusive Per Call")) {
                    this.valueType = 10;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Microseconds")) {
                    this.units = 0;
                    this.setHeader();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Milliseconds")) {
                    this.units = 1;
                    this.setHeader();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Seconds")) {
                    this.units = 2;
                    this.setHeader();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("hr:min:sec")) {
                    this.units = 3;
                    this.setHeader();
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Show Number of Bins Slider")) {
                    if (this.slidersCheckBox.isSelected()) {
                        this.displaySliders(true);
                    } else {
                        this.displaySliders(false);
                    }
                    break block27;
                }
                if (string.equals("Show ParaProf Manager")) {
                    new ParaProfManagerWindow().show();
                    break block27;
                }
                if (string.equals("Show Function Ledger")) {
                    new LedgerWindow(this.ppTrial, 0).show();
                    break block27;
                }
                if (string.equals("Show Group Ledger")) {
                    new LedgerWindow(this.ppTrial, 1).show();
                    break block27;
                }
                if (string.equals("Show User Event Ledger")) {
                    new LedgerWindow(this.ppTrial, 2).show();
                    break block27;
                }
                if (string.equals("Show Call Path Relations")) {
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.ppTrial, -1, -1, -1, this.dataSorter, 2);
                    this.ppTrial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                    break block27;
                }
                if (string.equals("Close All Sub-Windows")) {
                    this.ppTrial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                    break block27;
                }
                if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                    break block27;
                }
                if (string.equals("Show Help Window")) {
                    this.help(true);
                    break block27;
                }
                throw new ParaProfException("The menu item '" + string + "' is not implemented!");
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove(this.sp);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.numBinsLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.numBinsSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.sp, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.numBinsLabel);
            container.remove(this.numBinsSlider);
            container.remove(this.sp);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.sp, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.ppTrial.isTimeMetric()) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
            if (this.ppTrial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.ppTrial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.numBins = this.numBinsSlider.getValue();
            if (this.numBins < 1) {
                this.numBins = 1;
            }
            this.panel.repaint();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the histogram window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you a histogram of all of the values for this function.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different types of data to display.");
        ParaProf.helpWindow.writeText("");
    }

    private void sortLocalData() {
        this.data = this.dataSorter.getFunctionData(this.function, 0, false);
    }

    public void setHeader() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        Preferences preferences = this.ppTrial.getPreferences();
        jTextArea.setFont(new Font(preferences.getParaProfFont(), preferences.getFontStyle(), preferences.getFontSize()));
        jTextArea.append(this.getHeaderString());
        this.sp.setColumnHeaderView(jTextArea);
    }

    public String getHeaderString() {
        if (this.valueType > 5) {
            return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getSelectedMetricID()) + "\n" + "Name: " + this.function.getName() + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n";
        }
        return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getSelectedMetricID()) + "\n" + "Name: " + this.function.getName() + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.ppTrial.isTimeMetric(), (boolean)this.ppTrial.isDerivedMetric()) + "\n";
    }

    public Vector getData() {
        return this.data;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            this.setVisible(false);
            this.ppTrial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public int getValueType() {
        return this.valueType;
    }

    public int units() {
        if (this.valueType > 5) {
            return 0;
        }
        return this.units;
    }

    public void setNumBins(int n) {
        this.numBins = n;
        this.panel.repaint();
    }

    public int getNumBins() {
        return this.numBins;
    }
}

