/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DatabaseAPI;
import edu.uoregon.tau.dms.dss.DatabaseException;
import edu.uoregon.tau.paraprof.DataSourceThreadControl;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfObserver;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class LoadTrialProgressWindow
extends JFrame
implements ActionListener,
ParaProfObserver {
    private ParaProfManagerWindow paraProfManager = null;
    private JProgressBar progressBar = null;
    private DataSource dataSource = null;
    private ParaProfTrial ppTrial = null;
    private boolean aborted = false;
    private JLabel label;
    private boolean dbUpload = false;
    private Timer jTimer;

    public LoadTrialProgressWindow(ParaProfManagerWindow paraProfManagerWindow, DataSource dataSource, ParaProfTrial paraProfTrial) {
        this.dataSource = dataSource;
        this.ppTrial = paraProfTrial;
        this.paraProfManager = paraProfManagerWindow;
        int n = 300;
        int n2 = 120;
        Point point = paraProfManagerWindow.getLocationOnScreen();
        Dimension dimension = paraProfManagerWindow.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        this.setLocation(n5, n6);
        this.setSize(new Dimension(n, n2));
        this.setTitle("Loading...");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoadTrialProgressWindow.this.thisWindowClosing(windowEvent);
            }
        });
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.label = new JLabel("Loading Profile Data...");
        this.addCompItem(this.label, gridBagConstraints, 0, 0, 1, 1);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints.fill = 2;
        this.addCompItem(this.progressBar, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        this.addCompItem(jButton, gridBagConstraints, 0, 3, 1, 1);
        this.jTimer = new Timer(200, this);
        this.jTimer.start();
        DataSourceThreadControl dataSourceThreadControl = new DataSourceThreadControl();
        dataSourceThreadControl.addObserver(this);
        dataSourceThreadControl.initialize(dataSource);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof Timer) {
                if (this.dbUpload) {
                    DatabaseAPI databaseAPI = this.ppTrial.getDatabaseAPI();
                    if (databaseAPI != null) {
                        int n = databaseAPI.getProgress();
                        this.progressBar.setValue(n);
                    }
                } else {
                    int n = this.dataSource.getProgress();
                    if (n > 99) {
                        n = 99;
                    }
                    this.progressBar.setValue(n);
                }
            } else {
                String string = actionEvent.getActionCommand();
                if (string.equals("Cancel")) {
                    this.aborted = true;
                    if (this.dbUpload) {
                        DatabaseAPI databaseAPI = this.ppTrial.getDatabaseAPI();
                        databaseAPI.cancelUpload();
                    } else {
                        this.dataSource.cancelLoad();
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void finishDatabase(boolean bl) {
        if (bl && !this.aborted) {
            ParaProf.paraProfManager.populateTrialMetrics(this.ppTrial);
            this.progressBar.setValue(100);
            this.ppTrial.showMainWindow();
        }
        this.jTimer.stop();
        this.dispose();
    }

    public void update(Object object) {
        if (object instanceof Exception) {
            ParaProfUtils.handleException((Exception)object);
            this.jTimer.stop();
            this.dispose();
        } else if (this.aborted) {
            this.jTimer.stop();
            this.dispose();
        } else {
            this.progressBar.setValue(99);
            if (this.ppTrial.upload()) {
                this.label.setText("Uploading Trial");
                this.progressBar.setValue(0);
                this.dbUpload = true;
                new UpdateRunner(this);
            } else {
                try {
                    this.ppTrial.update(this.dataSource);
                    this.progressBar.setValue(100);
                    this.ppTrial.showMainWindow();
                }
                catch (DatabaseException databaseException) {
                    ParaProfUtils.handleException((Exception)((Object)databaseException));
                }
                this.jTimer.stop();
                this.dispose();
            }
        }
    }

    public void update() {
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            this.aborted = true;
            if (this.dbUpload) {
                DatabaseAPI databaseAPI = this.ppTrial.getDatabaseAPI();
                databaseAPI.cancelUpload();
            } else {
                this.dataSource.cancelLoad();
            }
            this.jTimer.stop();
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    class UpdateRunner
    implements Runnable {
        LoadTrialProgressWindow ltpw;

        UpdateRunner(LoadTrialProgressWindow loadTrialProgressWindow2) {
            this.ltpw = loadTrialProgressWindow2;
            Thread thread = new Thread(this);
            thread.start();
        }

        public void run() {
            try {
                LoadTrialProgressWindow.this.ppTrial.update(LoadTrialProgressWindow.this.dataSource);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        UpdateRunner.this.ltpw.finishDatabase(true);
                    }
                });
            }
            catch (DatabaseException databaseException) {
                ParaProfUtils.handleException((Exception)((Object)databaseException));
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        UpdateRunner.this.ltpw.finishDatabase(false);
                    }
                });
            }
        }
    }
}

