/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ApplicationManager;
import edu.uoregon.tau.paraprof.HelpWindow;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfLisp;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.SavedPreferences;
import jargs.gnu.CmdLineParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.swing.Timer;

public class ParaProf
implements ActionListener {
    private static final String VERSION = "2.1 (with TAU 2.14.1) (01/21/2005)";
    static String homeDirectory = null;
    static File paraProfHomeDirectory = null;
    static String profilePathName = null;
    static int defaultNumberPrecision = 6;
    static boolean dbSupport = false;
    static ParaProfLisp paraProfLisp = null;
    static SavedPreferences savedPreferences = null;
    static ParaProfManagerWindow paraProfManager = null;
    static ApplicationManager applicationManager = null;
    static HelpWindow helpWindow = null;
    static Runtime runtime = null;
    private static int numWindowsOpen = 0;
    private static int fileType = 0;
    private static File[] sourceFiles = new File[0];
    private static boolean fixNames = false;
    private ParaProfTrial pptrial = null;

    private static void usage() {
        System.err.println("Usage: paraprof [-d] [-p] [-i] [-f <filetype>] <files/directory>\n\ntry `paraprof --help` for more information");
    }

    private static void outputHelp() {
        System.err.println("Usage: paraprof [options] <files/directory> \n\nOptions:\n\n  -f, --filetype <filetype>        Specify type of performance data, options are:\n                                   profiles (default), pprof, dynaprof, mpip,\n                                   gprof, psrun, hpm\n  -h, --help                       Display this help message\n  -p                               Use `pprof` to compute derived data\n  -d, --debug                      Turn debug statements on\n  -i, --fixnames                   Use the fixnames option for gprof\n\nNotes:\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\n");
    }

    static void incrementNumWindows() {
        ++numWindowsOpen;
    }

    static void decrementNumWindows() {
        if (--numWindowsOpen <= 0) {
            ParaProf.exitParaProf(0);
        }
    }

    public void loadDefaultTrial() {
        applicationManager = new ApplicationManager();
        ParaProfApplication paraProfApplication = applicationManager.addApplication();
        paraProfApplication.setName("Default App");
        ParaProfExperiment paraProfExperiment = paraProfApplication.addExperiment();
        paraProfExperiment.setName("Default Exp");
        helpWindow = new HelpWindow();
        paraProfManager = new ParaProfManagerWindow();
        paraProfManager.addTrial(paraProfApplication, paraProfExperiment, sourceFiles, fileType, fixNames);
    }

    public void startSystem() {
        try {
            savedPreferences = new SavedPreferences();
            paraProfHomeDirectory = new File(homeDirectory + "/.ParaProf");
            if (paraProfHomeDirectory.exists()) {
                Object object;
                block8: {
                    try {
                        object = new FileInputStream(paraProfHomeDirectory.getPath() + "/ParaProf.prefs");
                        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                        savedPreferences = (SavedPreferences)objectInputStream.readObject();
                        savedPreferences.setLoaded(true);
                    }
                    catch (Exception exception) {
                        if (exception instanceof FileNotFoundException) break block8;
                        System.out.println("There was an error while trying to read the ParaProf preferences file.");
                        System.out.println("Please delete this file, or replace it with a valid one!");
                        System.out.println("Note: Deleting the file will cause ParaProf to restore the default preferences");
                    }
                }
                object = new File(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                if (((File)object).exists()) {
                    savedPreferences.setDatabaseConfigurationFile(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                } else {
                    System.out.println("Did not find db configuration file ... load manually");
                }
            } else {
                System.out.println("Did not find ParaProf home directory ... creating ...");
                paraProfHomeDirectory.mkdir();
                System.out.println("Done creating ParaProf home directory!");
            }
            this.loadDefaultTrial();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            System.out.println("------------------------");
            System.out.println("The amount of memory used by the system is: " + runtime.totalMemory());
            System.out.println("The amount of memory free to the system is: " + runtime.freeMemory());
        }
    }

    public static String getInfoString() {
        long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        return new String("ParaProf Version " + ParaProf.getVersionString() + "\n Java Heap Size: " + l + "kb");
    }

    public static String getVersionString() {
        return new String(VERSION);
    }

    public static void exitParaProf(int n) {
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        homeDirectory = System.getProperty("user.home");
        ParaProf paraProf = new ParaProf();
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('d', "debug");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('i', "fixnames");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println("paraprof: " + optionException.getMessage());
            ParaProf.usage();
            ParaProf.exitParaProf(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option2);
        String string = (String)cmdLineParser.getOptionValue(option4);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option5);
        if (bl != null && bl.booleanValue()) {
            ParaProf.outputHelp();
            ParaProf.exitParaProf(-1);
        }
        String[] stringArray2 = cmdLineParser.getRemainingArgs();
        sourceFiles = new File[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            ParaProf.sourceFiles[i] = new File(stringArray2[i]);
        }
        if (bl3 != null) {
            fixNames = bl3;
        }
        if (string != null) {
            if (string.equals("profiles")) {
                fileType = 0;
            } else if (string.equals("pprof")) {
                fileType = 1;
            } else if (string.equals("dynaprof")) {
                fileType = 2;
            } else if (string.equals("mpip")) {
                fileType = 3;
            } else if (string.equals("hpm")) {
                fileType = 4;
            } else if (string.equals("gprof")) {
                fileType = 5;
            } else if (string.equals("psrun")) {
                fileType = 6;
            } else {
                System.err.println("Please enter a valid file type.");
                ParaProf.usage();
                ParaProf.exitParaProf(-1);
            }
        }
        runtime = Runtime.getRuntime();
        paraProf.startSystem();
    }
}

