/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionDataWindowPanel;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FunctionDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private double maxValue;
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter = null;
    private Function function = null;
    private JMenu optionsMenu = null;
    private JMenu windowsMenu = null;
    private JMenu unitsSubMenu = null;
    private JCheckBoxMenuItem sortByNCT = null;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem showValuesAsPercent = null;
    private JCheckBoxMenuItem displaySliders = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JLabel sliderMultipleLabel = new JLabel("Slider Multiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Multiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private FunctionDataWindowPanel panel = null;
    private JScrollPane sp = null;
    private Vector list = null;
    private boolean nct = true;
    private int order = 1;
    private boolean percent = true;
    private int valueType = 2;
    private int units = 0;

    public void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        this.optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.sortByNCT = new JCheckBoxMenuItem("Sort By N,C,T", true);
        this.sortByNCT.addActionListener(this);
        this.optionsMenu.add(this.sortByNCT);
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", false);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        this.showValuesAsPercent = new JCheckBoxMenuItem("Show Values as Percent", true);
        this.showValuesAsPercent.addActionListener(this);
        this.optionsMenu.add(this.showValuesAsPercent);
        this.unitsSubMenu = new JMenu("Select Units");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Subroutines", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive Per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Display Sliders", false);
        jCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(jCheckBoxMenuItem);
        this.showPathTitleInReverse = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
        this.showPathTitleInReverse.addActionListener(this);
        this.optionsMenu.add(this.showPathTitleInReverse);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.addMenuListener(this);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Histogram");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenu3.addMenuListener(this);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(this.windowsMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
    }

    public FunctionDataWindow(ParaProfTrial paraProfTrial, Function function, DataSorter dataSorter) {
        this.ppTrial = paraProfTrial;
        this.dataSorter = dataSorter;
        this.function = function;
        int n = 650;
        int n2 = 550;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        if (n > n4) {
            n = n4;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        int n5 = (n4 - n) / 2;
        int n6 = (n3 - n2) / 2;
        ((Component)this).setSize(new Dimension(n, n2));
        ((Component)this).setLocation(n5, n6);
        this.setTitle("Function Data Window: " + paraProfTrial.getTrialIdentifier(true));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FunctionDataWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        this.setupMenus();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new FunctionDataWindowPanel(paraProfTrial, function, this);
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setHeader();
        String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
        this.sliderMultiple = new JComboBox<String>(stringArray);
        this.sliderMultiple.addActionListener(this);
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(5);
        this.barLengthSlider.setMinorTickSpacing(1);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(true);
        this.barLengthSlider.addChangeListener(this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                    return;
                } else if (string.equals("Preferences...")) {
                    this.ppTrial.getPreferences().showPreferencesWindow();
                    return;
                } else if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                    return;
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                    return;
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                    return;
                } else if (string.equals("Sort By N,C,T")) {
                    this.nct = this.sortByNCT.isSelected();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Descending Order")) {
                    this.order = this.descendingOrder.isSelected() ? 0 : 1;
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Show Values as Percent")) {
                    this.percent = this.showValuesAsPercent.isSelected();
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Exclusive")) {
                    this.valueType = 2;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Inclusive")) {
                    this.valueType = 4;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Number of Calls")) {
                    this.valueType = 6;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Number of Subroutines")) {
                    this.valueType = 8;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Inclusive Per Call")) {
                    this.valueType = 10;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Microseconds")) {
                    this.units = 0;
                    this.setHeader();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Milliseconds")) {
                    this.units = 1;
                    this.setHeader();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Seconds")) {
                    this.units = 2;
                    this.setHeader();
                    this.panel.repaint();
                    return;
                } else if (string.equals("hr:min:sec")) {
                    this.units = 3;
                    this.setHeader();
                    this.panel.repaint();
                    return;
                } else if (string.equals("Display Sliders")) {
                    if (((JCheckBoxMenuItem)this.optionsMenu.getItem(5)).isSelected()) {
                        this.displaySliders(true);
                        return;
                    } else {
                        this.displaySliders(false);
                    }
                    return;
                } else if (string.equals("Show ParaProf Manager")) {
                    new ParaProfManagerWindow().show();
                    return;
                } else if (string.equals("Show Path Title in Reverse")) {
                    this.setTitle("Function Data Window: " + this.ppTrial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    return;
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                    return;
                } else if (string.equals("Show Function Ledger")) {
                    new LedgerWindow(this.ppTrial, 0).show();
                    return;
                } else if (string.equals("Show Group Ledger")) {
                    new LedgerWindow(this.ppTrial, 1).show();
                    return;
                } else if (string.equals("Show User Event Ledger")) {
                    new LedgerWindow(this.ppTrial, 2).show();
                    return;
                } else if (string.equals("Show Call Path Relations")) {
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.ppTrial, -1, -1, -1, this.getDataSorter(), 2);
                    this.ppTrial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                    return;
                } else if (string.equals("Show Histogram")) {
                    HistogramWindow histogramWindow = new HistogramWindow(this.ppTrial, this.getDataSorter(), this.function);
                    this.ppTrial.getSystemEvents().addObserver(histogramWindow);
                    histogramWindow.show();
                    return;
                } else if (string.equals("Close All Sub-Windows")) {
                    this.ppTrial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                    return;
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                    return;
                } else {
                    if (!string.equals("Show Help Window")) throw new RuntimeException("Menu system not implemented properly");
                    this.help(true);
                }
                return;
            } else {
                if (object != this.sliderMultiple) return;
                this.panel.changeInMultiples();
            }
            return;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.changeInMultiples();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.valueType > 4) {
                this.showValuesAsPercent.setEnabled(false);
                this.unitsSubMenu.setEnabled(false);
            } else if (this.percent) {
                this.showValuesAsPercent.setEnabled(true);
                this.unitsSubMenu.setEnabled(false);
            } else if (this.ppTrial.isTimeMetric()) {
                this.showValuesAsPercent.setEnabled(true);
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.showValuesAsPercent.setEnabled(true);
                this.unitsSubMenu.setEnabled(false);
            }
            if (this.ppTrial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.ppTrial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            if (!this.ppTrial.isTimeMetric()) {
                this.units = 0;
            }
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the function data window for:");
        ParaProf.helpWindow.writeText(this.function.getName());
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you this function's statistics across all the threads.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText("for this function.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public void sortLocalData() {
        this.list = this.nct ? this.dataSorter.getFunctionData(this.function, 30 + this.order, true) : this.dataSorter.getFunctionData(this.function, this.valueType + this.order, true);
        this.maxValue = 0.0;
        Iterator iterator = ((AbstractList)this.list).iterator();
        while (iterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
            double d = ParaProfUtils.getValue(pPFunctionProfile, this.getValueType(), this.isPercent());
            this.maxValue = Math.max(this.maxValue, d);
        }
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Vector getData() {
        return this.list;
    }

    public int getValueType() {
        return this.valueType;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public int units() {
        if (this.percent) {
            return 0;
        }
        if (this.valueType > 5) {
            return 0;
        }
        return this.units;
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            Preferences preferences = this.ppTrial.getPreferences();
            jTextArea.setFont(new Font(preferences.getParaProfFont(), preferences.getFontStyle(), preferences.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.valueType > 5 || this.percent) {
            return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getSelectedMetricID()) + "\n" + "Name: " + this.function.getName() + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n";
        }
        return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getSelectedMetricID()) + "\n" + "Name: " + this.function.getName() + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.ppTrial.isTimeMetric(), (boolean)this.ppTrial.isDerivedMetric()) + "\n";
    }

    public int getSliderValue() {
        int n = -1;
        n = this.barLengthSlider.getValue();
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        string = (String)this.sliderMultiple.getSelectedItem();
        return Double.parseDouble(string);
    }

    private void displaySliders(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            this.getContentPane().remove(this.sp);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.sliderMultipleLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.sliderMultiple, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 2, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 3, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 100.0;
            this.addCompItem(this.sp, gridBagConstraints, 0, 1, 4, 1);
        } else {
            this.getContentPane().remove(this.sliderMultipleLabel);
            this.getContentPane().remove(this.sliderMultiple);
            this.getContentPane().remove(this.barLengthLabel);
            this.getContentPane().remove(this.barLengthSlider);
            this.getContentPane().remove(this.sp);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 100.0;
            this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.ppTrial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }
}

