/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class ParaProfUtils {
    private ParaProfUtils() {
    }

    public static void print(Printable printable) {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.defaultPage();
        if (pageFormat2 != (pageFormat = printerJob.pageDialog(pageFormat2))) {
            printerJob.setPrintable(printable, pageFormat);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    ParaProfUtils.handleException(printerException);
                }
            }
        }
    }

    public static void scaleForPrint(Graphics graphics, PageFormat pageFormat, int n, int n2) {
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        int n3 = (int)((double)n / d) + 1;
        int n4 = (int)((double)n2 / d2) + 1;
        double d3 = d / (double)n;
        double d4 = d2 / (double)n2;
        double d5 = Math.min(d3, d4);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d3 > d5) {
            d6 = 0.5 * (d3 - d5) * (double)n;
        } else {
            d7 = 0.5 * (d4 - d5) * (double)n2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.translate(d6, d7);
        graphics2D.scale(d5, d5);
    }

    public static void handleException(Exception exception) {
        new ParaProfErrorDialog(exception);
    }

    public static double getValue(PPFunctionProfile pPFunctionProfile, int n, boolean bl) {
        double d = 0.0;
        switch (n) {
            case 2: {
                if (bl) {
                    d = pPFunctionProfile.getExclusivePercentValue();
                    break;
                }
                d = pPFunctionProfile.getExclusiveValue();
                break;
            }
            case 4: {
                if (bl) {
                    d = pPFunctionProfile.getInclusivePercentValue();
                    break;
                }
                d = pPFunctionProfile.getInclusiveValue();
                break;
            }
            case 6: {
                d = pPFunctionProfile.getNumberOfCalls();
                break;
            }
            case 8: {
                d = pPFunctionProfile.getNumberOfSubRoutines();
                break;
            }
            case 10: {
                d = pPFunctionProfile.getInclusivePerCall();
                break;
            }
            default: {
                throw new RuntimeException("Invalid Value Type: " + n);
            }
        }
        return d;
    }
}

