/*   FILE: bintree.h -- 
 * AUTHOR: W. Michael Petullo <strmap@flyn.org>
 *   DATE: 08 January 2000
 *   NOTE: From _Mastering Algorithms with C_ by Kyle Loudon.
 */

#ifndef _BINTREE_H
#define _BINTREE_H

#ifdef __cplusplus
extern "C" {
#endif
/* ============================ bintree_node_t ============================= */ typedef struct bintree_node_t {
	void *data;
	struct bintree_node_t *left;
	struct bintree_node_t *right;
    } bintree_node_t;

/* ============================ bintree_t ================================== */
    typedef struct bintree_t {
	int size;
	int (*compare) (const void *key_1, const void *key_2);
	void (*destroy) (void *data);
	bintree_node_t *root;
    } bintree_t;

/* ============================ bintree_init () ============================ */
    void bintree_init(bintree_t * tree, void (*destroy) (void *data));

/* ============================ bintree_destroy () ========================= */
    void bintree_destroy(bintree_t * tree);

/* ============================ bintree_ins_left () ======================== */
    int bintree_ins_left(bintree_t * tree, bintree_node_t * node,
			 const void *data);

/* ============================ bintree_ins_right () ======================= */
    int bintree_ins_right(bintree_t * tree, bintree_node_t * node,
			  const void *data);

/* ============================ bintree_rem_left () ======================== */
    void bintree_rem_left(bintree_t * tree, bintree_node_t * node);

/* ============================ bintree_rem_right () ======================= */
    void bintree_rem_right(bintree_t * tree, bintree_node_t * node);

/* ============================ bintree_merge () =========================== */
    int bintree_merge(bintree_t * merge, bintree_t * left,
		      bintree_t * right, const void *data);

/* ============================ bintree_size () ============================ */
#define bintree_size(tree) ((tree)->size)

/* ============================ bintree_root () ============================ */
#define bintree_root(tree) ((tree)->root)

/* ============================ bintree_is_eob () ========================== */
#define bintree_is_eob(node) ((node) == NULL)

/* ============================ bintree_is_leaf () ========================= */
#define bintree_is_leaf(node) ((node)->left == NULL && (node)->right == NULL)

/* ============================ bintree_data () ============================ */
#define bintree_data(node) ((node)->data)

/* ============================ bintree_left () ============================ */
#define bintree_left(node) ((node)->left)

/* ============================ bintree_right () =========================== */
#define bintree_right(node) ((node)->right)

#ifdef __cplusplus
}
#endif
#endif				/* _BINTREE_H */
