/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "auswahl.h"
#include "ConfigFile.H"
#include "commonElements.H"
#include <wx/image.h>
#include <wx/event.h>

BEGIN_EVENT_TABLE(Auswahldialog, wxDialog)
  EVT_BUTTON(KL, Auswahldialog::OnButton)
  EVT_BUTTON(LL, Auswahldialog::OnButton)
  EVT_BUTTON(CS, Auswahldialog::OnButton)
END_EVENT_TABLE()
  
Auswahldialog::Auswahldialog(wxWindow* parent, wxWindowID id,
			     const wxString& title, const wxPoint& pos, 
			     const wxSize& size, long style, const wxString& name)
  : wxDialog(parent, id, title, pos, size, style, name)
{
  this->logo = common::getLogo();

  this->btnLL = new wxButton(this, LL, _("&Lesson..."));
  this->btnLL->SetToolTip(_("Click here to start with a single lesson of your choice"));
  this->btnKL = new wxButton(this, KL, _("&Class..."));
  this->btnKL->SetToolTip(_("Click here to start in a new class or continue with an old one"));
  this->btnCS = new wxButton(this, CS, _("&Do the contest..."));
  this->btnCS->SetToolTip(_("Click here to do the contest... isn't this tip amazing?! ;-)"));
  this->btnCancel = new wxButton(this, wxID_CANCEL, _("Cancel"));
  this->btnCancel->SetToolTip(_("Dismiss this dialog"));

  wxBoxSizer* buttonSizer = new wxBoxSizer (wxVERTICAL);
  buttonSizer->Add(this->btnLL,1,wxEXPAND|wxALL,5);
  buttonSizer->Add(this->btnKL,1,wxEXPAND|wxALL,5);
  if (TtConfigFile::getPtr()->contestsExist()) {
    buttonSizer->Add(this->btnCS,1,wxEXPAND|wxALL,5);
  } else {
    btnCS->Hide();
  }
  buttonSizer->Add(this->btnCancel,1,wxEXPAND|wxALL,5);

  wxBoxSizer* dialogSizer = new wxBoxSizer (wxHORIZONTAL);
  if (this->logo != 0) {
    dialogSizer->Add(new MyCanvas(this, logo,
				  wxDefaultPosition,
				  wxSize(logo->GetWidth(),
					 logo->GetHeight())));
  }
  dialogSizer->Add(buttonSizer,0,wxEXPAND/*|wxALIGN_CENTER*/|wxALL,10);

  SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(this);
}

Auswahldialog::~Auswahldialog () {
}

void Auswahldialog::OnButton (wxCommandEvent& event) {
  EndModal(event.GetId());
}
